{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
<div class="container-fluid" id="CoreEditorDetails">
    <div class="widget_header row-fluid">
        <div class="span8"><h3>{vtranslate('LBL GEOTOOLS CORE EDITOR', $QUALIFIED_MODULE)}</h3></div>
            <div class="span4">
                <div class="pull-right">
                    <button class="btn editButton" data-url='{$MODULE_MODEL->getEditViewUrl()}' type="button" title="{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}">
                        <strong>{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}</strong>
                    </button>
                </div>
            </div>
    </div>
    <hr>
    <div class="contents">
        <table class="table table-bordered table-condensed themeTableColor">
            <thead>
                <tr class="blockHeader">
                    <th colspan="2">
                        <span class="alignMiddle">{vtranslate('LBL GEOTOOLS CONFIG', $QUALIFIED_MODULE)}</span>
                    </th>
                </tr>
            </thead>
            <tbody>
                {foreach from=$MODULE_MODEL->getFields() item=FIELD_TYPE key=FIELD}
                    <tr>
                        <td>{vtranslate($FIELD,$QUALIFIED_MODULE)}</td>
                        <td>
                            {if $FIELD_TYPE == 'icons'}
                                <span class="icon"><img src="{$MODULE_MODEL->get($FIELD)}" /></span>
                            {else if $FIELD_TYPE == 'picklist'}
                                {foreach key=optionName item=optionLabel from=$MODULE_MODEL->getPicklistValues($FIELD)}
                                    {if $optionName == {$MODULE_MODEL->get($FIELD)}}
                                        {vtranslate($optionLabel, $QUALIFIED_MODULE)}                                           
                                    {/if}
                                {/foreach}
                            {else}
                                {$MODULE_MODEL->get($FIELD)}
                            {/if}
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>
    </div>
</div>
{/strip}
