/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

jQuery.Class("Settings_EmailCampaigns_Js",{},{
    
    /*
     * function to Save the Configuration Editor content
     */
     
    saveConfigEditor : function(form) {
        var aDeferred = jQuery.Deferred();
        
        var data = form.serializeFormData();
        var updatedFields = {};
        jQuery.each(data, function(key, value) {
            updatedFields[key] = value;
        })
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'EmailCampaignDetailSaveAjax',
            'updatedFields' : JSON.stringify(updatedFields)
        }
        AppConnector.request(params).then(
            function(data) {
                aDeferred.resolve(data);
            },
            function(error,err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },

    registerDeactivateLicense : function(){
        $('#deactivate_license_btn').on('click',function(){
            var deactivateActionUrl = 'module='+app.getModuleName()+'&action=LicenseRemove';
            var message = app.vtranslate('JS_DEACTIVATE_QUESTION');
            Vtiger_Helper_Js.showConfirmationBox({'message': message}).then(function(data) {

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                        'enabled' : true
                }
            });
            
                AppConnector.request(deactivateActionUrl).then(
                function(data) {

                    if (data.result) {
                        var params = {
                        title: app.vtranslate('JS_DEACTIVATION_CONFIRMED'),
                        type: 'info'
                        };
                    } else {
                        var params = {
                        title : app.vtranslate('JS_DEACTIVATION_ERROR'),
                        type: 'error'
                        };
                    }
                    
                    window.location.reload();
                    Vtiger_Helper_Js.showMessage(params);
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    return;
                });
            });
        });
    },
    /*
     * Function to load the contents from the url through pjax
     */
    loadContents : function(url) {
        var aDeferred = jQuery.Deferred();
        AppConnector.requestPjax(url).then(
            function(data){
                aDeferred.resolve(data);
            },
            function(error, err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },
    
    registerEditViewEvents : function() {
        var thisInstance = this;
        var form = jQuery('#updatedetails');
        var detailUrl = form.data('detailUrl');

        //register validation engine
        var params = app.validationEngineOptions;
        params.onValidationComplete = function(form, valid){
            if(valid) {
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });
                thisInstance.saveConfigEditor(form).then(
                    function(data) {
                        var params = {};
                        if(data['success']) {
                            params['text'] = 'Settings successfully Saevd';
                            thisInstance.loadContents(detailUrl).then(
                                function(data) {
                                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                                    jQuery('.contentsDiv').html(data);
                                    thisInstance.registerDetailViewEvents();
                                }
                            );
                        } else {
                            progressIndicatorElement.progressIndicator({'mode':'hide'});
                            params['text'] = data['error']['message'];
                            params['type'] = 'error';
                        }
                        Settings_Vtiger_Index_Js.showMessage(params);
                    },function(error, err) {
                        progressIndicatorElement.progressIndicator({'mode':'hide'});
                    }
                );
                return valid;
            }
        }
        form.validationEngine(params);
        
        form.submit(function(e) {
            e.preventDefault();
        })
        
        //Register click event for cancel link
        var cancelLink = form.find('.cancelLink');
        cancelLink.click(function() {
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            thisInstance.loadContents(detailUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'})
                    jQuery('.contentsDiv').html(data);
                    thisInstance.registerDetailViewEvents();
                }
            );
        })
    },
    
    /*
     * function to register the events in DetailView
     */
    registerDetailViewEvents : function() {
        var thisInstance = this;
        var container = jQuery('#DetailEmailCampaignsSetting');
        var editButton = container.find('.editButton');
        
        //Register click event for edit button
        editButton.click(function() {
            var url = editButton.data('url');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            thisInstance.loadContents(url).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    jQuery('.contentsDiv').html(data);
                    thisInstance.registerEditViewEvents();
                }, function(error, err) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                }
            );
        });
        thisInstance.registerDeactivateLicense();
    },
    
    registerEvents: function() {
        var thisInstance = this;
        thisInstance.registerEditViewEvents();
        thisInstance.registerDetailViewEvents();
    }

});


jQuery(document).ready(function(){
    var settingModuleManagerInstance = new Settings_EmailCampaigns_Js();
    settingModuleManagerInstance.registerEvents();
    jQuery('.UpdateCheckModule').on('click', function(e) {
        var module = jQuery(e.currentTarget).data('module');
        jQuery.post('index.php', { 'module':module, 'parent':'Settings', 'view':'Upgrade', 'step' : 1}, function(response) {
            app.showModalWindow(response, function (data) {
                jQuery('.StartUpdate').on('click', function() {
                    jQuery('#RUNNING_UPDATE').show();

                    jQuery.post('index.php', { 'module':module, 'parent':'Settings', 'view':'Upgrade', 'step' : 3}, function(response) {
                        window.location.reload();
                    });
                });
            }); 
        });
    });

    if(app.getViewName()=='Edit') return;
    // Check enable
    var sPageURL = window.location.search.substring(1);
    var targetModule = '';
    var targetView = '';
    var targetRecord = '';
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == 'module') {
            targetModule = sParameterName[1];
        }
        else if (sParameterName[0] == 'view') {
            targetView = sParameterName[1];
        }
        else if (sParameterName[0] == 'record') {
            targetRecord = sParameterName[1];
        }
    }
    if (targetModule == 'EmailCampaigns' && targetView == 'EmailCampaignDetails') {
        /*var buttonContainer = jQuery('.detailViewContainer');
        var btnToolBar = buttonContainer.find('.btn-group');
        var outGoingServerBtn = jQuery('<button type="button" class="btn btn-default btnOutgoingServer">Manage SMTP Servers</button>');
        btnToolBar.find('.btn-default:last').before(outGoingServerBtn);*/
        var buttonContainer = jQuery('tr#smtpsettings');
        var outGoingServerBtn = jQuery('<button type="button" class="btn btn-default btnOutgoingServer">Manage SMTP Servers</button>');
        buttonContainer.find('td:last>span').after(outGoingServerBtn);

        var instance = new MultiSender();
        instance.registerEvents();
    }
});





jQuery.Class("MultiSender",{
    instance:false,
    getInstance: function(){
        if(MultiSender.instance == false){
            var instance = new MultiSender();
            MultiSender.instance = instance;
            return instance;
        }
        return MultiSender.instance;
    },
},{
    registerEventForOutgoingButton: function () {
        var thisInstance=this;
        jQuery('.btnOutgoingServer').unbind();
        jQuery('.btnOutgoingServer').on('click', function (e) {
            var url ='index.php?module=EmailCampaigns&view=MassActionAjax&mode=showListview';
            thisInstance.showListView(url);
        });
    },

    registerEventForEditButtons: function() {
        var thisInstance=this;
        jQuery('body').delegate('.edit_info','click',function(){
            var url_ = jQuery(this).data('url');
            $('button.close').trigger('click');
            var func= function(){ var url = url_;
                app.hideModalWindow();$('#overlayPageContent').remove();
                var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                        'enabled' : true
                }
            });
                var params = thisInstance.convertUrlToDataParams(url);
                AppConnector.request(params).then(
                    function (data) {
                            progressIndicatorElement.progressIndicator({'mode':'hide'});
                            app.showModalWindow(data);
                            var form = jQuery('#outgoingMassEditContainer');
                            form.on("click","button[name='saveButton']",function(e){
                                e.preventDefault();
                                thisInstance.saveOutgoingServer(form);
                            });
                        
                    }
                    );}; setTimeout(func, 2000);

            })
    },
    //#478958 End

    registerEventForDeleteRecord: function(){
        var thisInstance=this;
        jQuery('body').on('click','.delete_server',function(){
            var message = app.vtranslate('LBL_DELETE_CONFIRMATION');
            var url = jQuery(this).data('url');
            var userid = jQuery(this).data('userid');
            Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(
                function(){
                    thisInstance.deleteServer(url,userid);
                }
                );
        })
    },

    convertUrlToDataParams: function (url) {
            var params = {};
            if (typeof url !== 'undefined' && url.indexOf('?') !== -1) {
                var urlSplit = url.split('?');
                url = urlSplit[1];
            }
            var queryParameters = url.split('&');
            for (var index = 0; index < queryParameters.length; index++) {
                var queryParam = queryParameters[index];
                var queryParamComponents = queryParam.split('=');
                params[queryParamComponents[0]] = queryParamComponents[1];
            }
            return params;
        },

    showListView: function (url) {
        var thisInstance = this;
        app.hideModalWindow();
        var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
        popupShown = true;
        AppConnector.request(url).then(function(data,err) {
            progressIndicatorElement.progressIndicator({'mode':'hide'});
            if(err === undefined) {
                app.showModalWindow(data, {'cb' : function(modal) {
                    popupShown = false;
                }});

                thisInstance.loadListUserServer();
            }
        });
    },

    deleteServer: function (url,userid) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
        AppConnector.request(url).then(
            function(data,err){
                if(err == undefined && data.success==true) {
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    var new_url = 'index.php?module=EmailCampaigns&view=MassActionAjax&mode=showListview';
                    thisInstance.showListView(new_url);
                }
            }
            );
    },

    saveOutgoingServer : function(form) {
        var thisInstance = this;
        var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                        'enabled' : true
                }
            });
        var data = form.serializeFormData();
        data['module'] = 'EmailCampaigns';
        data['action'] = 'SaveAjax';
        data['mode'] = 'savesmtp';
        AppConnector.request(data).then(
            function(data){
                var params = {};
                    params['text'] = 'Outgoing Server Saved';
                    progressIndicatorElement.progressIndicator({'mode':'hide'});
                    app.hideModalWindow();
                    Settings_Vtiger_Index_Js.showMessage(params);
            },
            function(error) {
                params['text'] = error;
                params['type'] = 'error';
                app.hideModalWindow();
                Settings_Vtiger_Index_Js.showMessage(params);
                progressIndicatorElement.progressIndicator({'mode':'hide'});
                //TODO : Handle error
            }
            );
    },
    loadListUserServer: function () {
        var thisInstance = this;
        var blocks = jQuery('.blocksSortable');
        blocks.sortable({
            'revert': true,
            'connectWith': ".blocksSortable",
            'tolerance': 'pointer',
            'cursor': 'move',
            'placeholder': "state-highlight",
            'stop': function (event, ui) {
                thisInstance.updateSequence();
            }
        });
    },
    updateSequence: function () {
        var thisInstance = this;
        var params = {};
        $(".blockSortable").each(function (index) {
            //alert(index);
            params[$(this).data('id')] = {'index': index, 'column': $(this).closest('.blocksSortable').data('column')};
        });
        thisInstance.registerSaveEvent('updateSequence', {'data': params});
    },
    registerSaveEvent: function (mode, data) {
        var resp = '';
        var params = {};
        params.data = {
            module: 'EmailCampaigns',
            view: 'MassActionAjax',
            mode: mode,
            params: data
        };
        
        params.async = true;
        
        params.dataType = 'json';
        AppConnector.request(params).then(
            function (data) {
                var params={};
                params['text']=message;
                Settings_Vtiger_Index_Js.showMessage(params);
            },
            function (error) {
                var params={};
                params['text']="Error Saving";
                params['type'] = 'error';
                Settings_Vtiger_Index_Js.showMessage(params);
            }
            );
    },

    registerEvents: function(){
        this.registerEventForOutgoingButton();
        this.registerEventForEditButtons();
        this.registerEventForDeleteRecord();
    }
});