/*+**********************************************************************************
 * The content of this file is subject to the ITS4GoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

jQuery.Class("CalendarSidebarWidget", {
    self: false,
    getInstance: function () {
        if (this.self !== false) {
            return this.self;
        }
        this.self = new CalendarSidebarWidget();
        return this.self;
    },
    _init: function () {

        if(jQuery('#its4you_sync_button')){
            jQuery('#its4you_sync_button').on('click',function(){
                var syncButton = jQuery('#its4you_sync_button');
                var url = syncButton.data('url');
                var progressIndicator = jQuery.progressIndicator({
                    'position': 'html',
                    'blockInfo': {
                        'enabled': true
                    }
                });
                AppConnector.request(url).then(
                    function (data) {
                        progressIndicator.progressIndicator({'mode': 'hide'});
                        jQuery('#synctime').remove();
                        jQuery("#its4you_sync_details").html(data);
                    }
                );
            });
        }
    }
}, {
    //function is used, when the settings button is clicked
    initCalendarSettings: function () {

        var thisInstance = this;
        var params = {
            module: "ITS4YouGoogleCalendarSync",
            view: "CalendarSettings"
        };
        AppConnector.request(params).then(
            function (data) {

                var callbackCredentialsFunction = function (data) {
                    thisInstance.registerCredentialsFormValidation();
                    thisInstance.credentialsFormEvent();
                    thisInstance.registerTabClickEvent();
                    thisInstance.registerConnectToGoogleEvent();
                    thisInstance.removeConnection();
                    thisInstance.registerCredentialsType();
                };
                app.showModalWindow(data, function (data) {
                    if (typeof callbackCredentialsFunction == 'function') {
                        callbackCredentialsFunction(data);
                    }
                }, {'width': '1000px'});
            }
        );
    },
    registerCredentialsFormValidation: function () {
        var form = jQuery('#credentialsForm');
        var paramsValidation = app.getvalidationEngineOptions(true);
        paramsValidation.onValidationComplete = function (form, valid) {
            if (valid) {
                jQuery('#saveCredentials').trigger('click', [true]);
            }
            return false;
        };
        form.validationEngine(paramsValidation);
    },
    credentialsFormEvent: function () {
        var thisInstance = this;

        var form = jQuery('#credentialsForm');
        jQuery('#saveCredentials').on('click', function (e, save) {
            if (save) {
                var formData = form.serializeFormData();
                var params = {
                    module: "ITS4YouGoogleCalendarSync",
                    action: "SaveSettings",
                    formData: formData
                };

                var modalHeader = jQuery('.modal-header h3');
                modalHeader.progressIndicator({
                    smallLoadingImage: true,
                    imageContainerCss: {display: 'inline', 'margin-left': '18%', position: 'absolute'}
                });

                AppConnector.request(params).then(
                    function (data) {
                        modalHeader.progressIndicator({'mode': 'hide'});
                        if (data.result.success) {
                            params = {
                                title: data.result.title,
                                text: data.result.text,
                                type: 'success'
                            };
                            thisInstance.updateCredentialsContent();
                        } else {
                            params = {
                                title: data.result.title,
                                text: data.result.text,
                                type: 'error'
                            };
                        }

                        Vtiger_Helper_Js.showPnotify(params);


                    }
                );
            }
        });

        jQuery('#editCredentials').on('click', function (e) {
            var urlParams = {
                module: "ITS4YouGoogleCalendarSync",
                view: 'CalendarSettings',
                onlyCredentialsContent: true,
                dataType: 'json',
                mode: 'edit'
            };

            thisInstance.updateCredentialsContent(urlParams);
        });
    },
    registerConnectToGoogleEvent: function () {
        var thisInstance = this;
        jQuery('#connectToGoogle').on('click', function (e) {
            var authorize = true;
            var url = "index.php?module=ITS4YouGoogleCalendarSync&view=CalendarSettings&authorize="+true;
            var win=window.open(url,'','height=600,width=600,channelmode=1');

            window.sync = function() {
                thisInstance.updateCredentialsContent();
                var params = {
                    title: app.vtranslate('JS_SUCCESS'),
                    text: app.vtranslate('JS_CONNECTION_SUCCESSFUL'),
                    type: 'success'
                };

                Vtiger_Helper_Js.showPnotify(params);
            };

            win.onunload = function(){
            };
        });
    },
    updateCredentialsContent: function (urlParams) {
        var thisInstance = this;

        if(typeof urlParams == 'undefined') {
            var urlParams = {
                module: "ITS4YouGoogleCalendarSync",
                view: 'CalendarSettings',
                onlyCredentialsContent: true,
                dataType: 'json'
            };
        }

        jQuery('#calendarSettingsContents').empty();
        var modalHeader = jQuery('.modal-header h3');
        modalHeader.progressIndicator({
            smallLoadingImage: true,
            imageContainerCss: {display: 'inline', 'margin-left': '18%', position: 'absolute'}
        });
        AppConnector.request(urlParams).then(
            function (response) {
                jQuery('#calendarSettingsContents').html(response);
                modalHeader.progressIndicator({'mode': 'hide'});

                var ele = jQuery('.directionsSelect');
                app.changeSelectElementView(ele, 'select2');

                thisInstance.registerTabClickEvent();
                thisInstance.registerCredentialsFormValidation();
                thisInstance.credentialsFormEvent();
                thisInstance.registerConnectToGoogleEvent();
                thisInstance.removeConnection();
                thisInstance.registerCredentialsType();
            }
        );
    },
    registerTabClickEvent: function() {
        var thisInstance = this;
        jQuery("#vtigerToGoogleTab, #googleToVtigerTab").on('click', function (e) {
            var element = jQuery(e.currentTarget);
            var content = jQuery('#vtigerToGoogleContent');
            content.empty();
            var cssClass = 'selectGoogleCalendar';

            var params = {
                module: "ITS4YouGoogleCalendarSync",
                view: "ListAjax",
                mode: "showVtigerToGoogleContent"
            };

            if (element.hasClass('googleToVtigerTab')){
                content = jQuery('#googleToVtigerContent');
                params['mode'] = "showGoogleToVtigerTabContent";
                cssClass = 'selectActivityType';
            }

            var modalHeader = jQuery('.modal-header h3');
            modalHeader.progressIndicator({
                smallLoadingImage: true,
                imageContainerCss: {display: 'inline', 'margin-left': '18%', position: 'absolute'}
            });
            AppConnector.request(params).then(
                function (data) {
                    content.html(data);
                    modalHeader.progressIndicator({'mode': 'hide'});
                    thisInstance.updateSelectElementViewsInTabContent(cssClass);
                    thisInstance.registerVtigerToGoogleEvents();
                }
            );
        });
    },
    updateSelectElementViewsInTabContent: function (cssClass){
        jQuery('.'+cssClass).each(function (index, element) {
            var ele = jQuery(element);
            app.changeSelectElementView(ele, 'select2');

        });
    },
    submitVtigerToGoogleCalendarFormEvent: function () {
        var form = jQuery('#vtigerToGoogleForm');
        form.on('submit', function (e) {
            e.preventDefault();
            var formData = form.serializeFormData();
            var params = {
                module: "ITS4YouGoogleCalendarSync",
                action: 'SaveAjax',
                mode: 'saveVtigerTypeToGoogleCalendarMapping',
                formData: formData
            };

            var modalHeader = jQuery('.modal-header h3');
            modalHeader.progressIndicator({
                smallLoadingImage: true,
                imageContainerCss: {display: 'inline', 'margin-left': '18%', position: 'absolute'}
            });

            AppConnector.request(params).then(
                function (data) {

                    modalHeader.progressIndicator({'mode': 'hide'});
                    if (data.result.success) {
                        var params = {
                            title: data.result.title,
                            text: data.result.text,
                            type: 'success'
                        };

                        Vtiger_Helper_Js.showPnotify(params);
                    }
                }
            )
        });
    },
    registerVtigerToGoogleEvents: function () {
        this.submitVtigerToGoogleCalendarFormEvent();
        // this.submitGoogleToVtigerCalendarFormEvent();
    },
    removeConnection: function () {
        var thisInstance = this;
        jQuery('#removeConnection').on('click', function () {
            var params = {
                module: "ITS4YouGoogleCalendarSync",
                action: "RemoveConnection",
                dataType: 'json'
            };

            var modalHeader = jQuery('.modal-header h3');
            modalHeader.progressIndicator({
                smallLoadingImage: true,
                imageContainerCss: {display: 'inline', 'margin-left': '18%', position: 'absolute'}
            });
            
            AppConnector.request(params).then(
                function (data) {
                    modalHeader.progressIndicator({'mode': 'hide'});
                    if (data.result.success) {
                        var params = {
                            title: data.result.title,
                            text: data.result.text,
                            type: 'success'
                        };

                        Vtiger_Helper_Js.showPnotify(params);

                        thisInstance.updateCredentialsContent();
                    }
                }  
            );
        });
    },
    registerCredentialsType: function (){

        jQuery('#credentialsType').on('change', function(e){
            var element = jQuery(e.currentTarget);
            var type = element.val();

            var elementsCredentialsAttr = jQuery(".credentials-attr");
            if (type == "default") {
                elementsCredentialsAttr.addClass('hide');
            } else {
                elementsCredentialsAttr.removeClass('hide');
            }
        });
    },
    registerEvents: function () {

    }
});

jQuery('document').ready(function(){
    CalendarSidebarWidget._init();
});
