{*<!--
/*+**********************************************************************************
 * The content of this file is subject to the ITS4GoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/
-->*}

{strip}
    {foreach key=index item=jsModel from=$SCRIPTS}
        <script type="{$jsModel->getType()}" src="{$jsModel->getSrc()}"></script>
    {/foreach}
    <div class="row-fluid">
        <div class='padding10 span11'>
            {if $USER_CREDENTIALS eq 'not_set'}
                <div class="alert alert-info">
                    <span class="">{vtranslate('LBL_SET_CREDENTIALS', $QUALIFIED_MODULE)}</span>
                </div>
            {/if}
            {foreach item=ENTRY key=KEY from=$ACTION_LIST}
                <div class="row-fluid">
                    <div class='span12'>
                        <a href="{$ENTRY['href']}" id="{$ENTRY['id']}">{vtranslate($ENTRY['label'], "ITS4YouGoogleCalendarSync")}</a>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
    <div class='row-fluid'>
        <div class='padding10 span11'>
            <p class="muted" id='synctime'>
                {if $SYNCTIME eq false}
                    <small title="">
                        {vtranslate('LBL_NOT_SYNCHRONIZED', $QUALIFIED_MODULE)}
                    </small>
                {else}
                    <small title="{Vtiger_Util_Helper::formatDateTimeIntoDayString($SYNCTIME)}">{vtranslate('LBL_SYNCHRONIZED',$QUALIFIED_MODULE)}
                        : {Vtiger_Util_Helper::formatDateDiffInStrings($SYNCTIME)}</small>
                {/if}
            </p>
            <div id='its4you_sync_details'></div>
        </div>
        <span class='span0'>&nbsp;</span>
            <button id="its4you_sync_button" class="btn btn-success span9"  data-url='index.php?module=ITS4YouGoogleCalendarSync&view=List&operation=sync'><b>{vtranslate('LBL_SYNC_BUTTON',$QUALIFIED_MODULE)}</b></button>
    </div>
    <div class="row-fluid textAlignCenter">
        <div class="span10">
            <p class="muted">
                <small>{vtranslate('LBL_VERSION', $QUALIFIED_MODULE)}::{$VERSION}</small>
            </p>
        </div>
    </div>
{/strip}