/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
Vtiger_Popup_Js.extend('GeoTools_Popup_Js', {

    getInstance: function(){
        var module = 'GeoTools';
        var className = jQuery('#popUpClassName').val();
        if(typeof className != 'undefined'){
            var moduleClassName = className;
        }else{
            var moduleClassName = module+"_Popup_Js";
        }
        var fallbackClassName = Vtiger_Popup_Js;
        if(typeof window[moduleClassName] != 'undefined'){
            var instance = new window[moduleClassName]();
        }else{
            var instance = new fallbackClassName();
        }
        return instance;
    }

}, {

    /**
     * Function to get related parent module
     */
    getRelatedParentModule : function(){
        if(this.relatedParentModule == false){
            this.relatedParentModule = '';
        }
        return this.relatedParentModule;
    },
    
    updateMap: function(e){
        var thisInstance = this;
        var row  = jQuery(e.currentTarget);
        var listModule = $("select[name='moduleSelector']").val();
        var id = row.data('id');
        var response = {'id' : id, 'listModule' : listModule};

        thisInstance.done(response, thisInstance.getEventName());
        e.preventDefault();
    },
    
    done : function(result, eventToTrigger, window) {

        if(typeof eventToTrigger == 'undefined' || eventToTrigger.length <=0 ) {
            eventToTrigger = 'postSelection'
        }

        if(typeof window == 'undefined'){
            window = self;
        }
        window.close();
        var data = JSON.stringify(result);
        // Because if we have two dollars like this "$$" it's not working because it'll be like escape char(Email Templates)
        data = data.replace(/\$\$/g,"$ $");

        jQuery.triggerParentEvent(eventToTrigger, data);

    },
    
    /**
     * Function to get Page Records
     */
    getPageRecords : function(params){
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        Vtiger_BaseList_Js.getPageRecords(params).then(
                function(data){
                    jQuery('#popupContents').html(data);
                    Vtiger_Helper_Js.showHorizontalTopScrollBar();
                    progressIndicatorElement.progressIndicator({
                        'mode' : 'hide'
                    });
                    var popupPageContainer = jQuery('#popupPageContainer');
                    jQuery('input#module', popupPageContainer).val(params.tgt_module);
                    thisInstance.registerEventForSearch();
                    if(popupPageContainer.length > 0){
                        thisInstance.registerEventForTotalRecordsCount();
                        thisInstance.registerEventForPagination();
                    };
                    thisInstance.calculatePages().then(function(data){
                        aDeferred.resolve(data);
                    });
                },

                function(textStatus, errorThrown){
                    aDeferred.reject(textStatus, errorThrown);
                }
            );
        return aDeferred.promise();
    },
    
    
    /**
     * Function to get complete params
     */
    getCompleteParams : function(){
        var params = {};
        params['view'] = this.getView();
        params['src_module'] = this.getSourceModule();
        params['src_record'] = this.getSourceRecord();
        params['src_field'] = this.getSourceField();
        params['search_key'] =  this.getSearchKey();
        params['search_value'] =  this.getSearchValue();
        params['orderby'] =  this.getOrderBy();
        params['sortorder'] =  this.getSortOrder();
        params['page'] = this.getPageNumber();
        params['related_parent_module'] = '';
        params['related_parent_id'] = '';
        params['module'] = 'GeoTools';
        params['tgt_module'] = $("select[name='moduleSelector']").val();

        if(this.isMultiSelectMode()) {
            params['multi_select'] = true;
        }
        return params;
    },
    
    /**
     * Function to handle Sort
     */
    sortHandler : function(headerElement){
        var aDeferred = jQuery.Deferred();
        //Listprice column should not be sorted so checking for class noSorting
        if(headerElement.hasClass('noSorting')){
            return;
        }
        var fieldName = headerElement.data('columnname');
        var sortOrderVal = headerElement.data('nextsortorderval');
        var sortingParams = {
            "orderby" : fieldName,
            "sortorder" : sortOrderVal
        }
        var completeParams = this.getCompleteParams();
        jQuery.extend(completeParams,sortingParams);
        return this.getPageRecords(completeParams).then(
            function(data){
                aDeferred.resolve(data);
            },

            function(textStatus, errorThrown){
                aDeferred.reject(textStatus, errorThrown);
            }
        );
        return aDeferred.promise();
    },
    
    /**
     * Function to handle next page navigation
     */

    nextPageHandler : function(){
        var aDeferred = jQuery.Deferred();
        var pageLimit = jQuery('#popupPageContainer #pageLimit').val();
        var noOfEntries = jQuery('#popupPageContainer #noOfEntries').val();
        if(noOfEntries == pageLimit){
            var pageNumber = jQuery('#popupPageContainer #pageNumber').val();
            var nextPageNumber = parseInt(pageNumber) + 1;
            var pagingParams = {
                    "page": nextPageNumber
                }
            var completeParams = this.getCompleteParams();
            jQuery.extend(completeParams,pagingParams);
            this.getPageRecords(completeParams).then(
                function(data){
                    jQuery('#popupPageContainer #pageNumber').val(nextPageNumber);
                    jQuery('#popupPageContainer #pageToJump').val(nextPageNumber);
                    aDeferred.resolve(data);
                },

                function(textStatus, errorThrown){
                    aDeferred.reject(textStatus, errorThrown);
                }
            );
        }
        return aDeferred.promise();
    },

    /**
     * Function to handle Previous page navigation
     */
    previousPageHandler : function(){
        var aDeferred = jQuery.Deferred();
        var pageNumber = jQuery('#popupPageContainer #pageNumber').val();
        var previousPageNumber = parseInt(pageNumber) - 1;
        if(pageNumber > 1){
            var pagingParams = {
                "page": previousPageNumber
            }
            var completeParams = this.getCompleteParams();
            jQuery.extend(completeParams,pagingParams);
            this.getPageRecords(completeParams).then(
                function(data){
                    jQuery('#popupPageContainer #pageNumber').val(previousPageNumber);
                    jQuery('#popupPageContainer #pageToJump').val(previousPageNumber);
                    aDeferred.resolve(data);
                },

                function(textStatus, errorThrown){
                    aDeferred.reject(textStatus, errorThrown);
                }
            );
        }
        return aDeferred.promise();
    },
    
    /**
     * Function to register event for Paging
     */
    registerEventForPagination : function(){
        var thisInstance = this;
        jQuery('#popupPageContainer #listViewNextPageButton').on('click',function(){
            thisInstance.nextPageHandler().then(function(data){
                thisInstance.updatePagination();
            });
        });
        jQuery('#popupPageContainer #listViewPreviousPageButton').on('click',function(){
            thisInstance.previousPageHandler().then(function(data){
                thisInstance.updatePagination();
            });
        });
        jQuery('#popupPageContainer #listViewPageJump').on('click',function(e){
            jQuery('#pageToJump').validationEngine('hideAll');
            var element = jQuery('#popupPageContainer #totalPageCount');
            var totalPageNumber = element.text();
            if(totalPageNumber == ""){
                var totalRecordElement = jQuery('#popupPageContainer #totalCount');
                var totalRecordCount = totalRecordElement.val();
                if(totalRecordCount != '') {
                    var recordPerPage = jQuery('#popupPageContainer #pageLimit').val();
                    if(recordPerPage == '0') recordPerPage = 1;
                    pageCount = Math.ceil(totalRecordCount/recordPerPage);
                    if(pageCount == 0){
                        pageCount = 1;
                    }
                    element.text(pageCount);
                    return;
                }
                element.progressIndicator({});
                thisInstance.getPageCount().then(function(data){
                    var pageCount = data['result']['page'];
                    element.text(pageCount);
                    totalRecordElement.val(data['result']['numberOfRecords']);
                    element.progressIndicator({'mode': 'hide'});
            });
        }
        })

        jQuery('#popupPageContainer #listViewPageJumpDropDown').on('click','li',function(e){
            e.stopImmediatePropagation();
        }).on('keypress','#pageToJump',function(e){
            if(e.which == 13){
                e.stopImmediatePropagation();
                var element = jQuery(e.currentTarget);
                var response = Vtiger_WholeNumberGreaterThanZero_Validator_Js.invokeValidation(element);
                if(typeof response != "undefined"){
                    element.validationEngine('showPrompt',response,'',"topLeft",true);
                } else {
                    element.validationEngine('hideAll');
                    var currentPageElement = jQuery('#popupPageContainer #pageNumber');
                    var currentPageNumber = currentPageElement.val();
                    var newPageNumber = parseInt(element.val());
                    var totalPages = parseInt(jQuery('#popupPageContainer #totalPageCount').text());
                    if(newPageNumber > totalPages){
                        var error = app.vtranslate('JS_PAGE_NOT_EXIST');
                        element.validationEngine('showPrompt',error,'',"topLeft",true);
                        return;
                    }
                    if(newPageNumber == currentPageNumber){
                        var message = app.vtranslate('JS_YOU_ARE_IN_PAGE_NUMBER')+" "+newPageNumber;
                        var params = {
                            text: message,
                            type: 'info'
                        };
                        Vtiger_Helper_Js.showMessage(params);
                        return;
                    }
                    var pagingParams = {
                        "page": newPageNumber
                    }
                    var completeParams = thisInstance.getCompleteParams();
                    jQuery.extend(completeParams,pagingParams);
                    thisInstance.getPageRecords(completeParams).then(
                        function(data){
                            currentPageElement.val(newPageNumber);
                            thisInstance.updatePagination();
                            element.closest('.btn-group ').removeClass('open');
                        },
                        function(textStatus, errorThrown){
                        }
                    );
                }
                return false;
        }
        });
    },

    /**
     * Function to get page count and total number of records in list
     */
    getPageCount : function(){
        var aDeferred = jQuery.Deferred();
        var pageJumpParams = {
            'mode' : "getPageCount"
        }
        var completeParams = this.getCompleteParams();
        jQuery.extend(completeParams,pageJumpParams);
        AppConnector.request(completeParams).then(
            function(data) {
                var response;
                if(typeof data != "object"){
                    response = JSON.parse(data);
                } else{
                    response = data;
                }
                aDeferred.resolve(response);
            },
            function(error,err){

            }
        );
        return aDeferred.promise();
    },

    /*
     * Function to register onChange event of module selector
     * This allows the user to change the module records they 
     * want to select from.
     *
    */
    registerModuleSelectorEvent : function() {
        var thisInstance = this;
        jQuery("select[name='moduleSelector']").on('change', function() {
            var params = thisInstance.getCompleteParams();
            params['page'] = 1;
            thisInstance.getPageRecords(params);
            thisInstance.registerEventForSearch()
        });
    },
    
    /**
     * Function to show total records count in listview on hover
     * of pageNumber text
     */
    registerEventForTotalRecordsCount : function(){
        var thisInstance = this;
        jQuery('#popupPageContainer .totalNumberOfRecords').on('click',function(e){
            var element = jQuery(e.currentTarget);
            element.addClass('hide');
            element.parent().find('.pageNumbersText').progressIndicator({});
            var totalRecordsElement = jQuery('#popupPageContainer #totalCount');
            var totalNumberOfRecords = totalRecordsElement.val();
            if(totalNumberOfRecords == '') {
                thisInstance.getPageCount().then(function(data){
                    totalNumberOfRecords = data['result']['numberOfRecords'];
                    var numberOfPages = data['result']['page'];
                    totalRecordsElement.val(totalNumberOfRecords);
                    jQuery('#popupPageContainer #totalPageCount').text(numberOfPages);
                    thisInstance.showPagingInfo();
                });
            }else{
                thisInstance.showPagingInfo();
            }
            element.parent().find('.pageNumbersText').progressIndicator({'mode':'hide'});
        })
    },
    
    registerEventForListViewEntries : function(){
        var thisInstance = this;
        var popupPageContentsContainer = this.getPopupPageContainer();
        popupPageContentsContainer.off('click','.listViewEntries').on('click','.listViewEntries',function(e) {
            thisInstance.updateMap(e);
        });
    },
    
});
jQuery(document).ready(function() {
    var popupInstance = GeoTools_Popup_Js.getInstance();
    var triggerEventName = jQuery('.triggerEventName').val();
    var documentHeight = (jQuery(document).height())+'px';
    jQuery('#popupPageContainer').css('height',documentHeight);
    popupInstance.setEventName(triggerEventName);
    popupInstance.registerEventForPagination();
    popupInstance.registerModuleSelectorEvent();
    popupInstance.registerEventForListViewEntries();
    var popupPageContainer = jQuery('#popupPageContainer');
    if(popupPageContainer.length > 0){
        popupInstance.registerEventForTotalRecordsCount();
        popupInstance.registerEventForPagination();
    }
});

