{*<!--
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
-->*}
{strip}
<input type='hidden' id='pageNumber' value="{$PAGE_NUMBER}">
<input type='hidden' id='pageLimit' value="{$PAGING_MODEL->getPageLimit()}">
<input type="hidden" id="noOfEntries" value="{$LISTVIEW_ENTRIES_COUNT}">
<input type="hidden" id="pageStartRange" value="{$PAGING_MODEL->getRecordStartRange()}" />
<input type="hidden" id="pageEndRange" value="{$PAGING_MODEL->getRecordEndRange()}" />
<input type="hidden" id="previousPageExist" value="{$PAGING_MODEL->isPrevPageExists()}" />
<input type="hidden" id="nextPageExist" value="{$PAGING_MODEL->isNextPageExists()}" />
<input type="hidden" id="totalCount" value="{$LISTVIEW_COUNT}" />
<div class="row-fluid popupContainer">
    <div class="span6">
        <form class="form-horizontal popupSearchContainer" onsubmit="return false;">
            <div class="control-group margin0px">
                <input class="span2" type="text" placeholder="{vtranslate('LBL_TYPE_SEARCH')}" id="searchvalue"/>&nbsp;&nbsp;
                <span><strong>{vtranslate('LBL_IN')}</strong></span>&nbsp;
                <span>
                    {assign var = defaultSearchField value = $RECORD_STRUCTURE_MODEL->getModule()->getDefaultSearchField()}
                    <select style="width: 140px;" class="chzn-select" id="searchableColumnsList">
                        {foreach key=block item=fields from=$RECORD_STRUCTURE}
                            {foreach key=fieldName item=fieldObject from=$fields}
                                <optgroup>
                                    <option value="{$fieldName}" {if $fieldName eq $defaultSearchField} selected {/if}>{vtranslate($fieldObject->get('label'),$MODULE)}</option>
                                </optgroup>
                            {/foreach}
                        {/foreach}
                    </select>
                </span>&nbsp;&nbsp;
                <span id="popupSearchButton">
                    <button class="btn"><i class="icon-search " title="{vtranslate('LBL_SEARCH_BUTTON')}"></i></button>
                </span>
            </div>
        </form>
    </div>
    <div class="span6">
        {if $SOURCE_MODULE neq 'PriceBooks' && $SOURCE_FIELD neq 'productsRelatedList'}
        <div class="popupPaging">
            <div class="row-fluid">
                    <span class="span3" style="float:right !important;min-width:230px">
                        <span class="pull-right">
                            <span class="pageNumbers">
                                <span class="pageNumbersText">{if !empty($LISTVIEW_ENTRIES)}{$PAGING_MODEL->getRecordStartRange()} {vtranslate('LBL_to', $MODULE)} {$PAGING_MODEL->getRecordEndRange()}{else}<span>&nbsp;</span>{/if}</span>
                                <span class="alignBottom">
                                    <span class="icon-refresh totalNumberOfRecords cursorPointer{if empty($LISTVIEW_ENTRIES)} hide{/if}" style="margin-left:5px"></span>
                                </span>
                            </span>&nbsp;&nbsp;
                            <span class="btn-group pull-right">
                                <button class="btn" id="listViewPreviousPageButton" {if !$PAGING_MODEL->isPrevPageExists()} disabled {/if}><span class="icon-chevron-left"></span></button>
                                <button class="btn dropdown-toggle" type="button" id="listViewPageJump" data-toggle="dropdown" {if $PAGE_COUNT eq 1} disabled {/if}>
                                    <i class="vtGlyph vticon-pageJump" title="{vtranslate('LBL_LISTVIEW_PAGE_JUMP',$moduleName)}"></i>
                                </button>
                                <ul class="listViewBasicAction dropdown-menu" id="listViewPageJumpDropDown">
                                    <li>
                                        <span class="row-fluid">
                                            <span class="span3 pushUpandDown2per"><span class="pull-right">{vtranslate('LBL_PAGE',$moduleName)}</span></span>
                                            <span class="span4">
                                                <input type="text" id="pageToJump" class="listViewPagingInput" value="{$PAGE_NUMBER}"/>
                                            </span>
                                            <span class="span2 textAlignCenter pushUpandDown2per">
                                                {vtranslate('LBL_OF',$moduleName)}&nbsp;
                                            </span>
                                            <span class="span2 pushUpandDown2per" id="totalPageCount">{$PAGE_COUNT}</span>
                                        </span>
                                    </li>
                                </ul>
                                <button class="btn" id="listViewNextPageButton" {if (!$PAGING_MODEL->isNextPageExists()) or ($PAGE_COUNT eq 1)} disabled {/if}><span class="icon-chevron-right"></span></button>
                            </span>
                        </span>
                    </span>
                </div>
            </div>
        {/if}
    </div>
</div>
<div class="contents-topscroll">
    <div class="topscroll-div">
        &nbsp;
    </div>
</div>
<div class="popupEntriesDiv relatedContents contents-bottomscroll">
    <input type="hidden" value="{$ORDER_BY}" id="orderBy">
    <input type="hidden" value="{$SORT_ORDER}" id="sortOrder">
    {if $SOURCE_MODULE eq "Emails"}
        <input type="hidden" value="Vtiger_EmailsRelatedModule_Popup_Js" id="popUpClassName"/>
    {/if}
    {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
<div class="bottomscroll-div">
    <table class="table table-bordered listViewEntriesTable">
        <thead>
            <tr class="listViewHeaders">
                {if $MULTI_SELECT}
                <th class="{$WIDTHTYPE}">
                    <input type="checkbox"  class="selectAllInCurrentPage" />
                </th>
                {/if}
                {foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
                <th class="{$WIDTHTYPE}">
                    <a href="javascript:void(0);" class="listViewHeaderValues {if $LISTVIEW_HEADER->get('name') eq 'listprice'} noSorting {/if}" data-nextsortorderval="{if $ORDER_BY eq $LISTVIEW_HEADER->get('column')}{$NEXT_SORT_ORDER}{else}ASC{/if}" data-columnname="{$LISTVIEW_HEADER->get('column')}">{vtranslate($LISTVIEW_HEADER->get('label'), $MODULE)}
                        {if $ORDER_BY eq $LISTVIEW_HEADER->get('column')}<img class="sortImage" src="{vimage_path( $SORT_IMAGE, $MODULE)}">{else}<img class="hide sortingImage" src="{vimage_path( 'downArrowSmall.png', $MODULE)}">{/if}</a>
                </th>
                {/foreach}
            </tr>
        </thead>
        {foreach item=LISTVIEW_ENTRY from=$LISTVIEW_ENTRIES name=popupListView}
        <tr class="listViewEntries" data-id="{$LISTVIEW_ENTRY->getId()}" data-name='{$LISTVIEW_ENTRY->getName()}' data-info='{ZEND_JSON::encode($LISTVIEW_ENTRY->getRawData())}'
            {if $GETURL neq '' } data-url='{$LISTVIEW_ENTRY->$GETURL()}' {/if}  id="{$MODULE}_popUpListView_row_{$smarty.foreach.popupListView.index+1}">
            {if $MULTI_SELECT}
            <td class="{$WIDTHTYPE}">
                <input class="entryCheckBox" type="checkbox" />
            </td>
            {/if}
            {foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
            {assign var=LISTVIEW_HEADERNAME value=$LISTVIEW_HEADER->get('name')}
            <td class="listViewEntryValue {$WIDTHTYPE}">
                {if $LISTVIEW_HEADER->isNameField() eq true or $LISTVIEW_HEADER->get('uitype') eq '4'}
                    <a>{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}</a>
                {else if $LISTVIEW_HEADER->get('uitype') eq '72'}
                    {assign var=CURRENCY_SYMBOL_PLACEMENT value={$CURRENT_USER_MODEL->get('currency_symbol_placement')}}
                    {if $CURRENCY_SYMBOL_PLACEMENT eq '1.0$'}
                        {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}{$LISTVIEW_ENTRY->get('currencySymbol')}
                    {else}
                        {$LISTVIEW_ENTRY->get('currencySymbol')}{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
                    {/if}
                {else if $LISTVIEW_HEADERNAME eq 'listprice'}
                    {CurrencyField::convertToUserFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME), null, true, true)}
                {else}
                    {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
                {/if}
            </td>
            {/foreach}
        </tr>
        {/foreach}
    </table>
</div>

    <!--added this div for Temporarily -->
{if $LISTVIEW_ENTRIES_COUNT eq '0'}
    <div class="row-fluid">
        <div class="emptyRecordsDiv">{vtranslate('LBL_NO', $MODULE)} {vtranslate($RELATED_MODULE, $RELATED_MODULE)} {vtranslate('LBL_FOUND', $MODULE)}.</div>
    </div>
{/if}
</div>
{/strip}
