/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit2_Js", {}, {
    step2Container: false,
    advanceFilterInstance: false,
    init: function () {
        this.initialize();
    },
    /**
     * Function to get the container which holds all the reports step1 elements
     * @return jQuery object
     */
    getContainer: function () {
        return this.step2Container;
    },
    /**
     * Function to set the reports step1 container
     * @params : element - which represents the reports step1 container
     * @return : current instance
     */
    setContainer: function (element) {
        this.step2Container = element;
        return this;
    },
    /**
     * Function  to intialize the reports step1
     */
    initialize: function (container) {
        if (typeof container == 'undefined') {
            container = jQuery('#EmailCampaigns_step2');
        }
        if (container.is('#EmailCampaigns_step2')) {
            this.setContainer(container);
        } else {
            this.setContainer(jQuery('#EmailCampaigns_step2'));
        }
    },
    calculateValues: function () {
        //handled advanced filters saved values.
        jQuery('[name="filtersavedinnew"]').val("6");
        var advfilterlist = this.advanceFilterInstance.getValues();
        jQuery('#advanced_filter').val(JSON.stringify(advfilterlist));

    },
    submit: function () {
        var aDeferred = jQuery.Deferred();
        var form = this.getContainer();
        this.calculateValues();
        var formData = form.serializeFormData();
        var progressIndicatorElement = jQuery.progressIndicator({
            'position': 'html',
            'blockInfo': {
                'enabled': true
            }
        });
        AppConnector.request(formData).then(
                function (data) {
                    form.hide();
                    progressIndicatorElement.progressIndicator({
                        'mode': 'hide'
                    })
                    aDeferred.resolve(data);
                },
                function (error, err) {

                }
        );
        return aDeferred.promise();
    },
    registerEnableFilterOption: function () {
        jQuery('[name="conditionstype"]').on('change', function (e) {
            var advanceFilterContainer = jQuery('#advanceFilterContainer');
            var currentRadioButtonElement = jQuery(e.currentTarget);
            if (currentRadioButtonElement.hasClass('recreate')) {
                if (currentRadioButtonElement.is(':checked')) {
                    advanceFilterContainer.removeClass('zeroOpacity');
                }
            } else {
                advanceFilterContainer.addClass('zeroOpacity');
            }
        });
    },
    // VTCONN_TT17186 #RG Inizio
    selectoptionshowhide: function () {
        jQuery('[name="select_option"]').on('change', function (e) {
            var selectvalue = jQuery('[name="select_option"]').val();
            //alert(selectvalue);
            if (selectvalue == 'Start from past campaign') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('#filter_condition').hide();
                jQuery('#subscriber_select').hide();
                jQuery('#howto').hide();
                jQuery('#past_emailcampaign').show();
                jQuery('#emailclicklink').show();
                jQuery('#whopenemail').show();

                jQuery('#notwhopenemail').show();
                jQuery('#notemailclicklink').show();
                jQuery('#allprevsubcribers').show();

                jQuery('#past_report').hide();
            }
            if (selectvalue == 'Select a list') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('#filter_condition').show();
                jQuery('#subscriber_select').show();
                jQuery('#howto').show();
                jQuery('#past_emailcampaign').hide();
                jQuery('#emailclicklink').hide();
                jQuery('#whopenemail').hide();

                jQuery('#notwhopenemail').hide();
                jQuery('#notemailclicklink').hide();
                jQuery('#allprevsubcribers').hide();

                jQuery('#past_report').hide();
            }
            if (selectvalue == 'Select from report') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('#filter_condition').hide();
                jQuery('#subscriber_select').hide();
                jQuery('#howto').hide();
                jQuery('#past_emailcampaign').hide();
                jQuery('#emailclicklink').hide();
                jQuery('#whopenemail').hide();

                jQuery('#notwhopenemail').hide();
                jQuery('#notemailclicklink').hide();
                jQuery('#allprevsubcribers').hide();

                jQuery('#past_report').show();
            }
        });
    },
    // VTCONN_TT17186 #RG Fine

    // VTCONN_TT17186 #RG Inizio
    registerReportSelChange: function () {
        var thisInstance = this;
        jQuery("#searchReports").on("change", function (i) {
            var reportid = jQuery('#searchReports').find('option:selected').val();
            if (reportid == 0) {
                return;
            }

            var moduleNamePicklist = jQuery("#searchReportModules");
            moduleNamePicklist.find('option').remove().end().append('<option value="--">Select an option</option>').val('0');

            var params = {
                'module': app.getModuleName(),
                'action': "SaveAjax",
                'mode': "getModulesByReport",
                'reportid': reportid,
            };
            AppConnector.request(params).then(function (data) {
                jQuery.each(data.result.options, function (i, item) {
                    var o = new Option(item, item);
                    jQuery(o).html(item);
                    moduleNamePicklist.append(o);
                });
                moduleNamePicklist.trigger('liszt:updated');
            });
        });
    },
    // VTCONN_TT17186 #RG Fine

    registerApplyFilterConditionsEvent: function () {
        var a = this;
        jQuery(".filterClick").off();


        jQuery(".filterClick").on("click", function (i) {
            var selectElement = jQuery("#searchModuleList");
            var source_module = selectElement.val();

            var advfilterlist = a.advanceFilterInstance.getValues();
            var isError = false;
            var selectSource = $('select[name="select_option"]').val();
            var record = $('#EmailCampaigns_step2').find('input[name="record"]').val();
            if (selectSource == 'Select a list') {
                var subscriperListId = $('input[name="subscribers_list"]').val();
                if (subscriperListId == '') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a subscribers list. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'subscriperListId': subscriperListId,
                        "filter": JSON.stringify(advfilterlist),
                        "name": "From Subscribers List",
                        "record": record
                    };
                }
            } else if (selectSource == 'Start from past campaign') {
                var parent_emailcampaignsid = $('input[name="parent_emailcampaignsid"]').val();
                if (parent_emailcampaignsid == '') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a past campaign. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    if ($("#EmailCampaigns_editView_fieldName_whopenemail").is(":checked"))
                    {
                        var whopenemail = '1';
                    } else {
                        var whopenemail = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_emailclicklink").is(":checked"))
                    {
                        var emailclicklink = '1';
                    } else {
                        var emailclicklink = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_notwhopenemail").is(":checked"))
                    {
                        var notwhopenemail = '1';
                    } else {
                        var notwhopenemail = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_notemailclicklink").is(":checked"))
                    {
                        var notemailclicklink = '1';
                    } else {
                        var notemailclicklink = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_allprevsubcribers").is(":checked"))
                    {
                        var allprevsubcribers = '1';
                    } else {
                        var allprevsubcribers = '0';
                    }

                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'whopenemail': whopenemail,
                        'emailclicklink': emailclicklink,
                        'notwhopenemail': notwhopenemail,
                        'notemailclicklink': notemailclicklink,
                        'allprevsubcribers': allprevsubcribers,
                        'parent_emailcampaignsid': parent_emailcampaignsid,
                        "name": "From Emailcampaigns",
                        "record": record
                    };
                }

            } else if (selectSource == 'Select from report') {

                var searchReports = $('#searchReports').val();
                var searchReportModules = $('#searchReportModules').val();
                if (searchReports == '' || searchReports == 0) {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Report. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else if (searchReportModules == '' || searchReportModules == '--') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Report Module. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'reportId': searchReports,
                        "reportModule": searchReportModules,
                        "name": "From Report",
                        "record": record
                    };
                }

            }
//            console.log(j);
            if (!isError) {
                jQuery(".filterClick").prop("disabled", true);
                AppConnector.request(j).then(function (k) {
                    var e = k.result.count;
                    if (e == null) {
                        e = 0;
                    }
                    jQuery("#filter_1").html(e);

//                    var related_recorts = k.result.related_recorts;
                    //jQuery('[name="related_recorts"]').val(related_recorts);
//                    if (related_recorts == null) {
//                        related_recorts = "";
//                    }
//                    jQuery('#related_recorts_current').val(related_recorts);


                    var logHtml = '<p  style="line-height: 30px"> ' +
                            '&nbsp;' +
                            '<span class="campaignslLog">' +
                            '<span class="span10 logName" style="font-weight: bold;">' +
                            k.result.emailListName +
                            '</span>' +
                            '<span class="span1 logTotal" style=" color: #ff3333; font-weight: bold;">' +
                            e +
                            '</span>' +
                            '<span class="span2 pull-right">' +
                            '<button class="btn btn-success refreshTotal" data-id = "' + k.result.emaillistRelId + '" title="Refresh the Total" onclick="registerRefreshTotalClick(this)" type="button">&nbsp;&nbsp;&nbsp;&nbsp;' + app.vtranslate("Total") + '&nbsp;&nbsp;<i class="icon-refresh alignMiddle" title="Restore"></i>&nbsp;&nbsp;</button> &nbsp;&nbsp;<i title="Delete" class="deleteRel icon-trash alignMiddle" data-id = "' + k.result.emaillistRelId + '"></i>' +
                            '</span>' +
                            '</span>' +
                            '</p>';
                    $('.EmailCampaignsLog').append(logHtml);

//                    var searchmodulelist = k.result.module_name;
//                    jQuery('[name="searchmodulelist"]').val(searchmodulelist);
//                    jQuery('[name="module_name"]').val(searchmodulelist);
                        jQuery(".filterClick").prop("disabled", false);
                });
            }
        });





        jQuery(".addClick").off();
        jQuery(".addClick").on("click", function (i) {
            // Accoda il related_recorts_current al related_recorts
            if (jQuery('#related_recorts_current').val() != "") {
                jQuery('[name="related_recorts"]').val(jQuery('#related_recorts_current').val() + "," + jQuery('[name="related_recorts"]').val());
            }
            if (parseInt(jQuery("#filter_1").html()) != 0) {
                jQuery("#filter_2").html(parseInt(jQuery("#filter_1").html()) + parseInt(jQuery("#filter_2").html()));
            }

            var ecLog = jQuery(".EmailCampaignsLog").html();
            var typeSel = "";
            var textVal = "";
            var selectvalue = jQuery('[name="select_option"]').val();
            if (selectvalue == 'Start from past campaign') {
                typeSel = "Previous Campaign : ";
                textVal = jQuery('#parent_emailcampaignsid_display').val();
            } else if (selectvalue == 'Select a list') {
                typeSel = "Subscribers List : ";
                textVal = jQuery('#subscribers_list_display').val();
            } else if (selectvalue == 'Select from report') {
                typeSel = "Report : ";
                textVal = jQuery('#searchReports').find('option:selected').text();

            }

//        	ecLog = ecLog + "<p><b>" + jQuery("#filter_1").html() + " </b> " + app.vtranslate('JS_FROM') + typeSel + textVal +"</p>";
            ecLog = ecLog + "<p><b>" + typeSel + textVal + "</p>";
            jQuery(".EmailCampaignsLog").html(ecLog);
            jQuery("#eclog").val(ecLog);

            jQuery(this).prop("disabled", true);
        });

        jQuery(".resetClick").off();
        jQuery(".resetClick").on("click", function (i) {
            // Accoda il related_recorts_current al related_recorts
            jQuery('[name="related_recorts"]').val("");
            jQuery("#filter_2").html(0);
            jQuery('[name="related_recorts_current"]').val("");
            jQuery("#filter_1").html(0);
            jQuery(".addClick").prop("disabled", true);
            //sbianca log
            jQuery(".EmailCampaignsLog").html("");
            jQuery("#eclog").val("");
        });
    },
    getPopUpParams: function (container) {

        var params = {};
        var sourceModule = app.getModuleName();
        var popupReferenceModule = jQuery('input[name="popupReferenceModule"]', container).val();
        var sourceFieldElement = jQuery('input[class="sourceField"]', container);
        var sourceField = sourceFieldElement.attr('name');
        var sourceRecordElement = jQuery('input[name="record"]');
        var sourceRecordId = '';
        if (sourceRecordElement.length > 0) {
            sourceRecordId = sourceRecordElement.val();
        }

        var isMultiple = false;
        if (sourceFieldElement.data('multiple') == true) {
            isMultiple = true;
        }

        var params = {
            'module': popupReferenceModule,
            'src_module': sourceModule,
            'src_field': sourceField,
            'src_record': sourceRecordId
        }

        if (isMultiple) {
            params.multi_select = true;
        }
        return params;
    },
    openPopUp: function (e) {
        var thisInstance = this;
        var parentElem = jQuery(e.target).closest('div').parent();
        var container = this.getContainer();
        var params = this.getPopUpParams(parentElem);

        var isMultiple = false;
        if (params.multi_select) {
            isMultiple = true;
        }

        var sourceFieldElement = jQuery('input[class="sourceField"]', parentElem);

        var prePopupOpenEvent = jQuery.Event(Vtiger_Edit_Js.preReferencePopUpOpenEvent);
        sourceFieldElement.trigger(prePopupOpenEvent);

        if (prePopupOpenEvent.isDefaultPrevented()) {
            return;
        }

        var popupInstance = Vtiger_Popup_Js.getInstance();
        popupInstance.show(params, function (data) {
            var responseData = JSON.parse(data);
            var dataList = new Array();
            for (var id in responseData) {
                var data = {
                    'name': responseData[id].name,
                    'id': id
                }
                dataList.push(data);
                if (!isMultiple) {

                    thisInstance.setReferenceFieldValue(parentElem, data);
                }
            }

            if (isMultiple) {
                sourceFieldElement.trigger(Vtiger_Edit_Js.refrenceMultiSelectionEvent, {'data': dataList});
            }
        });
    },
    setReferenceFieldValue: function (container, params) {
        var sourceField = container.find('input[class="sourceField"]').attr('name');
        var fieldElement = container.find('input[name="' + sourceField + '"]');
        var sourceFieldDisplay = sourceField + "_display";
        var fieldDisplayElement = container.find('input[name="' + sourceFieldDisplay + '"]');
        var popupReferenceModule = container.find('input[name="popupReferenceModule"]').val();

        var selectedName = params.name;
        var id = params.id;
        fieldElement.val(id)
        fieldDisplayElement.val(selectedName).attr('readonly', true);
        fieldElement.trigger(Vtiger_Edit_Js.referenceSelectionEvent, {'source_module': popupReferenceModule, 'record': id, 'selectedName': selectedName});

        fieldDisplayElement.validationEngine('closePrompt', fieldDisplayElement);
    },
    referenceModulePopupRegisterEvent: function (container) {
        var thisInstance = this;
        container.find('.relatedPopup').on("click", function (e) {
            thisInstance.openPopUp(e);
        });
        container.find('.referenceModulesList').chosen().change(function (e) {
            var element = jQuery(e.currentTarget);
            var closestTD = element.closest('td').next();
            var popupReferenceModule = element.val();
            var referenceModuleElement = jQuery('input[name="popupReferenceModule"]', closestTD);
            var prevSelectedReferenceModule = referenceModuleElement.val();
            referenceModuleElement.val(popupReferenceModule);

            //If Reference module is changed then we should clear the previous value
            if (prevSelectedReferenceModule != popupReferenceModule) {
                closestTD.find('.clearReferenceSelection').trigger('click');
            }
        });
    },
    registerClearReferenceSelectionEvent: function (container) {
        container.find('.clearReferenceSelection').on('click', function (e) {
            jQuery('#parent_emailcampaignsid_display').removeAttr('readonly').val('');
        })
    },

    registerRefreshTotalClick: function () {
        $(document).on('click', '.refreshTotal', function (e) {
            var element = $(this);
            var relId = element.attr('data-id');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });
            var params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'BasicAjax',
                mode: 'refreshTotalCount'
            };
            $.post('index.php', params, function (response) {
                if (response.success) {
                    var parentElement = element.closest('p');
                    parentElement.find('.logTotal').html(response.result.count);
                }
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                })
            });
        });
    },
    registerDeleteRelClick: function () {
        $(document).on('click', '.deleteRel', function (e) {
            var element = $(this);
            var relId = element.attr('data-id');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });
            var params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'BasicAjax',
                mode: 'deleteRel'
            };
            $.post('index.php', params, function (response) {
                if (response.success) {
                    element.closest('p').remove();
                }
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                })
            });
        });
    },
    registerEvents: function () {
        var opts = app.validationEngineOptions;
        // to prevent the page reload after the validation has completed
        opts['onValidationComplete'] = function (form, valid) {
            //returns the valid status
            return valid;
        };
        opts['promptPosition'] = "bottomRight";
        jQuery('#EmailCampaigns_step2').validationEngine(opts);

        var container = this.getContainer();
        app.changeSelectElementView(container);
        this.advanceFilterInstance = Vtiger_AdvanceFilter_Js.getInstance(jQuery('.filterContainer', container));
        //this.getPopUp();
        if (jQuery('[name="filtersavedinnew"]', container).val() == '5') {
            this.registerEnableFilterOption();
        }
        this.selectoptionshowhide();
        this.registerApplyFilterConditionsEvent();
        this.referenceModulePopupRegisterEvent(container);
        this.registerClearReferenceSelectionEvent(container);
        // VTCONN_TT17186 #RG Inizio
        this.registerReportSelChange();
        // VTCONN_TT17186 #RG Fine
//        this.registerRefreshTotalClick();
        this.registerDeleteRelClick();
    },
});

function registerRefreshTotalClick(event){
    var element = $(event);
            var relId = element.attr('data-id');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });
            var params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'BasicAjax',
                mode: 'refreshTotalCount'
            };
            $.post('index.php', params, function (response) {
                if (response.success) {
                    var parentElement = element.closest('p');
                    parentElement.find('.logTotal').html(response.result.count);
                }
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                })
            });
}