/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit1_Js",{},{
	
	init : function() {
		this.initialize();
	},
	/**
	 * Function to get the container which holds all the reports step1 elements
	 * @return jQuery object
	 */
	getContainer : function() {
		return this.step1Container;
	},

	/**
	 * Function to set the reports step1 container
	 * @params : element - which represents the reports step1 container
	 * @return : current instance
	 */
	setContainer : function(element) {
		this.step1Container = element;
		return this;
	},
	
	/**
	 * Function  to intialize the reports step1
	 */
	initialize : function(container) {
		if(typeof container == 'undefined') {
			container = jQuery('#EmailCampaigns_step1');
		}
		if(container.is('#EmailCampaigns_step1')) {
			this.setContainer(container);
		}else{
			this.setContainer(jQuery('#EmailCampaigns_step1'));
		}
	},
	
	/* VTCONN #GG - Inizio */
	/**
	 * Function to register the TypeAssignment change event
	 */
	registerTypeAssignmentChangeEvent : function(container){
		var type = container.find('[name="typeofassignment"]');
		var assignto = container.find('[name="assignto"]');
		var assignto_section = assignto.closest('.control-group');
		if(type.val() != 'LBL_ASS_FIX'){
			assignto_section.hide();
		}
		container.find('select[name="typeofassignment"]').on('change',function(e){
			var selectedOption = jQuery(e.currentTarget).val();
			if(selectedOption == 'LBL_ASS_FIX'){
				assignto_section.show();
			} else{
				if(selectedOption == 'LBL_ASS_CAMPAIGN'){
					assignto.val(container.find('[name="assigned_user_id"]').val());
				} else {
					assignto.val("1");
				}
				assignto.trigger("liszt:updated");
				assignto_section.hide();
			}
		});
	},
	/* VTCONN #GG - Fine */
	
	submit : function(){
	
		var aDeferred = jQuery.Deferred();
		var form = this.getContainer();
		var formData = form.serializeFormData();
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
		});
		AppConnector.request(formData).then(
			function(data) {
				form.hide();
				progressIndicatorElement.progressIndicator({
					'mode' : 'hide'
				})
				aDeferred.resolve(data);
			},
			function(error,err){

			}
		);
		return aDeferred.promise();
	},
	
	registerEvents : function(){
		var container = this.getContainer();
		
		//After loading 1st step only, we will enable the Next button
		container.find('[type="submit"]').removeAttr('disabled');
		
		this.registerTypeAssignmentChangeEvent(container); // VTCONN #GG 
		
		var opts = app.validationEngineOptions;
		// to prevent the page reload after the validation has completed
		opts['onValidationComplete'] = function(form,valid) {
            //returns the valid status
            return valid;
        };
		opts['promptPosition'] = "bottomRight";
		container.validationEngine(opts);
	}
});