/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger.Class("Settings_GeoTools_CoreEditor_Js",{}, {
	init: function () {
		this.addComponents();
	},
	addComponents: function () {
		this.addModuleSpecificComponent('Index', app.getModuleName, app.getParentModuleName());
	},

    /*
     * Function to save the Editor content
     */
    saveCoreEditor : function(form) {
		var aDeferred = jQuery.Deferred();
		var data = form.serializeFormData();
		var updatedFields = {};
		jQuery.each(data, function (key, value) {
			updatedFields[key] = value;
		});
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'CoreEditorSaveAjax',
			'mode'   : 'saveCoreEditor',
            'updatedFields' : JSON.stringify(updatedFields)
        }
        
		app.request.post({"data": params}).then(
			function (err, data) {
				if (err === null) {
					aDeferred.resolve(true);
				} else {
				    aDeferred.resolve(err);
				}
			},
			function (error, err) {
				aDeferred.reject();
			}
		);
		return aDeferred.promise();
	},

    /**
	 * Function to show the Popup for configuring the GeoTools
	 * Provider (Map or Geocoder)
	 */
	showCheckProvider : function(type, providerId) {
		var thisInstance = this;
		var aDeferred = jQuery.Deferred();
		
   		app.helper.showProgress();
		
		var params = {
			'module' : app.getModuleName(),
			'parent' : app.getParentModuleName(),
			'view'   : 'CheckProvider',
			'type'   : type,
			'providerId' : providerId
		};
		
		app.request.post({data: params}).then(
		    function(err, data) {
                if(err === null) {
               		if(data[0] !== true) {
				        var callBackFunction = function(data) {
					        jQuery('#checkProvider')
                                // indirectly bind the handler to form
                                .submit(function(e) {
                                    e.preventDefault();
                                    if(thisInstance.checkForm.apply(jQuery(this).find(':input')[0])) {
                                        thisInstance.saveProvider(this);
                                    }
                                })
                                // look for input elements
                                .find('input[data-rule-required="true"]')
                                // bind the handler to input elements
                                .keyup(thisInstance.checkForm)
                                // immediately fire it to initialize buttons state
                                .keyup();

                        };
                        
                   		app.helper.hideProgress();
				        app.helper.showModal(data, {"cb": callBackFunction});
				    } else {
                   		app.helper.hideProgress();
				        // "data" is empty (No required params for Provider) so nothing to do
                        aDeferred.reject();
                    }
			    } else {
               		app.helper.hideProgress();
                    message = err['message'];
                    app.helper.showErrorNotification({'message': message});
			        aDeferred.reject(error);
		        }
		    },
            function(error,err) {
                app.helper.hideProgress();
                aDeferred.reject();
		    }
		);
		return aDeferred.promise();
	},

    /**
     * Serialise and save provider config over Ajax
    **/
	saveProvider : function(form) {
		var aDeferred = jQuery.Deferred();
		var thisInstance = this;
		
   		app.helper.showProgress();

	    var providerForm = jQuery(form);		
		var params = providerForm.serializeFormData();

		params['module'] = app.getModuleName();
		params['parent'] = app.getParentModuleName();
		params['action'] = 'CoreEditorSaveAjax';
		params['mode'] = 'saveProvider';

        var msg = {};
	    			    
		app.request.post({data: params}).then(
		    function(err, data) {
                if(err === null) {
				    msg.title = app.vtranslate('JS_GEOTOOLS_PROVIDER_SAVED');
				    msg.message = app.vtranslate('JS_GEOTOOLS_PROVIDER_UPDATED');
               		app.helper.hideProgress();
               		app.helper.showSuccessNotification(msg);
               		app.helper.hideModal();
					aDeferred.resolve(data);
				} else {
				    msg.title = app.vtranslate('JS_GEOTOOLS_PROVIDER_ERROR');;
				    msg.message = err['message'];
               		app.helper.hideProgress();
               		app.helper.hideModal();
    				aDeferred.reject();
                    app.helper.showErrorNotification(msg);
				}
			},
			function(error,err){
            	app.helper.hideProgress();
				aDeferred.reject();
			}
		);
		return aDeferred.promise();
	},


    /**
     * This function will attempt to Geocode the Company address
     */
    geocodeCompany : function() {
        var thisInstance = this;
   		app.helper.showProgress();
        
        var params = {
            'module' : app.getModuleName(),
            'parent' : app.getParentModuleName(),
            'action' : 'CoreEditorGeocodeAjax',
        };
        
		app.request.post({data: params}).then(
		    function(err, data) {
                var message = '';
                if(err === null) {
                    message = app.vtranslate('JS_GEOTOOLS_LOCATION_UPDATED');
                    var location = data[0];
                    $('input[name="companyloc"]').val(location);
            		app.helper.hideProgress();
					app.helper.showSuccessNotification({'message': message});
                } else {
                    message = err['message'];
            		app.helper.hideProgress();
                    app.helper.showErrorNotification({'message': message});
                }
            },
            function(error) {
           		app.helper.hideProgress();
                //TODO : Handle error
            }
        );
    },

    
    /*
     * Function to load the contents from the url through pjax
     */
    loadContents : function(url) {
        var aDeferred = jQuery.Deferred();
        AppConnector.requestPjax(url).then(
            function(data){
                aDeferred.resolve(data);
            },
            function(error, err){
                aDeferred.reject();
            }
        );
        return aDeferred.promise();
    },
    
    /**
     * https://codereview.stackexchange.com/questions/148072/disable-button-when-required-inputs-are-not-filled-in
    **/
    checkForm : function() {
          // "this" is an input element
          var isValidForm = true;
          jQuery(this.form).find('input[data-rule-required="true"]').each(function() {
            if (!this.value.trim()) {
              isValidForm = false;
            }
          });
          jQuery(this.form).find('button[name="saveButton"]').prop('disabled', !isValidForm);
          return isValidForm;
    },

    /*
     * function to register the events in editView
     */
	registerEditViewEvents: function () {
		var thisInstance = this;
		var form = jQuery('#CoreEditorForm');
		var detailUrl = form.data('detailUrl');

		// Want to get the original values
		var geocoderselectVal = jQuery('select[name="geocoder"]').val();
		var mapserviceselectVal = jQuery('select[name="mapservice"]').val();

        //register Geocode Company Address button click
        var btn = $('#geocodeCompany');
        btn.click(function() {
            thisInstance.geocodeCompany();
        });

		jQuery('select[name="geocoder"]').on('change', function() {
			var el = jQuery(this);
			var name = el.attr('name');
			var provider = el.val();
			// Only trigger if *really* changed
			if((name == 'geocoder' && provider != geocoderselectVal) || (name == 'mapservice' && provider != mapserviceselectVal)) {
				thisInstance.showCheckProvider(name, provider);
			}
        });

		//register submit 
		var params = {
			submitHandler: function (form) {
				var form = jQuery(form);
				thisInstance.saveCoreEditor(form).then(
					function (data) {
						if(data === true) {
							var message = app.vtranslate('JS_CONFIGURATION_DETAILS_SAVED');
							thisInstance.loadContents(detailUrl).then(
								function (data) {
									jQuery('.settingsPageDiv').html(data);
									thisInstance.registerDetailViewEvents();
								}
							);
    						app.helper.showSuccessNotification({'message': message});
						} else {
						    var message = data['message'];
                            app.helper.showErrorNotification({'message': message});
                        }
					}
				);
			}
		};
		form.vtValidate(params);
		form.on('submit', function (e) {
			e.preventDefault();
			return false;
		});

		//Register click event for cancel link
		var cancelLink = form.find('.cancelLink');
		cancelLink.click(function () {
			thisInstance.loadContents(detailUrl).then(
				function (data) {
					jQuery('.settingsPageDiv').html(data);
					thisInstance.registerDetailViewEvents();
				});
		});
		vtUtils.enableTooltips();
	},    

    /*
     * function to register the events in DetailView
     */
    registerDetailViewEvents : function() {
        var thisInstance = this;
        var container = jQuery('#CoreEditorDetails');
        var editButton = container.find('.editButton');
        
        //Register click event for edit button
        editButton.click(function() {
            var url = editButton.data('url');
       		app.helper.showProgress();

            thisInstance.loadContents(url).then(
                function(data) {
            		app.helper.hideProgress();
                    jQuery('.contents').html(data);
                    thisInstance.registerEditViewEvents();
                }, function(error, err) {
            		app.helper.hideProgress();
                }
            );
        });
    },
    
    registerEvents: function() {
        if(jQuery('#CoreEditorDetails').length > 0) {
            this.registerDetailViewEvents();
        } else {
            this.registerEditViewEvents();
        }
    }

});

Settings_GeoTools_CoreEditor_Js("Settings_GeoTools_CoreEditorDetail_Js");
