/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
Vtiger_Popup_Js.extend('GeoTools_Popup_Js', {

    getInstance: function(){
        var module = 'GeoTools';
        var className = jQuery('#popUpClassName').val();
        if(typeof className != 'undefined'){
            var moduleClassName = className;
        }else{
            var moduleClassName = module+"_Popup_Js";
        }
        var fallbackClassName = Vtiger_Popup_Js;
        if(typeof window[moduleClassName] != 'undefined'){
            var instance = new window[moduleClassName]();
        }else{
            var instance = new fallbackClassName();
        }
        return instance;
    }

}, {
    
    updateMap: function(e){
        var thisInstance = this;
        var row  = jQuery(e.currentTarget);
        var listModule = $("select[name='moduleSelector']").val();
        var id = row.data('id');
        var response = {'id' : id, 'listModule' : listModule};

        thisInstance.done(response, thisInstance.getEventName());
        e.preventDefault();
    },
    
    done : function(result, eventToTrigger, window) {

        if(typeof eventToTrigger == 'undefined' || eventToTrigger.length <=0 ) {
            eventToTrigger = 'postSelection'
        }

        if(typeof window == 'undefined'){
            window = self;
        }
        window.close();
        var data = JSON.stringify(result);
        // Because if we have two dollars like this "$$" it's not working because it'll be like escape char(Email Templates)
        data = data.replace(/\$\$/g,"$ $");

        jQuery.triggerParentEvent(eventToTrigger, data);

    },
    
     /**
	 * Function to get complete params
	 */
	getCompleteParams : function(){
		var params = {};
		params['view'] = this.getView();
		params['src_module'] = this.getSourceModule();
		params['src_record'] = this.getSourceRecord();
		params['src_field'] = this.getSourceField();
		params['search_key'] =  this.getSearchKey();
		params['search_value'] =  this.getSearchValue();
		params['orderby'] =  this.getOrderBy();
		params['sortorder'] =  this.getSortOrder();
		params['page'] = this.getPageNumber();
		params['related_parent_module'] = this.getRelatedParentModule();
		params['related_parent_id'] = this.getRelatedParentRecord();
        params['module'] = 'GeoTools';
        params['tgt_module'] = jQuery("select[name='moduleSelector']").val();
        params.search_params = JSON.stringify(this.getPopupListSearchParams());
		if(this.isMultiSelectMode()) {
			params['multi_select'] = true;
		}
        params['relationId'] = this.getRelationId();
		return params;
	},

    /*
     * Function to register onChange event of module selector
     * This allows the user to change the module records they 
     * want to select from.
     *
    */
    registerModuleSelectorEvent : function() {
        var thisInstance = this;
        var popupContainer = this.getPopupPageContainer();
        popupContainer.on('change', "select[name='moduleSelector']", function(){
            var params = thisInstance.getCompleteParams();
            params.search_params = '';
            params['page'] = 1;
            thisInstance.getPageRecords(params);
            app.helper.hideProgress();
            //thisInstance.registerEventForSearch();
        });
    },
    
    registerEventForListViewEntryClick : function(){
        var thisInstance = this;
        var popupPageContentsContainer = this.getPopupPageContainer();
		popupPageContentsContainer.off('click', '.listViewEntries');
		popupPageContentsContainer.on('click','.listViewEntries',function(e) {
            thisInstance.updateMap(e);
            thisInstance.getListViewEntries(e);
        });
    },
    
    registerEvents : function(){
        this._super();
        this.registerModuleSelectorEvent();
		this.registerEventForListViewEntryClick();
    }
});