/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
/*
 * GeoTools_List_Js: Main jQuery class file for user-intraction with the GeoTools page.
 * Overloading the normal Vtiger_List_Js class with modifications and 
 * new functions to handle the various GeoTools features.
 */
Vtiger_List_Js.extend('GeoTools_List_Js', {

    // Array to hold the map markers
    markers : [],
    
    // Base url
    urlParams : 'index.php?module=GeoTools&view=GeoTools',
    
    // Object to hold the map class based on the provider
    mapClass : false,
    
    // Object to hold the map object itself
    map : false,
    
    // Object to hold the keys for the Picklist derived icon colours
    key : {},
    
    // Called from the Geocoder_Js class on a map marker save after drag
    saveLocation : function(crmid, latlng, locked) {
        var thisInstance = this;
        var savingLocationMsg = app.vtranslate('JS_GEOTOOLS_SAVING_LOCATION');
        var geotoolsModule = jQuery('[name="geotoolsModule"]').val();
   		app.helper.showProgress();
        
        var params = {
        'module' : 'GeoTools',
        'listModule' : geotoolsModule,
        'action' : 'SaveLocationAjax',
        'id' : crmid,
        'lat' : latlng.lat,
        'lng' : latlng.lng,
        'locked' : locked
        };
        
        AppConnector.request(params).then(
            function(data) {
                var msg = {};
                if(data['success']) {
                    msg.title = app.vtranslate('JS_GEOTOOLS_LOCATION_SAVED');
                    msg.text = app.vtranslate('JS_GEOTOOLS_LOCATION_UPDATED');
                    msg.type = 'success';
       				app.helper.hideProgress();
                    var listInstance = new GeoTools_List_Js;
                    listInstance.loadListViewRecords();
                } else {
                    msg.title = app.vtranslate('JS_GEOTOOLS_ERROR');;
                    msg.text = data['error']['message'];
                    msg.type = 'error';
       				app.helper.hideProgress();
                }
                Vtiger_Helper_Js.showMessage(msg);
            },
            function(error) {
       				app.helper.hideProgress();
                //TODO : Handle error
            }
        );
    }

}, {

    init : function() {
        var className = 'GeoTools_' + $('#mapProvider').val() + 'mapCode_Js';
        this.mapClass = window[className].getInstance();
        if($("select[name='geotoolsCenterOption']").val() == '4') {
                this.setLocation();
        }
        this._super();
    },
    
    addIndexComponent : function() {
        this.addModuleSpecificComponent('Index','GeoTools',app.getParentModuleName());
    },
    
    getCurrentCvId : function(){
        return jQuery('input[name="viewname"]').val();
    },
    
    getModuleName : function(){
        return jQuery('[name="geotoolsModule"]').val();
    },
 
    // GeoTools: Overriden function to include GeoTools Search Params
    getDefaultParams : function() {
        var pageNumber = jQuery('#pageNumber').val();
        var module = 'GeoTools';
        var parent = app.getParentModuleName();
        var cvId = this.getCurrentCvId();
        var orderBy = jQuery('#orderBy').val();
        var sortOrder = jQuery("#sortOrder").val();
        var params = {
            'module': module,
            'parent' : parent,
            'page' : pageNumber,
            'view' : "List",
            'viewname' : cvId,
            'orderby' : orderBy,
            'sortorder' : sortOrder,
        };
        
        jQuery.extend(params, this.getGeoParams(false));
        
        params.search_params = JSON.stringify(this.getListSearchParams());
        return params;
    },
    
    getGeoParams : function(noCenter) {
    
        if(noCenter) {
            var geotoolsMapCenter = '';
        } else {
            var geotoolsMapCenter = jQuery('#geotoolsMapCenter').val();
        }
        
        var geotoolsModule = jQuery('[name="geotoolsModule"]').val();
        var geotoolsDistanceUnits = jQuery('[name="geotoolsDistanceUnits"]').val();
        var geotoolsRadius = jQuery('[name="geotoolsRadius"]').val();
        var geotoolsConstraint = jQuery('[name="geotoolsConstraint"]:checked').val();
        var geotoolsSortOrder = jQuery('[name="geotoolsSortOrder"]:checked').val();
        var geotoolsCenterOption = jQuery('[name="geotoolsCenterOption"]').val();
        var geoParams = {
            'geotoolsModule' : geotoolsModule,
            'geotoolsMapCenter' : geotoolsMapCenter,
            'geotoolsDistanceUnits' : geotoolsDistanceUnits,
            'geotoolsRadius' : geotoolsRadius,
            'geotoolsConstraint' : geotoolsConstraint,
            'geotoolsSortOrder' : geotoolsSortOrder,
            'geotoolsCenterOption' : geotoolsCenterOption
        };
        
        return geoParams;
    
    },
    
    /*
     * Use the navigator.geolocation function to get user's browser 
     * location and update the map centre before reload
     */
    setLocation : function(){
        var thisInstance = this;
		app.helper.showProgress();
        if(navigator.geolocation){
        
            // timeout at 10000 milliseconds (10 seconds)
            var options = {timeout:10000};
            navigator.geolocation.getCurrentPosition(thisInstance.updateMapCenter.bind(this), 
                                                     thisInstance.errorHandler,
                                                     options);
       		app.helper.hideProgress();
        }else{
       		app.helper.hideProgress();
            var noNavigatorMessage = app.vtranslate('JS_GEOTOOLS_BROWSER_DOES_NOT_HAVE_NAVIGATOR');
            app.helper.showAlertNotification({'message': noNavigatorMessage});
        }
    },
    
    // Update the #geotoolsMapCenter input with the browser's location 
    // then reload the page
    updateMapCenter : function(position) {
        var location = position.coords.latitude + ',' + position.coords.longitude;
        jQuery('#geotoolsMapCenter').val(location);
        urlParams = this.getDefaultParams();
        urlParams['geotoolsMapCenter'] = location;
        this.loadListViewRecords(urlParams);
    },

    // If it doesn't work do this.
    errorHandler : function(error) {
      alert('ERROR. Code: '+error.code+ "\n" + error.message);
    },
    
    /*
     * Load the "Enter Address" popup and deal with the returned 
     * geocode entry (or not)
     *
     */
    enterAddress : function() {
        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        
   		app.helper.showProgress();
        
        var params = {};
        params['module'] = 'GeoTools';
        params['parent'] = app.getParentModuleName();
        params['view'] = 'AddressAjax';
        
        AppConnector.request(params).then(
            function(data) {
                var callBackFunction = function(data) {
                    var addressform = jQuery('#addressEntry');
//                  
                    addressform.vtValidate({
                       submitHandler : function() {
                           thisInstance.geocodeAddress(addressform);
                           return true;
                       }
                    });
                       
                    addressform.submit(function(e) {
                        e.preventDefault();
                    });
//                  var params = app.validationEngineOptions;
//                  params.onValidationComplete = function(addressform, valid){
//                      if(valid) {
//                          thisInstance.geocodeAddress(addressform);
//                          return valid;
//                      }
//                  }
//                  addressform.vtValidate();
//                  
//                  addressform.submit(function(e) {
//                      e.preventDefault();
//                  })
                }
           		app.helper.hideProgress();
                
                app.showModalWindow(data,function(data){
                    if(typeof callBackFunction == 'function'){
                        callBackFunction(data);
                    }
                }, {'width':'400px'});
            },
            function(error) {
           		app.helper.hideProgress();
                //TODO : Handle error
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    
    /**
     * This function will geocode the address
     */
    geocodeAddress : function(form) {
        var thisInstance = this;
        var geocodingMessage = app.vtranslate('JS_GEOTOOLS_ATTEMPTING_TO_GEOCODE_ADDRESS');
   		app.helper.showProgress(form,geocodingMessage);
        
        var data = form.serializeFormData();
        data['module'] = 'GeoTools';
        data['parent'] = app.getParentModuleName();
        data['action'] = 'GeocodeAddressAjax';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    var location = data['result'][0];
                    $('#geotoolsMapCenter').val(location);
                    urlParams = thisInstance.getDefaultParams();
                    urlParams['geotoolsMapCenter'] = location;
            		app.helper.hideProgress();
                    app.hideModalWindow();
                    thisInstance.loadListViewRecords(urlParams);
                } else {
                    app.helper.showAlertNotification({'message': data['error']['message']});
            		app.helper.hideProgress();
                    thisInstance.enterAddress();
                }
            },
            function(error) {
               app.helper.hideProgress();
                //TODO : Handle error
            }
        );
    },
    
    getRecordsCount : function(){
        var aDeferred = jQuery.Deferred();
        var recordCountVal = jQuery("#recordsCount").val();
        if(recordCountVal != ''){
            aDeferred.resolve(recordCountVal);
        } else {
            var count = '';
            var cvId = this.getCurrentCvId();
            var module = app.getModuleName();
            var parent = app.getParentModuleName();
            var postData = {
                "module": 'GeoTools',
                "parent": parent,
                "view": "ListAjax",
                "viewname": cvId,
                "mode": "getRecordsCount"
            }
            
            jQuery.extend(postData, this.getGeoParams(false));

            postData.search_params = JSON.stringify(this.getListSearchParams());

            AppConnector.request(postData).then(
                function(data) {
                    var response = data;
                    if(typeof data != "object"){
                        response = JSON.parse(data);
                    }
                    jQuery("#recordsCount").val(response['result']['count']);
                    count =  response['result'];
                    aDeferred.resolve(count);
                },
                function(error,err){

                }
            );
        }

        return aDeferred.promise();
    },

    // When a non-geocded record is to be located via drag on the map. Paint a new marker and
    // let the user locate it.
    addRecordtoMap : function(crmid) {
        var tds = jQuery(".listViewEntries[data-id='"+crmid+"'] td");
        var headers = this.mapClass.getColumnHeaders();
        var latlng = this.mapClass.castLatlng(jQuery('#geotoolsMapCenter').val());
        var iconpath = $('#iconpath').val();
        var distance = '0';
        var locked = '';
                
        var col1value = tds[1].innerHTML;
        var col2value = tds[2].innerHTML;
        var col3value = tds[3].innerHTML;
        
        this.mapClass.createMarker(crmid, latlng, col1value, col2value, col3value, distance, iconpath, headers, locked);

    },
    
      loadListViewRecords : function(urlParams) {
        var thisInstance = this;
        // Bit of a hack but works for v7
        if(typeof urlParams == 'undefined') {
            urlParams = {};
        }
        if(urlParams.module != 'GeoTools') {
            var viewname = urlParams.viewname;
            urlParams = this.getDefaultParams();
            urlParams.viewname = viewname;
        }
        if(!urlParams) {
            urlParams = this.getDefaultParams();
        }
        var aDeferred = jQuery.Deferred();
        this.getListViewRecords(urlParams).then(function(data){
            aDeferred.resolve(data);
            thisInstance.postLoadListViewRecords(data);
        });
        return aDeferred.promise();
    },

    /*
     * Function which will give you all the list view params
     * GeoTools customised to repaint the map after listview 
     * contents are updated
     */
    getListViewRecords : function(urlParams) {
        var aDeferred = jQuery.Deferred();
        if(typeof urlParams == 'undefined') {
            urlParams = {};
        }

        var thisInstance = this;
        
        var loadingMessage = jQuery('.listViewLoadingMsg').text();
   		app.helper.showProgress();

        var defaultParams = thisInstance.getDefaultParams();
        var urlParams = jQuery.extend(defaultParams, urlParams);
        AppConnector.requestPjax(urlParams).then(
            function(data){
           		app.helper.hideProgress();
                
                var listViewContentsContainer = thisInstance.getListViewContentContainer();
                listViewContentsContainer.html(data);
                thisInstance.insertCustomView(defaultParams.viewname);
                app.showSelect2ElementView(listViewContentsContainer.find('select.select2'));
                app.changeSelectElementView(listViewContentsContainer);
                thisInstance.registerTimeListSearch(listViewContentsContainer);

                thisInstance.registerDateListSearch(listViewContentsContainer);
                thisInstance.calculatePages().then(function(data){
                    //thisInstance.triggerDisplayTypeEvent();
//                  Vtiger_Helper_Js.showHorizontalTopScrollBar(listViewContentsContainer.find('.listViewContentDiv'));

                    var selectedIds = thisInstance.readSelectedIds();
                    if(selectedIds != ''){
                        if(selectedIds == 'all'){
                            jQuery('.listViewEntriesCheckBox').each( function(index,element) {
                                jQuery(this).attr('checked', true).closest('tr').addClass('highlightBackgroundColor');
                            });
                            jQuery('#deSelectAllMsgDiv').show();
                            var excludedIds = thisInstance.readExcludedIds();
                            if(excludedIds != ''){
                                jQuery('#listViewEntriesMainCheckBox').attr('checked',false);
                                jQuery('.listViewEntriesCheckBox').each( function(index,element) {
                                    if(jQuery.inArray(jQuery(element).val(),excludedIds) != -1){
                                        jQuery(element).attr('checked', false).closest('tr').removeClass('highlightBackgroundColor');
                                    }
                                });
                            }
                        } else {
                            jQuery('.listViewEntriesCheckBox').each( function(index,element) {
                                var selectedId = jQuery(element).val();
                                if(jQuery.inArray(parseInt(selectedId),selectedIds) != -1){
                                    jQuery(this).attr('checked', true).closest('tr').addClass('highlightBackgroundColor');
                                }
                            });
                        }
                        thisInstance.checkSelectAll();
                    }
                    aDeferred.resolve(data);

                    // Let listeners know about page state change.
                    app.notifyPostAjaxReady();
                    thisInstance.registerRowClickEvent();
                    
                    // GeoTools Customisation: Repaint the map
                    thisInstance.mapClass.showMap();
                    // Register the drag event handler
                    thisInstance.registerDragMarkerEvent();
                });
            },

            function(textStatus, errorThrown){
                aDeferred.reject(textStatus, errorThrown);
            }
        );
        return aDeferred.promise();
    },
    
    getLatLngFromID : function(responseData) {
        var thisInstance = this;
		app.helper.showProgress();
        
        var data = responseData;
        data['module'] = 'GeoTools';
        data['parent'] = app.getParentModuleName();
        data['action'] = 'GetLatLngAjax';
        
        AppConnector.request(data).then(
            function(data) {
                if(data['success']) {
                    var location = data['result'][0];
                    jQuery('#geotoolsMapCenter').val(location);
                    urlParams = thisInstance.getDefaultParams();
                    urlParams['geotoolsMapCenter'] = location;
            		app.helper.hideProgress();
                    app.hideModalWindow();
                    thisInstance.loadListViewRecords(urlParams);
                }
            },
            function(error) {
           		app.helper.hideProgress();
                //TODO : Handle error
            }
        );
    },
    

    // Load the popup selector to choose new map centre
    openPopUp : function() {
        var thisInstance = this;
        var popupInstance = GeoTools_Popup_Js.getInstance();
        var params = {
            'module' : 'GeoTools',
            'src_module' : '',
            'src_field' : '',
            'src_record' : '' 
        };
        
        popupInstance.show(params,function(data) {
            var responseData = JSON.parse(data);
            thisInstance.getLatLngFromID(responseData);

        });
    },

    /*
     * Function to register the GeoTools list view add record to map click event
     */
    registerAddRecordToMapClickEvent: function(){
        var thisInstance = this;
        var listViewContentDiv = this.getListViewContentContainer();
        listViewContentDiv.on('click','.addToMapButton',function(e){
            var elem = jQuery(e.currentTarget);
            var recordId = elem.closest('tr').data('id');
            thisInstance.addRecordtoMap(recordId);
            e.stopPropagation();
        });
    },

    /*
     * GeoTools: Trigger a reload of the ListView contents when GeoTools
     * search params change with whatever params are on-screen.
     */
    registerGeoToolsSearchEvents : function(){
        var thisInstance = this;
        var urlParams = this.getDefaultParams();
        
        jQuery("select[name='geotoolsDistanceUnits']")
            .add("input[name='geotoolsConstraint']")
            .add("input[name='geotoolsSortOrder']")
            .add("input[name='geotoolsRadius']").on('change', function() {
                urlParams = thisInstance.getDefaultParams();
                thisInstance.loadListViewRecords(urlParams).then(
                function(data){
                    thisInstance.updatePagination();
                    //To unmark the all the selected ids
                    jQuery('#deSelectAllMsg').trigger('click');
                },
            function(textStatus, errorThrown){
                }
            )
        });
        // If the user changes module then we should clear all non-geo params back to defaults
        jQuery("select[name='geotoolsModule']").on('change', function() {
            jQuery.extend(urlParams, thisInstance.getGeoParams(false));
            urlParams.viewname = '';
            var url = 'index.php?' + jQuery.param(urlParams);
            //thisInstance.loadListViewRecords(urlParams);
            document.location.assign(url);
        });
        // Depending on the choice of map centre we need to clear the current lat/lng
        jQuery("select[name='geotoolsCenterOption']").on('change', function() {
            // Get Broswer's location and set the geotoolsMapCenter input
            if($(this).val() == '4') {
                thisInstance.setLocation();
            } else if($(this).val() == '5') {
                thisInstance.openPopUp();
            } else if($(this).val() == '6') {
                thisInstance.enterAddress();
            } else if($(this).val() == '100') {
                return;
            } else {
                jQuery.extend(urlParams, thisInstance.getGeoParams(true));
                thisInstance.loadListViewRecords(urlParams);
                //document.location.assign(urlParams);
            }
        });
    },
    
    /*
     * Function to insert the Non-Geocoded Custom Filter Option
    */
    
    insertCustomView : function(viewname) {
        var option;
        if(viewname == "noGeoCodes"){
            option = '<option value="noGeoCodes" data-id="noGeoCodes" selected="selected">'+app.vtranslate('JS_LBL_GEOTOOLS_NON_GEOCODED_RECORDS')+'</option>';
        }else {
            option = '<option value="noGeoCodes" data-id="noGeoCodes">'+app.vtranslate('JS_LBL_GEOTOOLS_NON_GEOCODED_RECORDS')+'</option>';
        }
        if(!$('select#customFilter option[value="noGeoCodes"]').length > 0) {
            $('select#customFilter').append(option);
        };
    },
    
    /*
     * Function to register the list view row click event
     * GeoTools: Re-written with an event to load the relevant map 
     * marker rather than navigate away to the target module
     */
    registerRowClickEvent: function(){
        var thisInstance = this;
        var listViewContentDiv = jQuery('.listViewContentDiv');
        // Unset existing click events first
        listViewContentDiv.off('click','.listViewEntries',function(e){
        });
        listViewContentDiv.on('click','.listViewEntries',function(e){
            if(jQuery(e.target, jQuery(e.currentTarget)).is('td:first-child')) return;
            if(jQuery(e.target).is('input[type="checkbox"]')) return;
            var elem = jQuery(e.currentTarget);         
            var markerNum = elem.index();
            thisInstance.mapClass.addmarkerEvent(GeoTools_List_Js.markers[markerNum], 'click');
        });
    },
    
    /* So we can drag the center marker and trigger a reload
     *
     * This is not pretty. I Couldn't work out how to pass the event back
     * and forth successfully to the provider Javascript class.
     * TODO Replace the if(provider=='') test and have a common function in here
     * plus implementation specific code in the provider class.
    */
    registerDragMarkerEvent : function() {
        var thisInstance = this;
        var urlParams = '';
        
        // Center Marker must always be the last one added to the array
        var centerMarker = GeoTools_List_Js.markers[GeoTools_List_Js.markers.length - 1];
        var provider = $('#mapProvider').val();
        
        if(provider == 'Google') {
            google.maps.event.addListener(centerMarker, 'dragend', function (event) {
                var option = '<option value="100" selected="selected">'+app.vtranslate('JS_LBL_GEOTOOLS_DRAGGED_MARKER')+'</option>';
                var location = this.getPosition().lat() + ',' + this.getPosition().lng();
                $('#geotoolsMapCenter').val(location);
                if(!$('[name="geotoolsCenterOption"] option[value="100"]').length > 0) {
                    $('[name="geotoolsCenterOption"]').append(option);
                }
                urlParams = thisInstance.getDefaultParams();
                urlParams['geotoolsMapCenter'] = location;
                thisInstance.loadListViewRecords(urlParams);
            });
        } else if (provider == 'OSM') {
            centerMarker.on('dragend', function (e) {
                var option = '<option value="100" selected="selected">'+app.vtranslate('JS_LBL_GEOTOOLS_DRAGGED_MARKER')+'</option>';
                var location = e.target.getLatLng();
                location = location['lat'] + ',' + location['lng'];
                $('#geotoolsMapCenter').val(location);
                    
                if(!$('[name="geotoolsCenterOption"] option[value="100"]').length > 0) {
                    $('[name="geotoolsCenterOption"]').append(option);
                    $('[name="geotoolsCenterOption"]').trigger("change");
                }
                    
                urlParams = thisInstance.getDefaultParams();
                urlParams['geotoolsMapCenter'] = location;

                thisInstance.loadListViewRecords(urlParams);
            });
        }
    },
	
	/**
     * Slightly tweaked function to get the correct module name from within the
     * embedded list view of GeoTools
     * and to reload the page using ajax rather than the default window load
     * to the supplied url.
    **/
	registerConfigureColumnsEvents: function () {
		var thisInstance = this;
		var listViewContentDiv = this.getListViewContainer();
		listViewContentDiv.on('click', '.listColumnFilter', function (e) {
			if (jQuery(e.currentTarget).hasClass('disabled')) {
				return false;
			}
			var params = {
				module: thisInstance.getModuleName(),
				view: 'ListAjax',
				mode: 'ShowListColumnsEdit',
				source_module: thisInstance.getModuleName(),
				cvid: thisInstance.getCurrentCvId()
			};

			var callback = function (container) {
				var selectedFieldsList = jQuery('#selectedFieldsList');
				var selectedFieldsListContainer = container.find('.selectedFieldsListContainer');
				var availFieldsList = jQuery('#avialFieldsList');
				var availFieldsListContainer = container.find('.avialFieldsListContainer');

				//register ui events
				app.helper.showVerticalScroll(availFieldsListContainer,
						{setHeight: '200', advanced: {updateOnSelectorChange: 'true'}});
				app.helper.showVerticalScroll(selectedFieldsListContainer,
						{setHeight: '250', advanced: {updateOnSelectorChange: 'true'}});

				selectedFieldsList.sortable({
					start: function (e, ui) {
						if (!ui.item.hasClass('active')) {
							ui.item.addClass('active');
						}
					},
					stop: function (e, ui) {
						ui.item.removeClass('active');
					}
				});

				container.find('.searchAvailFields').instaFilta({
					onFilterComplete: function (macthedItems) {
						if (macthedItems.length > 0) {
							jQuery.each(macthedItems, function (i, ele) {
								var parent = jQuery(ele).closest('.instafilta-section');
								var availFieldBlock = parent.find('.availFieldBlock');
								if (availFieldBlock.find('i').hasClass('fa-caret-right')) {
									availFieldBlock.find('a[data-parent="#accordion"]').trigger('click');
								}
							});
						}
					}
				});

				availFieldsListContainer.on('click', '.availFieldBlock a[data-parent="#accordion"]', function (e) {
					var target = jQuery(e.currentTarget);
					var closestItag = target.find('i');
					if (closestItag.hasClass('fa-caret-right')) {
						closestItag.removeClass('fa-caret-right').addClass('fa-caret-down');
					} else {
						closestItag.removeClass('fa-caret-down').addClass('fa-caret-right');
					}

					if (params && params.autoIconChangeForOthers) {
						return true;
					}
				});

				//remove selected field event
				selectedFieldsList.on('click', '.removeField', function (e) {
					var selectedFieldsEles = selectedFieldsList.find('.item');
					if (selectedFieldsEles.length <= 1) {
						app.helper.showErrorNotification({message: app.vtranslate('Atleast one field should be selected')});
						return false;
					}
					var ele = jQuery(e.currentTarget);
					var sourceFieldEle = ele.parent('.item');
					var targetFieldEle = availFieldsListContainer.find('.item[data-cv-columnname="' + sourceFieldEle.attr('data-cv-columnname') + '"]');
					targetFieldEle.removeClass('hide');
					sourceFieldEle.remove();
				});

				//add available field to selected list
				availFieldsList.on('click', '.item', function (e) {
					var selectedFieldsEles = selectedFieldsList.find('.item');
					if (selectedFieldsEles.length > 15) {
						app.helper.showErrorNotification({message: app.vtranslate('JS_ADD_MAX_15_ITEMS')});
						return false;
					}
					var sourceFieldEle = jQuery(e.currentTarget);
					var targetFieldEle = selectedFieldsListContainer.find('.item-dummy').clone();
					targetFieldEle.removeClass('hide item-dummy').addClass('item');
					targetFieldEle.attr('data-cv-columnname', sourceFieldEle.attr('data-cv-columnname'));
					targetFieldEle.attr('data-columnname', sourceFieldEle.attr('data-columnname'));
					targetFieldEle.attr('data-field-id', sourceFieldEle.attr('data-field-id'));
					targetFieldEle.find('.fieldLabel').html(sourceFieldEle.find('.fieldLabel').html());
					targetFieldEle.appendTo(selectedFieldsList);
					sourceFieldEle.addClass('hide');
				});

				var configColumnsForm = container.find('.configColumnsForm');
				var params = {
					submitHandler: function (form) {
						var formData = jQuery(form).serializeFormData();
						var columnsList = [];
						var selectedFieldEles = selectedFieldsList.find('.item');
						jQuery.each(selectedFieldEles, function (i, e) {
							var ele = jQuery(e);
							columnsList.push(ele.attr('data-cv-columnname'));
						});

						formData.source_module = app.module();
						formData.columnslist = JSON.stringify(columnsList);
						app.helper.showProgress();
						app.request.post({data: formData}).then(function (err, res) {
							app.helper.hideProgress();
							if (err) {
								app.helper.showErrorNotification({"message": err});
								return false;
							} else {
								app.helper.showSuccessNotification({message: res.message});
								app.helper.hideModal();
								// GeoTools mod - re-load list via Ajax
								urlParams = thisInstance.getDefaultParams();
								thisInstance.loadListViewRecords(urlParams);
								// End GeoTools mod
								/*
								var appName = app.getAppName();								
								var url = res['listviewurl'] + '&app=' + appName;
								window.location.href = url;
								*/
							}
						});
					}
				};

				configColumnsForm.vtValidate(params);
			}

			app.helper.showProgress();
			app.request.post({data: params}).then(function (err, res) {
				app.helper.hideProgress();
				if (!err) {
					app.helper.showModal(jQuery(res), {cb: callback});
				}
			});

		});
	},

    pageJumpOnSubmit: function (element) {
		var thisInstance = this;
		var container = this.getListViewContainer();
		var currentPageElement = container.find('#pageNumber');
		var currentPageNumber = parseInt(currentPageElement.val());
		var newPageNumber = parseInt(container.find('#pageToJump').val());
		var totalPages = parseInt(container.find('#totalPageCount').text());
		if (newPageNumber > totalPages) {
			var message = app.vtranslate('JS_PAGE_NOT_EXIST');
			app.helper.showErrorNotification({'message': message})
			return;
		}
        
		if (newPageNumber === currentPageNumber) {
			var message = app.vtranslate('JS_YOU_ARE_IN_PAGE_NUMBER') + " " + newPageNumber;
			app.helper.showAlertNotification({'message': message});
			return;
		}
        
		var urlParams = thisInstance.getDefaultParams();
		urlParams['page'] = newPageNumber;
		thisInstance.loadListViewRecords(urlParams).then(function (data) {
			element.closest('.btn-group ').removeClass('open');
		});
	},
    /**
	 * Function to handle filter change event here
	 * @returns {undefined}
	 */
	registerFilterChangeEvent : function(){
		var thisInstance = this;
        var urlParams = GeoTools_List_Js.urlParams;
		jQuery('#customFilter').on('change', function(e){
			var currElem = jQuery(e.currentTarget);
			var geoParams = $.param(thisInstance.getGeoParams(false));
            urlParams = urlParams+'&'+geoParams+'&'+"viewname="+currElem.val();
            document.location.assign(urlParams);
		});
	},

    /*
     * GeoTools: Should load our own event handlers after the parent's
     * registerEvents() function has been called
     */
    registerEvents : function() {
        var thisInstance = this;
        this._super();
        // GeoTools Event Registration
        thisInstance.registerGeoToolsSearchEvents();
        thisInstance.registerAddRecordToMapClickEvent();
        thisInstance.insertCustomView();
        if (this.getDefaultParams().viewname == 'noGeoCodes') {
            jQuery('.customFilterMainSpan .select2-chosen').text(app.vtranslate('JS_LBL_GEOTOOLS_NON_GEOCODED_RECORDS'))
        }
        // Load the map on first page load
        thisInstance.mapClass.showMap();
        // register this *after* the map has loaded
        thisInstance.registerDragMarkerEvent();
        thisInstance.registerChangeCustomFilterEvent();
        thisInstance.registerFilterChangeEvent();
    }

});

