/**
 * VGS Listview Colors
 *
 * @package        VGS Listview Colors
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2018 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class("VGSListviewColors_Js", {}, {
    vgsLayoutArray : [],
    updateLayout: function () {
        var thisInstance = this;
        var moduleName = app.getModuleName();
        var view = "List";
        var ids = [];
        $(".listViewEntriesCheckBox").each(function(){
            ids.push(this.value);
        });

        params = {
            'module': 'VGSListviewColors',
            'action': "VGSListviewColorsAjax",
            'mode': "getModuleListviewColor",
            'moduleName': moduleName,
            'ids': ids        
        };

        AppConnector.request(params).then(
            function (data) {
                if (data.success && data.result.existLayout) {

                    jQuery.each(data.result.resp, function(){
                        $(".listViewEntries[data-id='"+this.id+"']").css('background-color', this.color);

                    });
                } else {
                    console.log('this module dont have custom VGSListviewColors');
                }
            },
            function (jqXHR, textStatus, errorThrown) {
                console.log(textStatus);
            });
    }
});


jQuery(document).ready(function () {
    var instance = new VGSListviewColors_Js();
    
    instance.updateLayout();
    

});
