/**
 * VGS Listview Colors
 *
 * @package        VGS Listview Colors
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2018 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class('VGSListviewColors_JsList', {}, {
    deleteVGSListviewColors: function () {
        jQuery('.deleteRecordButton').on('click', function (e) {

            params = {
                'module': app.getModuleName(),
                'action': "VGSListviewColorsAjax",
                'mode': "deleteColumnsForModule",
                'record_id': jQuery(this).attr('id'),
            }
            
            var line_id = jQuery(this).attr('id');
            AppConnector.request(params).then(
                    function (data) {
                        var params;
                        if (data.success == true) {
                            jQuery('#'+line_id).closest('tr').hide();
                            params = {
                                animation: "show",
                                type: 'info',
                                title: data.result.caption
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                            
                        } else {
                            var errorMessage = app.vtranslate(data.error.message);
                            params = {
                                animation: "show",
                                text: errorMessage,
                                title: 'error'
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                    });
        });
    },
    /**
     * Function to register events
     */
    registerEvents: function () {
        var thisInstance = this;
        this.deleteVGSListviewColors();
        jQuery('#sourceModule').trigger('change');
    }
})
jQuery(document).ready(function () {
    var VGSListviewColorsInstance = new VGSListviewColors_JsList();
    VGSListviewColorsInstance.registerEvents();
    var vtInstance = new Vtiger_Index_Js();
    vtInstance.registerAppTriggerEvent();
});
