{*
/**
 * VGS Listview Colors
 *
 * @package        VGS Listview Colors
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2018 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */
*}

<div class="col-sm-12 col-xs-12">
    <div style="margin-top: 2%; margin-left: 2%;"><h4>{vtranslate('LBL_MODULE_NAME', $MODULE)}</h4></div>
    <div style="width: 90%;margin: auto;margin-top: 2%;">
        <button class="btn btn-default" style="margin-bottom: 0.5em;" onclick="window.location.href='index.php?parent=Settings&module=VGSListviewColors&view=EditListviewColor'">{vtranslate('ADD_NEW', $MODULE)}</button>

        <table class="table table-bordered listViewEntriesTable">
            <thead>
                <tr class="listViewHeaders">
                    <th> {vtranslate('MODULE_NAME', $MODULE)} </th>
                    <th> {vtranslate('DESCRIPTION', $MODULE)} </th>
                    <th> {vtranslate('CONDITIONS', $MODULE)} </th>
                    <th> {vtranslate('COLOR', $MODULE)} </th>
                    <th> {vtranslate('ACTIONS', $MODULE)} </th>

                </tr>
            </thead>
            {foreach item=LAYOUT from=$LAYOUTS_ARRAY}
                
                <tr class="listViewEntries">
                    
                    <td class="listViewEntryValue" nowrap> {$LAYOUT.module_name}</td>
                    <td class="listViewEntryValue" nowrap> {$LAYOUT.description} </td>
                    <td class="listViewEntryValue" nowrap> 
                        {assign var=WORKFLOW_CONDITION value=$LAYOUT.conditions}
                        {assign var=ALL_CONDITIONS value=$WORKFLOW_CONDITION['All']}
                        {assign var=ANY_CONDITIONS value=$WORKFLOW_CONDITION['Any']}
                        <span><strong>{vtranslate('All')}&nbsp;:&nbsp;&nbsp;&nbsp;</strong></span>
                        {if is_array($ALL_CONDITIONS) && !empty($ALL_CONDITIONS)}
                                {foreach item=ALL_CONDITION from=$ALL_CONDITIONS name=allCounter}
                                        {if $smarty.foreach.allCounter.iteration neq 1}
                                                <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                                        {/if}
                                        <span>{$ALL_CONDITION}</span>
                                        <br>
                                {/foreach}
                        {else}
                                {vtranslate('LBL_NA')}
                        {/if}
                        <br>
                        <span><strong>{vtranslate('Any')}&nbsp;:&nbsp;</strong></span>
                        {if is_array($ANY_CONDITIONS) && !empty($ANY_CONDITIONS)}
                                {foreach item=ANY_CONDITION from=$ANY_CONDITIONS name=anyCounter}
                                        {if $smarty.foreach.anyCounter.iteration neq 1}
                                                <span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
                                        {/if}
                                        <span>{$ANY_CONDITION}</span>
                                        <br>
                                {/foreach}
                        {else}
                                {vtranslate('LBL_NA')}
                        {/if}
                    </td>
                    <td class="listViewEntryValue" style="background-color: {$LAYOUT.color}" nowrap> 
                    
                    </td>
                        
                    <td class="listViewEntryValue" nowrap>
                        <span class="col-lg-2" style="line-height: 30px;">
                            <a onclick="window.location.href='index.php?parent=Settings&module=VGSListviewColors&view=EditListviewColor&record={$LAYOUT.id}'"><i class="editAction glyphicon glyphicon-pencil cursorPointer" title="{vtranslate('LBL_EDIT', $MODULE)}"></i></a>
                        </span>
                        <span class="col-lg-2" style="line-height: 30px;">
                            <a class="deleteRecordButton" id="{$LAYOUT.id}"><i class="glyphicon glyphicon-trash cursorPointer" title="{vtranslate('LBL_DELETE', $MODULE)}"></i></a>
                        </span>
                    </td>

                </tr>
            {/foreach}
        </table>
    </div>
</div>
    
