/**
 * VGS Layouts
 *
 * @package        VGS Layouts
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2018 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class("VGSLayouts_Js", {}, {
    
    vgsLayoutArray : [],
    updateLayout: function () {
        var thisInstance = this;
        var moduleName = app.getModuleName();
        if(_META.module =="Calendar"){
            if(_META.view=="Edit"){
                moduleName=$("[name='module']").val();
            }else if(_META.view=="Detail"){
                if($("#Events_detailView_fieldLabel_eventstatus").val()!=undefined)
                    moduleName="Events";
            }
        }
        params = {
            'module': 'VGSLayouts',
            'action': "VGSLayoutsAjax",
            'mode': "getModuleLayout",
            'moduleName': moduleName
        };

        AppConnector.request(params).then(
            function (data) {
                if (data.success && data.result.existLayout) {
                    vgsLayoutArray = data.result.layout;
                    jQuery('#page').append('<input type="hidden" name="vgs_layouts" value=' + JSON.stringify(vgsLayoutArray) + ' />');
                    for (var i = 0; i < vgsLayoutArray.length; i++) {
                        if (thisInstance.checkConditions(JSON.parse(vgsLayoutArray[i]['conditions']))) {
                            thisInstance.performActions(JSON.parse(vgsLayoutArray[i]['actions']),true);
                        }else
                            thisInstance.performActions(JSON.parse(vgsLayoutArray[i]['actions']),false);
                        
                        //ONCHANGE ACTION
                        var aux=JSON.parse(vgsLayoutArray[i]['conditions']);
                        for(var j=0;j<aux.length;j++)
                        $("[name='"+aux[j].fieldname+"']").change(function(){

                                var moduleName = app.getModuleName();
                                var thisInstance = new VGSLayouts_Js();
                                if(_META.module =="Calendar"){
                                    if(_META.view=="Edit"){
                                        moduleName=$("[name='module']").val();
                                    }else if(_META.view=="Detail"){
                                        if($("#Events_detailView_fieldLabel_eventstatus").val()!=undefined)
                                            moduleName="Events";
                                    }
                                }

                                params = {
                                    'module': 'VGSLayouts',
                                    'action': "VGSLayoutsAjax",
                                    'mode': "getModuleLayout",
                                    'moduleName': moduleName
                                };

                                AppConnector.request(params).then(
                                    function (data) {
                                        if (data.success && data.result.existLayout) {
                                            vgsLayoutArray = data.result.layout;
                                            jQuery('#page').append('<input type="hidden" name="vgs_layouts" value=' + JSON.stringify(vgsLayoutArray) + ' />');
                                            for (var i = 0; i < vgsLayoutArray.length; i++) {
                                                if (thisInstance.checkConditions(JSON.parse(vgsLayoutArray[i]['conditions']))) {
                                                    thisInstance.performActions(JSON.parse(vgsLayoutArray[i]['actions']),true);
                                                }else
                                                    thisInstance.performActions(JSON.parse(vgsLayoutArray[i]['actions']),false);
                                                
                                            }
                                        } else {
                                            //console.log('this module dont have custom VGSLayouts');
                                        }
                                    },
                                    function (jqXHR, textStatus, errorThrown) {
                                        alert(textStatus);
                                    });
                        });
                    }
                } else {
                    //console.log('this module dont have custom VGSLayouts');
                }
            },
            function (jqXHR, textStatus, errorThrown) {
                alert(textStatus);
            });
    },
    checkConditions: function (conditions) {
        //maeby we have to save a variable with de field values on load to compare if the value changes and we have to compare it to the previous value.
        var thisInstance = this;
        var allConditions = true;
        var anyConditions = false;
        jQuery.each(conditions, function (index, condition) {
            if(!allConditions){
                return false;
            }
            if(anyConditions){
                return true;
            }
            var fieldName = condition.fieldname;
            var fieldValue = condition.value;
            var valueType = condition.valuetype;
            var operation = condition.operation;
            var joincondition = condition.joincondition;
            var elementData = '';//to store necesary data related to the element. ex. date-format
            var savedValue = '';//to store db value of field
            if(jQuery('#EditView').length){
                var mainContainer = jQuery('#EditView');
                view="EditView";
            }else{
                view="DetailView";
                var mainContainer = jQuery('#detailView');
            }
            var element='';
            if(view=="EditView"){
                var element = mainContainer.find('[name="' + fieldName + '"]');
                //get values
                var elementValue = element.val();
            }else{
                var element = mainContainer.find('td[id*="fieldValue_' + fieldName +'"]');
                if($(element).length == 0){
                    return false;
                }
                //get values
                var elementValue = element.find("span.value").html().trim();
                if(elementValue.indexOf('span') != -1){
                    elementValue = thisInstance.getValueBetweenSpan(elementValue);
                }
            }
            if(typeof elementValue == 'undefined'){
                //TODO
            }
            if(element.attr('type') == 'hidden'){
                if(element.data('fieldtype') == 'multipicklist'){
                    element = element.next().next();
                    if(element.data('fieldtype') == 'multipicklist'){
                        if(element.val()){
                            savedValue = elementValue;
                            elementValue = element.val().join(',');
                        }
                    }
                }else
                if(fieldName == 'total'){
                    savedValue = elementValue;
                    elementValue = jQuery('[name="grandTotal"]').html().trim();
                }else{
                    element = element.next();
                    if(element.data('fieldtype') == 'checkbox'){
                        elementValue = element.is(':checked') ? 1 : 0;
                    }
                }
            }else if(element.attr('type') == 'picklist'){
                var savedValue = element.data('selected-value');
            }
            
            if(element.data('fieldtype') == 'date'){
               elementData  = element.data('date-format'); 
            }
            //compare
            if(joincondition == 'and' || joincondition == ''){
                if(!thisInstance.checkCondition(fieldName,fieldValue,valueType,operation,elementValue,elementData,savedValue)){
                    allConditions = false;
                }
            }else{
                if(thisInstance.checkCondition(fieldName,fieldValue,valueType,operation,elementValue,elementData,savedValue)){
                    anyConditions = true;
                }
            }
        });
        if(anyConditions){
            return true;
        }else if(allConditions){
            return true;
        }else{
            return false;
        }
    },
    getValueBetweenSpan:function(elementValue){
        var val = '';
        val = elementValue.split('>')[1];
        val = val.trim();
        val = val.split('<')[0];
        val = val.trim();
        return val;
    },
    checkCondition: function (fieldName,fieldValue,valueType,operation,elementValue,elementData,savedValue){
        switch(operation){
            case 'is':
                return (fieldValue == elementValue);
                break;
            case 'contains':
                return (elementValue.indexOf(fieldValue) != -1);
                break;
            case 'does not contain':
                return (elementValue.indexOf(fieldValue) == -1);
                break;
            case 'starts with':
                return (elementValue.startsWith(fieldValue));
                break;
            case 'ends with':
                return (elementValue.endsWith(fieldValue));
                break;
            case 'has changed':
                return (savedValue != elementValue);
                break;
            case 'is empty':
                return (elementValue == '');
                break;
            case 'is not empty':
                return (elementValue != '');
                break;
            case 'less than':
                return (parseFloat(elementValue) < parseFloat(fieldValue));
                break;
            case 'greater than':
                return (parseFloat(elementValue) > parseFloat(fieldValue));
                break;
            case 'not equal to':
                return (parseFloat(elementValue) != parseFloat(fieldValue));
                break;
            case 'less than or equal to':
                return (parseFloat(elementValue) <= parseFloat(fieldValue));
                break;
            case 'greater than or equal to':
                return (parseFloat(elementValue) >= parseFloat(fieldValue));
                break;
            case 'has changed from':
                return ((elementValue != savedValue) && (savedValue == fieldValue));
                break;
            case 'before':
                return (this.newDate(elementValue,elementData) < this.newDate(fieldValue,elementData));//elementData has date-format
                break;
            case 'after':
                return (this.newDate(elementValue,elementData) > this.newDate(fieldValue,elementData));
                break;
            case 'between':
                var dateArray = fieldValue.split(',');
                return ( (this.newDate(elementValue,elementData) >= this.newDate(dateArray[0],elementData) && (this.newDate(elementValue,elementData) <= this.newDate(dateArray[1],elementData))) );
                break;
            case 'is added':
                return true;//how to implement this?
                break;
            case 'equals':
                return (parseFloat(elementValue) == parseFloat(fieldValue));
                break;
            case 'is not':
                return (this.newDate(elementValue,elementData) != this.newDate(fieldValue,elementData));
                break;
            case 'is today':
                return (this.newDate(elementValue,elementData) == this.newDate());
                break;
            case 'is tomorrow':
                var today = this.newDate();
                var tomorrow = this.newDate(today.getFullYear(),today.getMonth(),today.getDay() + 1);
                return (this.newDate(elementValue,elementData) == tomorrow);
                break;
            case 'is yesterday':
                var today = this.newDate();
                var yesterday = this.newDate(today.getFullYear(),today.getMonth(),today.getDay() - 1);
                return (this.newDate(elementValue,elementData) == yesterday);
                break;
            case 'less than hours before'://how to implement this?
                return true;
                break;
            case 'less than hours later'://how to implement this?
                return true;
                break;
            case 'more than hours before'://how to implement this?
                return true;
                break;
            case 'more than hours later'://how to implement this?
                return true;
                break;
            case 'less than days ago':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((today - selectedDay) < fieldValue);
                break;
            case 'less than days later':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((selectedDay - today) < fieldValue);
                break;
            case 'more than days ago':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((today - selectedDay) > fieldValue);
                break;
            case 'more than days later':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((selectedDay - today) > fieldValue);
                break;
            case 'days ago':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((today - selectedDay) == fieldValue);
                break;
            case 'days later':
                var today = this.newDate();
                var selectedDay = this.newDate(elementValue,elementData);
                return ((selectedDay - today) == fieldValue);
                break;
            case 'in less than'://how to implement this?
                return true;
                break;
            case 'in more than'://how to implement this?
                return true;
                break;
            default://how to implement this?
                return false;
                break;
            
                
        }
    },
    newDate: function(date, format){
        if(!date){return new Date();}
        formatArray = format.split('-');
        dateArray = date.split('-');
        return new Date(dateArray[formatArray.indexOf('yyyy')],dateArray[formatArray.indexOf('mm')] - 1,dateArray[formatArray.indexOf('dd')]);
    },
    performActions: function (actions,verifica) {
        var thisInstance = this;
            var customRules = new Array;

        jQuery.each(actions, function (index, action) {
            if(_META.view=="Edit"){
                //ACTION HIDE
                if(action.action == 'hide' && verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').hide().prev('td').hide();
                }else if(action.action == 'hide' && !verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').show().prev('td').show();
                }

                //ACTION SHOW
                if(action.action == 'show' && verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').show().prev('td').show();
                }else if(action.action == 'show' && !verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').hide().prev('td').hide();
                }
                //ACTION READONLY
                if(action.action == 'readonly' && verifica){
                    jQuery('[name=' + action.fieldname + ']').attr('disabled',true);
                }else if(action.action == 'readonly' && !verifica){
                    jQuery('[name=' + action.fieldname + ']').attr('disabled',false);
                }

                //ACTION MANDATORY
                if(action.action == 'mandatory' && verifica){
                    if(jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find(".redColor").html()==undefined)
                        jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').append("<span class='redColor'>*</span>");
                    //else
                        //jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find(".redColor").html("<span class='redColor'>*</span>");
                    jQuery('[name=' + action.fieldname + ']').attr('data-rule-required',true);
                    var fieldname=action.fieldname;
                    customRules[fieldname] = {
                        required: true
                    };
                }else if(action.action == 'mandatory' && !verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find('.redColor').remove();
                    jQuery('[name=' + action.fieldname + ']').attr('data-rule-required',false);
                    var fieldname=action.fieldname;
                    customRules[fieldname] = {
                        required: false
                    };
                }

                //ACTION NON MANDATORY
                if(action.action == 'non_mandatory' && verifica){
                    jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find('.redColor').remove();;
                    jQuery('[name=' + action.fieldname + ']').attr('data-rule-required',false);
                    var fieldname=action.fieldname;
                    customRules[fieldname] = {
                        required: false
                    };
                }else if(action.action == 'non_mandatory' && !verifica){
                    if(jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find(".redColor").html()==undefined)
                        jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').append("<span class='redColor'>*</span>");
                    //else
                        //jQuery('[name=' + action.fieldname + ']').closest('td').prev('td').find(".mandatory").html("<span class='redColor mandatory'>*</span>");
                    jQuery('[name=' + action.fieldname + ']').attr('data-rule-required',true);
                    var fieldname=action.fieldname;
                    customRules[fieldname] = {
                        required: true
                    };
                }
                $( "form" ).validate().settings.rules = customRules;

            }else{ 
                          //ACTION HIDE
                    if(action.action == 'hide' && verifica){
                        jQuery('#detailView').find('td[id*="' + action.fieldname +'"]').hide();
                    }else if(action.action == 'hide' && !verifica){
                        jQuery('#detailView').find('td[id*="' + action.fieldname +'"]').show();
                    }

                    //ACTION SHOW
                    if(action.action == 'show' && verifica){
                        jQuery('#detailView').find('td[id*="' + action.fieldname +'"]').show();
                    }else if(action.action == 'show' && !verifica){
                        jQuery('#detailView').find('td[id*="' + action.fieldname +'"]').hide();
                    }
                    
                    //ACTION NON MANDATORY
                    if(action.action == 'non_mandatory' && verifica){
                        $('td[id*="fieldValue_' + action.fieldname +'"]').find('[name="'+action.fieldname+'"].inputElement').attr('data-rule-required',false);
                        var fieldname=action.fieldname;
                        customRules[fieldname] = {
                            required: false
                        };
                        $( "form" ).validate().settings.rules = customRules;
                    }else if(action.action == 'non_mandatory' && !verifica){
                        $('td[id*="fieldValue_' + action.fieldname +'"]').find('[name="'+action.fieldname+'"].inputElement').attr('data-rule-required',true);
                        var fieldname=action.fieldname;
                        customRules[fieldname] = {
                            required: true
                        };
                        $( "form" ).validate().settings.rules = customRules;
                    }
                    
            }

        });
    },
    trHideCheck: function(tr){
        var tds = tr.find('td');
        var count = 0;
        jQuery.each(tds, function (index, td) {
            if(jQuery(td).css('display') == 'none'){
                count++;
            }
        });
        if(count >= 4){
            tr.hide();
        }else{
            tr.show();
        }
    },
    bindEvents: function () {
        var thisInstance = this;
        var moduleName = app.getModuleName();

        params = {
            'module': 'VGSLayouts',
            'action': "VGSLayoutsAjax",
            'mode': "getModuleLayout",
            'moduleName': moduleName
        };

        AppConnector.request(params).then(
            function (data) {
                if (data.success && data.result.existLayout) {
                    vgsLayoutArray = data.result.layout;
                    jQuery('#page').append('<input type="hidden" name="vgs_layouts" value=' + JSON.stringify(vgsLayoutArray) + ' />');
                    for (var i = 0; i < vgsLayoutArray.length; i++) {
                        var conditions = JSON.parse(vgsLayoutArray[i]['conditions']);
                        jQuery.each(conditions, function (index, condition) {
                            jQuery('[name=' + conditions.fieldname + ']').on('change', function (e) {
                                var instance = new VGSLayouts_Js();
                                instance.updateLayout(e);
                            });
                        });
                    }
                }
            });
    },
    bindEvents2: function () {
        var record = jQuery('input:hidden[name=record]').val();
        params = {
            'module': 'VGSLayouts',
            'action': 'VGSLayoutsColumnsAjax',
            'mode': 'getInitialFields',
            'vgsview': app.getViewName(),
            'sourcemodule': app.getModuleName(),
            'recordid': record
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        blocks = data.result.blocks;
                        for (var i = 0; i < blocks.length; i++) {


                            if (jQuery('select[name=' + blocks[i]['fieldname'] + ']').val() === blocks[i]['fieldvalue']) {
                                var blockHeader = jQuery('.editViewContents').find('.fieldBlockHeader:contains("' + blocks[i]['blocklabel'] + '")');
                                if(blockHeader.html() == blocks[i]['blocklabel']){
                                    var table = blockHeader.closest('.fieldBlockContainer');
                                    blockHeader.find('*[data-rule-required=true]').each(function(){
                                        jQuery(this).attr('data-rule-required',false);
                                    });
                                    table.hide();
                                }


                            }
                            jQuery('select[name=' + blocks[i]['fieldname'] + ']').on('change', function (e) {
                                var instance = new VGSLayouts_Js();
                                instance.updateBlocks(e);
                            });
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );
    },
    updateBlocks: function (e) {

        params = {
            'module': 'VGSLayouts',
            'action': 'VGSLayoutsColumnsAjax',
            'mode': 'getblocks',
            'vgsview': app.getViewName(),
            'sourcemodule': app.getModuleName(),
            'fieldname': e.target.name,
            'fieldvalue': e.target.value
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        var splitted = data.result.hiddenblocks;
                        for (var i = 0; i < splitted.length; i++) {
                            var blockHeader = jQuery(document).find('.fieldBlockHeader:contains("' + splitted[i] + '")');
                            if(blockHeader.html() == splitted[i]){
                                var table = blockHeader.closest('.fieldBlockContainer');
                                blockHeader.find('*[data-rule-required=true]').each(function(){
                                    jQuery(this).attr('data-rule-required',false);
                                });
                                table.hide();
                            }
                            

                        }

                        var splitted = data.result.visibleblocks;
                        for (var i = 0; i < splitted.length; i++) {
                            var blockHeader = jQuery(document).find('.fieldBlockHeader:contains("' + splitted[i] + '")');
                            if(blockHeader.html() == splitted[i]){
                                var table = blockHeader.closest('.fieldBlockContainer');
                                blockHeader.find('*[data-rule-required=false]').each(function(){
                                    jQuery(this).attr('data-rule-required',true);
                                });
                                table.show();
                            }
                            
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );

    },
    updateBlocksDetail: function (e) {

        var is_summary = jQuery('.summaryView').length;

        params = {
            'module': 'VGSLayouts',
            'action': 'VGSLayoutsColumnsAjax',
            'mode': 'getDetailBlocks',
            'is_summary': is_summary,
            'sourcemodule': app.getModuleName(),
            'vgsview':'Detail',
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {

                        if(is_summary){
                            console.log('WIP: Hidding the field in summary view');
                        }else{
                            blocks_info = data.result.hiddenblocks;
                            for (var i = 0; i < blocks_info.length; i++) {
                                var field_id = app.getModuleName() + '_detailView_fieldValue_' + blocks_info[i]['fieldname'];
                                if (jQuery.trim(jQuery('#' + field_id +' .value').text()) === blocks_info[i]['fieldvalue']) {
                                    var blockHeader = jQuery('.block_' + blocks_info[i]['blocklabel']);
                                    blockHeader.hide();

                                }
                            }
                        }
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );

    },
    bindEventsDetailView: function () {
        var thisInstance = this;
        var record = jQuery('input:hidden[name=record]').val();
        params = {
            'module': 'VGSLayouts',
            'action': 'VGSLayoutsColumnsAjax',
            'mode': 'getDetailBlocks',
            'sourcemodule': app.getModuleName(),
            'recordid': record
        }
        AppConnector.request(params).then(
                function (data) {
                    if (data.result.caption == 'OK') {
                        blocks = data.result.hiddenblocks;
                        jQuery('#page').append('<input type="hidden" name="vgs_dyn_blocks" value="' + JSON.stringify(blocks) + '" />');
                    

                        app.event.on(Vtiger_Detail_Js.PostAjaxSaveEvent, function (e, fieldBasicData, postSaveRecordDetails,contentHolder) {
                            if(fieldBasicData.data('type') == 'picklist'){
                                for (var i = 0; i < blocks.length; i++) {
                                    if(fieldBasicData.data('name') === blocks[i]['fieldname']){
                                        jQuery('.block').show().next('br').show();
                                    }
                                }

                                for (var i = 0; i < blocks.length; i++) {
                                    if (fieldBasicData.data('value') === blocks[i]['fieldvalue']) {
                                          var blockHeader = jQuery('div[class="block block_' + blocks[i]['blocklabel'] + '"]');
                                        blockHeader.hide();
    
                                    }
                                }
                            }
                        });

                        

                        
                    }
                },
                function (jqXHR, textStatus, errorThrown) {
                }
        );
    }
});


jQuery(document).ready(function () {
    var instance = new VGSLayouts_Js();
    if(_META.view == 'Detail' || _META.view == 'Edit' ){
        instance.updateLayout();
    
        app.event.on('post.relatedListLoad.click',function(){
            instance.updateLayout();
        });
        $('a.editAction').on('click',function(e){
            setTimeout(function () {
//            if($( "[name='commentcontent']" ).length){
//                thisInstance.ready();
//            }else{
                instance.updateLayout();
//            }
            }, 500);
        });
    }
});
