/**
 * VGS Layouts
 *
 * @package        VGS Layouts
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2018 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class('VGSLayouts_JsList', {}, {
    /**
     * Function to register change event for source module field
     */
    registerOnChangeEventOfSourceModule: function () {
        jQuery('#sourceModule').on('change', function (e) {
            jQuery('#picklistFields').find('option').remove().end().append('<option value="--">--</option>').val('--');
            jQuery("#picklistFields").trigger('liszt:updated');
            jQuery('#picklistFieldValues').find('option').remove().end().append('<option value="--">--</option>').val('--');
            jQuery("#picklistFieldValues").trigger('liszt:updated');
            jQuery("#fieldsSelect").select2('data', null);

            var element = jQuery(e.currentTarget);
            var params = {};
            var sourceModule = element.val();

            params = {
                'module': 'VGSLayouts',
                'action': "VGSLayoutsAjax",
                'mode': "changeModule",
                'sourceModule': sourceModule
            }

            AppConnector.request(params).then(
                    function (data) {
                        if (data) {
                            jQuery.each(data.result.options, function (i, item) {

                                var o = new Option(item, i);
                                jQuery(o).html(item);
                                jQuery("#picklistFields").append(o);
                                jQuery("#picklistFields").trigger('liszt:updated');

                            });
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                        console.log("source module change" + textStatus);
                    });
        });
    },
    /**
     * Function to register change event for source module field
     */
    registerOnChangeEventOfPicklistField: function () {
        jQuery('#picklistFields').on('change', function (e) {
            jQuery('#picklistFieldValues').find('option').remove().end().append('<option value="--">--</option>').val('--');
            jQuery("#picklistFieldValues").trigger('liszt:updated');
            jQuery("#fieldsSelect").select2('data', null);
            var element = jQuery(e.currentTarget);
            var params = {};
            var picklistField = element.val();

            params = {
                'module': 'VGSLayouts',
                'action': "VGSLayoutsAjax",
                'mode': "changePicklistField",
                'sourceModule': jQuery('#sourceModule').val(),
                'picklistField': picklistField
            }

            AppConnector.request(params).then(
                    function (data) {
                        if (data) {
                            jQuery.each(data.result.options, function (i, item) {

                                var o = new Option(item, i);
                                jQuery(o).html(item);
                                jQuery("#picklistFieldValues").append(o);
                                jQuery("#picklistFieldValues").trigger('liszt:updated');

                            });
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                        console.log("source module change" + textStatus);
                    });
        });
    },
    /**
     * Function to register change event for source module field
     */
    registerOnChangeEventOfPicklistValue: function () {
        jQuery('#picklistFieldValues').on('change', function (e) {
            jQuery("#fieldsSelect").select2('data', null);
            var element = jQuery(e.currentTarget);
            var params = {};

            params = {
                'module': 'VGSLayouts',
                'action': "VGSLayoutsAjax",
                'mode': "changePicklistValue",
                'sourceModule': jQuery('#sourceModule').val(),
                'picklistField': jQuery("#picklistFields").val(),
                'picklistFieldValue': element.val()
            }

            AppConnector.request(params).then(
                    function (data) {
                        if (data) {
                            jQuery('#fieldSelectTD').html(data.result.caption);
                            app.showSelect2ElementView(jQuery('body').find('select.select2'));
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                        console.log("source module change" + textStatus);
                    });
        });
    },
    /**
     * Function to register event for saving module custom numbering
     */
    saveVGSLayouts: function () {
        jQuery('.saveButton').on('click', function (e) {
            params = {
                'module': app.getModuleName(),
                'action': "VGSLayoutsAjax",
                'mode': "saveColumnsForModule",
                'sourceModule': jQuery('#sourceModule').val(),
                'picklistField': jQuery("#picklistFields").val(),
                'picklistFieldValue': jQuery("#picklistFieldValues").val(),
                'fields': jQuery('#fieldsSelect').val()
            }
            AppConnector.request(params).then(
                    function (data) {
                        var params;
                        if (data.success == true) {
                            params = {
                                animation: "show",
                                type: 'info',
                                title: data.result.caption
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                            document.location = "index.php?parent=Settings&module=VGSLayouts&view=SettingList";
                        } else {
                            var errorMessage = app.vtranslate(data.error.message);
                            params = {
                                animation: "show",
                                title: errorMessage,
                                type: 'error'
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                        console.log("source module change" + textStatus);
                    });
        });
    },
    deleteVGSLayouts: function () {
        jQuery('.deleteRecordButton').on('click', function (e) {
            var line_id = jQuery(this).attr('id');

            app.helper.showConfirmationBox({'message':app.vtranslate('LBL_DELETE_CONFIRMATION')}).then(function(){
                params = {
                'module': app.getModuleName(),
                'action': "VGSLayoutsAjax",
                'mode': "deleteColumnsForModule",
                'record_id': line_id,
            }
            
            AppConnector.request(params).then(
                    function (data) {
                        var params;
                        if (data.success == true) {
                            jQuery('#'+line_id).closest('tr').hide();
                            params = {
                                animation: "show",
                                type: 'info',
                                title: data.result.caption
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                            
                        } else {
                            var errorMessage = app.vtranslate(data.error.message);
                            params = {
                                animation: "show",
                                text: errorMessage,
                                title: 'error'
                            };
                            Vtiger_Helper_Js.showPnotify(params);
                        }
                    },
                    function (jqXHR, textStatus, errorThrown) {
                        console.log("source module change" + textStatus);
                    });
            });
        });
    },
    registerAppTriggerEvent : function() {
            jQuery('.app-menu').removeClass('hide');
            var toggleAppMenu = function(type) {
                    var appMenu = jQuery('.app-menu');
                    var appNav = jQuery('.app-nav');
                    appMenu.appendTo('#page');
                    appMenu.css({
                            'top' : appNav.offset().top + appNav.height(),
                            'left' : 0
                    });
                    if(typeof type === 'undefined') {
                            type = appMenu.is(':hidden') ? 'show' : 'hide';
                    }
                    if(type == 'show') {
                            appMenu.show(200, function() {});
                    } else {
                            appMenu.hide(200, function() {});
                    }
            };

            jQuery('.app-trigger, .app-icon, .app-navigator').on('click',function(e){
                    e.stopPropagation();
                    toggleAppMenu();
            });

            jQuery('html').on('click', function() {
                    toggleAppMenu('hide');
            });

            jQuery(document).keyup(function (e) {
                    if (e.keyCode == 27) {
                            if(!jQuery('.app-menu').is(':hidden')) {
                                    toggleAppMenu('hide');
                            }
                    }
            });

            jQuery('.app-modules-dropdown-container').hover(function(e) {
                    var dropdownContainer = jQuery(e.currentTarget);
                    jQuery('.dropdown').removeClass('open');
                    if(dropdownContainer.length) {
                            if(dropdownContainer.hasClass('dropdown-compact')) {
                                    dropdownContainer.find('.app-modules-dropdown').css('top', dropdownContainer.position().top - 8);
                            } else {
                                    dropdownContainer.find('.app-modules-dropdown').css('top', '');
                            }
                            dropdownContainer.addClass('open').find('.app-item').addClass('active-app-item');
                    }
            }, function(e) {
                    var dropdownContainer = jQuery(e.currentTarget);
                    dropdownContainer.find('.app-item').removeClass('active-app-item');
                    setTimeout(function() {
                            if(dropdownContainer.find('.app-modules-dropdown').length && !dropdownContainer.find('.app-modules-dropdown').is(':hover') && !dropdownContainer.is(':hover')) {
                                    dropdownContainer.removeClass('open');
                            }
                    }, 500);

            });

            jQuery('.app-item').on('click', function() {
                    var url = jQuery(this).data('defaultUrl');
                    if(url) {
                            window.location.href = url;
                    }
            });

            jQuery(window).resize(function() {
                    jQuery(".app-modules-dropdown").mCustomScrollbar("destroy");
                    app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                            setHeight: $(window).height(),
                            autoExpandScrollbar: true
                    });
                    jQuery('.dropdown-modules-compact').each(function() {
                            var element = jQuery(this);
                            var heightPer = parseFloat(element.data('height'));
                            app.helper.showVerticalScroll(element, {
                                    setHeight: $(window).height()*heightPer - 3,
                                    autoExpandScrollbar: true,
                                    scrollbarPosition: 'outside'
                            });
                    });
            });
            app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                    setHeight: $(window).height(),
                    autoExpandScrollbar: true,
                    scrollbarPosition: 'outside'
            });
            jQuery('.dropdown-modules-compact').each(function() {
                    var element = jQuery(this);
                    var heightPer = parseFloat(element.data('height'));
                    app.helper.showVerticalScroll(element, {
                            setHeight: $(window).height()*heightPer - 3,
                            autoExpandScrollbar: true,
                            scrollbarPosition: 'outside'
                    });
            });
    },
    /**
     * Function to register events
     */
    registerEvents: function () {
        var thisInstance = this;
        this.deleteVGSLayouts();
        this.saveVGSLayouts();
        this.registerAppTriggerEvent();
    }
})
jQuery(document).ready(function () {
    var VGSLayoutsInstance = new VGSLayouts_JsList();
    VGSLayoutsInstance.registerEvents();
});
