/**
 * VGS Global Search
 *
 * @package        VGS Global Search
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2017 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class('VGSGlobalSearchSettings_Js', {}, {
    
    registerOnChangeEventOfSourceModule: function () {
        jQuery('#sourceModule').on('change', function (e) {
            jQuery('#fieldsSelect').find('option').remove().end().append('<option value="--">--</option>').val('--');
            jQuery("#fieldsSelect").trigger('liszt:updated');
            jQuery("#fieldsSelect").select2('data', null);

            var element = jQuery(e.currentTarget);
            var params = {};
            var sourceModule = element.val();

            var params = {
                'module': 'VGSGlobalSearch',
                'action': 'VGSGlobalSearchAjax',
                'mode': 'changeModule',
                'sourceModule': sourceModule
            }
            
            app.helper.showProgress();
            app.request.get({ data: params }).then(function (e, res) {
                
                if (!e && res) {
                    console.log(res);
                    jQuery.each(res.options, function (i, item) {

                        var o = new Option(item, i);
                        jQuery(o).html(item);
                        jQuery("#fieldsSelect").append(o);
                        

                    });

                    jQuery("#fieldsSelect").trigger('liszt:updated');
                    app.helper.hideProgress();
                }else{
                    app.helper.hideProgress();
                    var errorMessage= app.vtranslate("Error Loading Module Fields");   
                    app.helper.showErrorNotification({'message': errorMessage});
                }
            });

            var params = {
                'module': 'VGSGlobalSearch',
                'action': 'VGSGlobalSearchAjax',
                'mode': 'getFiltersForModule',
                'sourceModule': sourceModule
            }
            
            app.helper.showProgress();
            app.request.get({ data: params }).then(function (e, res) {
                
                if (!e && res) {
                    console.log(res);
                    jQuery("#cvselect").html('');
                    jQuery.each(res.options, function (i, item) {

                        var o = new Option(item, i);
                        jQuery(o).html(item);
                        jQuery("#cvselect").append(o);
                        

                    });

                    jQuery("#cvselect").trigger('liszt:updated');
                    app.helper.hideProgress();
                }else{
                    app.helper.hideProgress();
                    var errorMessage= app.vtranslate("Error Loading Module Fields");   
                    app.helper.showErrorNotification({'message': errorMessage});
                }
            });

        });
    },
    saveVGSGlobalSearch: function () {
        jQuery('.saveButton').on('click', function (e) {

            var params = {
                'module': 'VGSGlobalSearch',
                'action': 'VGSGlobalSearchAjax',
                'mode': 'save',
                'sourceModule': jQuery('#sourceModule').val(),
                'fields': jQuery('#fieldsSelect').val(),
                'filter': jQuery('#cvselect').val()
            }
            
            app.helper.showProgress();
            app.request.get({ data: params }).then(function (e, res) {
                
                if (!e && res) {
                    app.helper.hideProgress();                    
                    var successMessage= app.vtranslate("Setting Succesfully Saved");   
                    app.helper.showSuccessNotification({'message': successMessage});
                    document.location = "index.php?parent=Settings&module=VGSGlobalSearch&view=SettingList";
                }else{
                    app.helper.hideProgress();
                    var errorMessage= app.vtranslate("Error Saving New Entry");   
                    app.helper.showErrorNotification({'message': errorMessage});
                }
            });
        });
    },
    deleteVGSGlobalSearch: function () {
        jQuery('.deleteRecordButton').on('click', function (e) {

            var params = {
                'module': 'VGSGlobalSearch',
                'action': 'VGSGlobalSearchAjax',
                'mode': 'delete',
                'record_id': jQuery(this).attr('id'),
            }
            
            app.helper.showProgress();
            app.request.get({ data: params }).then(function (e, res) {
                
                if (!e && res) {
                    app.helper.hideProgress();
                    var successMessage= app.vtranslate("Setting Succesfully Deleted");   
                    app.helper.showSuccessNotification({'message': successMessage});
                    document.location = "index.php?parent=Settings&module=VGSGlobalSearch&view=SettingList";
                }else{
                    app.helper.hideProgress();
                    var errorMessage= app.vtranslate("Error Deleting");   
                    app.helper.showErrorNotification({'message': errorMessage});
                }
            });
        });
    },
    addIndexVGSGlobalSearch: function () {
        jQuery('.addIndex').on('click', function (e) {
	    var thisInstance = this;
	    var message = app.vtranslate("This will add an index in your Vtiger module tables and speed up the search. Do you wish to continue?");
	    app.helper.showConfirmationBox({'message' : message}).then(
		function(e) {
		    var params = {
			'module': 'VGSGlobalSearch',
			'action': 'VGSGlobalSearchAjax',
			'mode': 'addIndex',
			'record_id': jQuery(thisInstance).attr('id'),
		    }

		    app.helper.showProgress();
		    app.request.get({ data: params }).then(function (e, res) {

			if (!e && res) {
			    app.helper.hideProgress();
			    var successMessage= app.vtranslate("Index added Succesfully");   
			    app.helper.showSuccessNotification({'message': successMessage});
			}else{
			    app.helper.hideProgress();
			    var errorMessage= app.vtranslate("Error Adding Index");   
			    app.helper.showErrorNotification({'message': errorMessage});
			}
		    });
		},
		    function(error, err){
		}
	    );
        });
    },
    registerEvents: function () {
        var thisInstance = this;
        this.registerOnChangeEventOfSourceModule();
        this.deleteVGSGlobalSearch();
        this.saveVGSGlobalSearch();
        this.addIndexVGSGlobalSearch();
        jQuery('#sourceModule').trigger('change');
    }
})
jQuery(document).ready(function () {
    var VGSGlobalSearchInstance = new VGSGlobalSearchSettings_Js();
    VGSGlobalSearchInstance.registerEvents();
});
