/**
 * VGS Global Search
 *
 * @package        VGS Global Search
 * @author         Conrado Maggi
 * @license        Commercial
 * @copyright      2017 VGS Global - www.vgsglobal.com
 * @version        Release: 1.0
 */

jQuery.Class("VGSGlobalSearch_Js", {}, {
    registerEvents: function () {
        thisInstance = this;

        //Need to hack the search from
        thisInstance.updateSearchImport();
        thisInstance.registerGlobalSearch();
        thisInstance.addSearchListener();

    },
    updateSearchImport: function () {
        jQuery('.search-link .keyword-input').unbind( "keypress" );
        jQuery('.search-link .keyword-input').addClass('keyword-input-vgs');
    },
    updateNextBackArrowEvents: function () {
//        jQuery('div.listViewPageDiv .nextPageButton').off( "click" );
//        jQuery('div.listViewPageDiv .previousPageButton').off( "click" );
        jQuery('div.listViewPageDiv .previousPageButton').removeClass('.previousPageButton').addClass('previousPageButton-vgs');
        jQuery('div.listViewPageDiv .nextPageButton').removeClass('nextPageButton').addClass('nextPageButton-vgs');
    },
    registerGlobalSearch: function () {
        var thisInstance = this;
        jQuery('.search-link .keyword-input-vgs').on('keypress', function (e) {
            if (e.which == 13) {

                var element = jQuery(e.currentTarget);
                var searchValue = element.val();
                var data = {};
                data['searchValue'] = searchValue;
                data['page'] = 1;
                element.trigger('GS_SEARCH_INTIATED', data);
            }
        });
    },
    registerNextBackArrowEvents: function () {
        var self = this;
        var container = jQuery('div.listViewPageDiv');
        jQuery('div.listViewPageDiv .nextPageButton-vgs').off('click');
        container.on('click', '.nextPageButton-vgs', function (e) {
            var searchValue = jQuery('#searchValue').val();
            var pageNumber = container.find('[name="pageNumber"]').val();
            var nextPageNumber = parseInt(parseFloat(pageNumber)) + 1;
            var params = {};
            params.searchValue = searchValue;
            params.page = nextPageNumber;
            jQuery('.search-link .keyword-input-vgs').trigger('GS_SEARCH_INTIATED', params);
        });
        jQuery('div.listViewPageDiv .previousPageButton-vgs').off('click');
        container.on('click', '.previousPageButton-vgs', function (e) {
            var searchValue = jQuery('#searchValue').val();
            var pageNumber = container.find('[name="pageNumber"]').val();
            var previousPageNumber = parseInt(parseFloat(pageNumber)) - 1;
            if (pageNumber > 1) {
                    var params = {};
                    params.searchValue = searchValue;
                    params.page= previousPageNumber;
                    jQuery('.search-link .keyword-input-vgs').trigger('GS_SEARCH_INTIATED', params);
            }
        });
    },
    addSearchListener: function () {
        var thisInstance = this;
        jQuery('.search-link .keyword-input-vgs').on('GS_SEARCH_INTIATED', function (e, args) {
            var val = args.searchValue;
            var page = args.page;
            var url = '?module=VGSGlobalSearch&view=ListAjax&mode=searchAll&value=' + encodeURIComponent(val) + '&page=' + page;
            app.helper.showProgress();
            app.request.get({ 'url': url }).then(function (error, data) {
                if (error == null) {
                    app.helper.hideProgress();
		    if($('#searchResults-container').length == 0){
			app.helper.loadPageOverlay(data).then(function (modal) {
			    modal.find('.keyword-input').val(jQuery('.keyword-input').val());
			    Vtiger_SearchList_Js.intializeListInstances(modal);
			    thisInstance.updateNextBackArrowEvents();
			    thisInstance.registerNextBackArrowEvents();
			});
		    }else{
			app.helper.hidePageOverlay();
			app.helper.loadPageOverlay(data).then(function (modal) {
			    modal.find('.keyword-input').val(jQuery('.keyword-input').val());
			    thisInstance.updateNextBackArrowEvents();
			    thisInstance.registerNextBackArrowEvents();
			});
		    }
                } else {
                    app.helper.hideProgress();
                    var errorMessage = app.vtranslate("Error Performing the Search. Please Contact Support");
                    console.log(error);
                    app.helper.showErrorNotification({ 'message': errorMessage });
                }
            });
        });
    },
});

$(window).on("load", function(){
    var instance = new VGSGlobalSearch_Js();
    instance.registerEvents();

});
