/*+**********************************************************************************
 * The content of this file is subject to the ITS4GoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

jQuery.Class('ITS4YouGoogleCalendarSync_ITS4YouGoogleCalendarSyncHeader_Js', {}, {
    checkIfUserIsConnected: function () {
        return true;
    },
    createSynchronizationButton: function (buttonId) {
        var addEventButton = jQuery('#' + buttonId);
        var eventButtonParent = jQuery(addEventButton).closest('li');
        // addEventButton.remove();
        var newLiElement = jQuery('<li />');
        var synchronizationButton = jQuery('<button />');
        jQuery(synchronizationButton).attr('id', 'its4you_google_synchronization_synchronize');
        jQuery(synchronizationButton).attr('class', 'btn addButton btn-default module-buttons');
        jQuery(synchronizationButton).attr('data-url', 'index.php?module=ITS4YouGoogleCalendarSync&view=List&operation=sync');
        jQuery(synchronizationButton).text('  Synchronize');

        var faSync = jQuery('<div />');
        jQuery(faSync).attr('class', 'fa fa-refresh');
        jQuery(faSync).attr('aria-hidden', 'true');
        jQuery(synchronizationButton).prepend(faSync);

        jQuery(newLiElement).append(synchronizationButton);
        jQuery(eventButtonParent).after(newLiElement);
    },
    registerEvents: function() {
        var connected = this.checkIfUserIsConnected();

        if (connected) {
            var view = app.getViewName();
            var buttonId = "calendarview_basicaction_addtask";
            if (view === "List") {
                buttonId = "Calendar_listView_basicAction_LBL_ADD_EVENT";
            }
            this.createSynchronizationButton(buttonId);
            var syncButton = jQuery('#its4you_google_synchronization_synchronize');
            if (syncButton.length) {
                syncButton.on('click', function () {

                    var params = {
                        module: "ITS4YouGoogleCalendarSync",
                        action: "Synchronize"
                    };

                    var progressIndicatorElement = jQuery.progressIndicator({
                        'position' : 'html',
                        'blockInfo' : {
                            'enabled' : true
                        }
                    });

                    app.request.post({data: params}).then(
                        function (err, response) {
                            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                            if (err === null) {
                                app.helper.showSuccessNotification({'message': response.message});
                            }
                        }
                    );
                });
            }
        }
    }
});

jQuery(document).ready(function () {
    var moduleName = app.getModuleName();
    if (moduleName === 'Calendar') {
        var instance = new ITS4YouGoogleCalendarSync_ITS4YouGoogleCalendarSyncHeader_Js();
        instance.registerEvents();
    }
});
