/*+**********************************************************************************
 * The content of this file is subject to the ITS4GoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

Vtiger_ExtensionCommon_Js("ITS4YouGoogleCalendarSync_Extension_Js", {}, {
    credentialsFormEvent: function () {
        var thisInstance = this;

        jQuery('#saveCredentials').on('click', function (e) {
            e.preventDefault();
            thisInstance.validateCredentialsForm();
        });

        jQuery('#credentialsType').on('change', function(e){
            var element = jQuery(e.currentTarget);
            var type = element.val();

            var elementsCredentialsAttr = jQuery(".credentials-attr");
            if (type == "default") {
                elementsCredentialsAttr.addClass('hide');
            } else {
                elementsCredentialsAttr.removeClass('hide');
            }

        });

    },
    validateCredentialsForm: function() {
        var thisInstance = this;

        var form = jQuery('#credentialsForm');
        form.vtValidate();

        if (form.valid()) {
            thisInstance.saveCredentialsForm();
        }
    },
    saveCredentialsForm: function () {
        var thisInstance = this;
        var form = jQuery('#credentialsForm');

        var formData = form.serializeFormData();
        var params = {
            module: "ITS4YouGoogleCalendarSync",
            action: "SaveSettings",
            formData: formData
        };

        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });

        app.request.post({data: params}).then(
            function (err, response) {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if (err === null) {
                    if (response.success) {
                        app.helper.showSuccessNotification({message: response.text});
                        thisInstance.loadCredentialsContent();
                    }
                }
            }
        );
    },
    loadCredentialsContent: function () {
        window.location.href = "index.php?module=Calendar&view=Extension&extensionModule=ITS4YouGoogleCalendarSync&extensionView=Extension&app=MARKETING";
    },
    updateCredentialsContent: function () {
        var thisInstance = this;
        var params = {
            module: "ITS4YouGoogleCalendarSync",
            view: 'CalendarSettings',
            onlyCredentialsContent: true,
            dataType: 'json'
        };

        jQuery('#calendarSettingsContents').empty();
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        app.request.post({data: params}).then(
            function (err, response) {

                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if (err === null) {
                    jQuery('#calendarSettingsContents').html(response);

                    var ele = jQuery('.directionsSelect').closest('div');
                    app.changeSelectElementView(ele);

                    thisInstance.credentialsFormEvent();
                    thisInstance.registerConnectToGoogleEvent();
                    thisInstance.registerTabClickEvent();
                    thisInstance.registerRemoveConnection();
                    thisInstance.uninstallCalendarSynchronizationButtonEvent();
                } else {

                    alert(err);
                }
            }
        );
    },
    registerConnectToGoogleEvent: function () {
        var thisInstance = this;
        jQuery('#connectToGoogle').on('click', function (e) {
            var authorize = true;
            var url = "index.php?module=Calendar&view=Extension&extensionModule=ITS4YouGoogleCalendarSync&extensionView=Extension&authorize="+true;
            var win=window.open(url,'','height=600,width=600,channelmode=1');

            window.sync = function() {

                var params = {
                    'module' : 'ITS4YouGoogleCalendarSync',
                    'action' : 'HelpAjax'
                };
                app.request.post({data: params}).then(function (err, response) {
                    if (err === null) {
                        app.helper.showSuccessNotification({message: response.message});
                        thisInstance.loadCredentialsContent();
                    }
                });
            };

            win.onunload = function(){
            };
        });
    },
    registerTabClickEvent: function() {
        var thisInstance = this;
        jQuery("#vtigerToGoogleTab").on('click', function (e) {
            var element = jQuery(e.currentTarget);
            var content = jQuery('#vtigerToGoogleContent');
            content.empty();
            var cssClass = 'selectGoogleCalendar';

            var params = {
                module: "ITS4YouGoogleCalendarSync",
                view: "ListAjax",
                mode: "showVtigerToGoogleContent"
            };

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            
            app.request.post({data: params}).then(
                function (err, response) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    if (err === null) {
                        content.html(response);
                        thisInstance.updateSelectElementViewsInTabContent(cssClass);
                        thisInstance.registerVtigerToGoogleEvents();
                    }
                }
            );
        });
    },
    updateSelectElementViewsInTabContent: function (cssClass){
        jQuery('.'+cssClass).each(function (index, element) {
            var ele = jQuery(element);
            app.changeSelectElementView(ele, 'select2');

        });
    },
    submitVtigerToGoogleCalendarFormEvent: function () {
        var form = jQuery('#vtigerToGoogleForm');
        form.on('submit', function (e) {
            e.preventDefault();
            var formData = form.serializeFormData();
            var params = {
                module: "ITS4YouGoogleCalendarSync",
                action: 'SaveAjax',
                mode: 'saveVtigerTypeToGoogleCalendarMapping',
                formData: formData
            };

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            app.request.post({data: params}).then(
                function(err, response) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    if (err === null) {
                        app.helper.showSuccessNotification({message: response.text});
                    }
                }
            );
        });
    },
    registerVtigerToGoogleEvents: function () {
        this.submitVtigerToGoogleCalendarFormEvent();
    },
    registerRemoveConnection: function () {
        var thisInstance = this;
        jQuery('#removeConnection').on('click', function () {
            var params = {
                module: "ITS4YouGoogleCalendarSync",
                action: "RemoveConnection",
                dataType: 'json'
            };

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });

            app.request.post({data: params}).then(
                function (err, response) {
                    progressIndicatorElement.progressIndicator({'mode': 'hide'});
                    if (err === null) {
                        if (response.success) {
                            app.helper.showSuccessNotification({message: response.text});
                            thisInstance.loadCredentialsContent();
                        }
                    }
                }
            );

        });
    },
    uninstallCalendarSynchronizationButtonEvent :function () {
        jQuery('#uninstallGoogleSync').on('click', function () {
            var message = app.vtranslate('LBL_DELETE_CONFIRMATION');
            app.helper.showConfirmationBox({'message': message}).then(function () {
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });
                var params = {
                    module: "ITS4YouGoogleCalendarSync",
                    action: "UninstallGoogleSync"
                };

                AppConnector.request(params).then(
                    function (err, response) {
                        progressIndicatorElement.progressIndicator({'mode': 'hide'});
                        app.hideModalWindow();
                        var url;
                        url = "index.php?module=Calendar&view=List";
                        window.location.href = url;
                    }
                );
            });
        });
    },
    registerEvents: function () {
        this.credentialsFormEvent();
        this.registerConnectToGoogleEvent();
        this.registerTabClickEvent();
        this.registerRemoveConnection();
        this.uninstallCalendarSynchronizationButtonEvent();
    }
});

