/***********************************************************************************************
** The contents of this file are subject to the Vtiger Docusign License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
*************************************************************************************************/

Vtiger_Index_Js("Docusign_Uninstall_Js",{
		currentInstance 	: false,
		getInstanceByView 	: function(){
	    var view 			= jQuery('#currentView').val();
		var jsFileName 		= view+'View';
	    var moduleClassName = view+"_"+jsFileName+"_Js";
	    if(typeof window[moduleClassName] != 'undefined'){
			var instance 	= new window[moduleClassName]();
		} else {
			instance 		= new Docusign_Uninstall_Js();
		}
	    return instance;
	},
},{
	/**
	 * Function to add vtiger Loding Screen when user clicks on button
	 */
	busyScreen : function() {
		
		var btn = jQuery('.btn').click(function(e) {
			var progressIndicatorElement = jQuery.progressIndicator({
				'position' 		: 'html',
				'message' 		: app.vtranslate('JS_PLEASE_WAIT'),
				'blockInfo' 	: {
					'enabled' 	: true
				}
			});
		});
	},
	
	/**
	 * register events for Uninstall window
	 */
	registerEvents : function() {
		var thisInstance = this;
		thisInstance.busyScreen();
		
		var instances 		= new Vtiger_Index_Js();
		instances.registerEvents();
	}
});
