/***********************************************************************************************
** The contents of this file are subject to the Vtiger Docusign License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
*************************************************************************************************/
Vtiger_Index_Js("Docusign_Setting_Js",{

		currentInstance : false,
		getInstanceByView : function(){
	    var view = jQuery('#currentView').val();
		var jsFileName = view+'View';
	    var moduleClassName = view+"_"+jsFileName+"_Js";
	    if(typeof window[moduleClassName] != 'undefined'){
			var instance = new window[moduleClassName]();
			
		} else {
			instance = new Docusign_Setting_Js();
		}
	    return instance;
	},
	
	
},{
	tks_getModule : function(data) {
           return jQuery('[name= "module"]').val(); 
	},
	
	/*
	* Function to Save the CustomLabel Details
	*/
        
	saveLicenseKey : function(form,is_install) {
		var thisInstance = this;
	                
                if (is_install)
                {
                    var licensekey_val = jQuery('#licensekey').val()
                    //params = "index.php?module="+thisInstance.tks_getModule()+"&action=License&mode=editLicense&type=activate&licensekey="+licensekey_val;
                    params = {};
                    params.module = thisInstance.tks_getModule();
                    params.licensekey = licensekey_val;
                    params.action = "Setting";
                    params.mode = "editLicense";
                    params.type = "activate"; 
                    //params.dataType='json';
                
                }
                else
                {
                    if(typeof params == 'undefined' ) {
			params = {};
                    }
                
                    var params = form.serializeFormData();
                }    
                
		thisInstance.validateLicenseKey(params).then(
			function(data) {
				
                            if (!is_install) 
                            {
                                app.hideModalWindow();
                            
                                var params = {
                                        text: app.vtranslate(data['message'])
                                };
                                thisInstance.showMessage(params);
                            
                                jQuery('#license_key_val').val(data.licensekey);
                                jQuery('#license_key_label').html(data.licensekey);

                                jQuery('#divgroup1').hide();
                                jQuery('#divgroup2').show();
                            }   
                            else
                            {
                                jQuery('#step1').hide();
                                jQuery('#step2').show();
                                
                                jQuery('#steplabel1').removeClass("active");
                                jQuery('#steplabel2').addClass("active");
                            }    
			},
			function(data,err) {
			}
		);
	},
	
	validateLicenseKey : function(data) {
            
            var thisInstance = this;
            var aDeferred = jQuery.Deferred();

            var form = jQuery('#editLicense');
            var CustomLabelElement = form.find('[name="licensekey"]');

				 thisInstance.checkLicenseKey(data).then(
                    function(data){
                        aDeferred.resolve(data);
                    },
                    function(data, err){
                       // CustomLabelElement.validationEngine('showPrompt', data['message'] , 'error','bottomLeft',true);
						app.helper.showErrorNotification({message :app.vtranslate( data['message'])});
                        aDeferred.reject(data);
                    }
                );

            return aDeferred.promise();
            
	},
      checkLicenseKey : function(params) {
		var aDeferred = jQuery.Deferred();
                
                 var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
					'message' : app.vtranslate('JS_LBL_PLEASE_WAIT'),
                    'blockInfo' : {
                            'enabled' : true
                    }
                });
                
		AppConnector.request(params).then(
			function(data) {
								progressIndicatorElement.progressIndicator({'mode':'hide'});
                                var response = data['result'];
                                var result = response['success'];
  
				if(result == true) {
                                    aDeferred.resolve(response);
				} else {
					
                                    aDeferred.reject(response);
				}
			},
			function(error,err){
				progressIndicatorElement.progressIndicator({'mode':'hide'});
				aDeferred.reject();
			}
		);
        
                //progressIndicatorElement.progressIndicator({'mode':'hide'});
		return aDeferred.promise();
	},
	 
	registerEvents: function() {
	},
        
        registerInstallEvents: function() {
            var thisInstance = this;
            var form = jQuery('#editLicense');
            var params = app.validationEngineOptions;
             
            params.onValidationComplete = function(form, valid){

                if(valid) {
					
                    thisInstance.saveLicenseKey(form,true);
															  
                    return valid;
															  
                }
            }
            form.validationEngine(params);
            form.submit(function(e) {
                    e.preventDefault();
            })
	},
	registerInstallActions : function() {
		
            var thisInstance = this;

            jQuery('#next_button').click(function(e) {
                    window.location.href = "index.php?module="+thisInstance.tks_getModule()+"&view=List";
            });
            
            
	},
});

jQuery(document).ready(function() {
	var instance = Docusign_Setting_Js.getInstanceByView();
	instance.registerEvents();
	instance.registerInstallEvents();
	Docusign_Setting_Js.currentInstance = instance;
	var instance2 = new Vtiger_Index_Js();
	instance2.registerEvents();
})