/***********************************************************************************************
** The contents of this file are subject to the Vtiger Docusign License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
*************************************************************************************************/

Vtiger_Edit_Js("Docusign_Edit_Js", {} ,{
			   
		INTERNAL_FILE_LOCATION_TYPE : 'I',
		EXTERNAL_FILE_LOCATION_TYPE : 'E',	   
		
		getMaxiumFileUploadingSize : function() {
			//TODO : get it from the server
			return this.getForm().find('.maxUploadSize').data('value');
		},

		isFileLocationInternalType : function(fileLocationElement) {
			if(fileLocationElement.val() == this.INTERNAL_FILE_LOCATION_TYPE) {
			return true;
			}
			return false;
		},

		isFileLocationExternalType : function(fileLocationElement) {
			if(fileLocationElement.val() == this.EXTERNAL_FILE_LOCATION_TYPE) {
				return true;
			}
			return false;
		},
			   
		registerFileLocationTypeChangeEvent : function() {
		var container = this.getForm();
		var thisInstance = this;
		container.on('change', 'select[name="filelocationtype"],input[name="filelocationtype"]', function(e){
                    var fileLocationTypeElement = container.find('select[name="filelocationtype"]');
            var fileNameElement = container.find('[name="filename"]');
            jQuery(fileNameElement).removeClass('input-error').trigger('Vtiger.Validation.Hide.Messsage');
            var dragDropElement = fileNameElement.closest('table').find('#dragandrophandler');
            var replaceElement = fileNameElement;
			if(thisInstance.isFileLocationInternalType(fileLocationTypeElement)) {
				var newFileNameElement = jQuery(
                    '<div class="fileUploadBtn btn btn-primary">'+
                        '<span><i class="fa fa-laptop"></i>&nbsp;'+
                            app.vtranslate("JS_UPLOAD")+
                        '</span>'+
                        '<input type="file"/>'+
                    '</div>'
                );
                if(dragDropElement.length) dragDropElement.removeClass('hide');
			}else{
				var newFileNameElement = jQuery('<input type="text" data-rule-url="true" data-rule-required="true"/>');
                if(dragDropElement.length) dragDropElement.addClass('hide');
                replaceElement = fileNameElement.closest('.fileUploadBtn');
			}
			var oldElementAttributeList = fileNameElement.get(0).attributes;
			
			for(var index=0; index<oldElementAttributeList.length; index++) {
				var attributeObject = oldElementAttributeList[index];
				//Dont update the type attribute
				if(attributeObject.name=='type' || attributeObject.name == 'value' || attributeObject.name == 'style'){
					continue;
				}
                if(newFileNameElement.hasClass('fileUploadBtn')) {
                    newFileNameElement.find('input[type="file"]').attr(attributeObject.name, attributeObject.value);
                } else {
                    newFileNameElement.attr(attributeObject.name, attributeObject.value);
                }
			}
            
			replaceElement.replaceWith(newFileNameElement);
            
			var fileNameElementTd = newFileNameElement.closest('td');
            if(thisInstance.isFileLocationExternalType(fileLocationTypeElement)){
                fileNameElementTd.prev('td.fieldLabel').empty().append('<label class="">'+app.vtranslate('JS_EXTERNAL_FILE_URL')+'&nbsp;'+'<span class="redColor">*</span></label>');
            } else {
                fileNameElementTd.prev('td.fieldLabel').empty().append('<label class="">'+app.vtranslate('JS_FILE_NAME')+'&nbsp;</label>');
            }
            
			var uploadFileDetails = fileNameElementTd.find('.uploadedFileDetails');
			if(thisInstance.isFileLocationExternalType(fileLocationTypeElement)) {
				uploadFileDetails.addClass('hide').removeClass('show');
			}else{
				uploadFileDetails.addClass('show').removeClass('hide');
			}
		});
        if(container.find('input[name="filelocationtype"]').val() == 'E'){
            jQuery('select[name="filelocationtype"],input[name="filelocationtype"]').trigger('change');
        }
	},	   
	
	//Technokrafts : validation on file type	
	registerTksFileType : function(element){
		var name = element.val();			
			  var fileExtension = ['doc','docx','pdf','xls','xlsx','wp','txt','rtf','bmp','htm','html','gif','png','jpg','jpeg'];
			
			  if ($.inArray(name.split('.').pop().toLowerCase(), fileExtension) == -1) {
				   element.val('');
				   var uploadFileSizeHolder = element.closest('.fileUploadContainer').find('.uploadedFileSize');
				   uploadFileSizeHolder.text('');
				  // Vtiger_Helper_Js.showPnotify(app.vtranslate('Invalid File type!'));
				   app.helper.showErrorNotification({message :app.vtranslate('Invalid File type!')});
				   return false;
			  }
	},
	
	registerFileChangeEvent : function() {
		var thisInstance = this;
		var container	=	this.getForm();
		this.getForm().on('change', 'input[name="filename"]', function(e){
			vtUtils.hideValidationMessage(container.find('input[name="filename"]'));
            if(e.target.type == "text") return false;
            //Documents_Edit_Js.file = e.target.files[0];
            var element = container.find('[name="filename"]');
			//ignore all other types than file 
			if(element.attr('type') != 'file'){
				return ;
			}
			  //Technokrafts starts : validation on file type
			   thisInstance.registerTksFileType(element);
			  //Technokrafts ends : validation on file type
			  
			var uploadFileSizeHolder = element.closest('.fileUploadContainer').find('.uploadedFileSize');
			var fileSize = element.get(0).files[0].size;
			var fileName = e.target.files[0].name;		
			var maxFileSize = thisInstance.getMaxiumFileUploadingSize();
			if(fileSize > maxFileSize) {
				alert(app.vtranslate('JS_EXCEEDS_MAX_UPLOAD_SIZE'));
				element.val('');
				uploadFileSizeHolder.text('');
			}else{
                if(container.length > 1){
                    jQuery('div.fieldsContainer').find('form#I_form').find('input[name="filename"]').css('width','80px');
                    jQuery('div.fieldsContainer').find('form#W_form').find('input[name="filename"]').css('width','80px');
                } else {
                    container.find('input[name="filename"]').css('width','80px');
                }
				uploadFileSizeHolder.text(fileName+' '+thisInstance.convertFileSizeInToDisplayFormat(fileSize));
			}

		});
	},
	
	 registerEventForSendFileType : function(){
		 var thisInstance = this;
		 var form = this.getForm();
		jQuery('select[name="sendfile"]', this.getForm()).on('change', function(e){thisInstance.onready_default('tkssend_file')});
	},
		addHiddenfieldname : function(container) {
		var $hiddenInput = $('<input/>',{type:'hidden',id:'fname',value: $(".uploadedFileName").text(), name : 'fname' });
			$hiddenInput.appendTo($(".uploadedFileDetails"));
	},
	
	addHideClass : function(inputNode, nodeName, clearfield) {
		var tks_nodeJS = inputNode.find(nodeName).closest('span');
		tks_nodeJS.addClass('hide');
		if(clearfield)
		{
			tks_nodeJS.find('.clearReferenceSelection').trigger('click');
		}
	},
	
	removeHideClass : function(inputNode, nodeName) {
		var tks_nodeJS = inputNode.find(nodeName).closest('span');
		tks_nodeJS.removeClass('hide');
	},
	
	hideLbl : function(inputNode) {
		var tksfile=inputNode.find('[name="filename"]');
		var fileHide = tksfile.closest('span').find('.uploadedFileSize').text('');
		tksfile.val('');
	},
	
	onready_default : function($value) {
		
		var form = this.getForm();
		var sendFileType = form.find('[name="sendfile"]');
		var tksfile=form.find('[name="filename"]');
		var tksc=form.find('[name="filelocationtype"]');
		if(sendFileType.val() == '')
		{
			sendFileType.val('Embedded');
			//var field = sendFileType.closest('div');
			//var f1 = field.find('div');
			var closesttd	=	sendFileType.parents('td');					
			var selectContents = closesttd.find('.select2-chosen');
			selectContents.html('Embedded');
			sendFileType.find( 'option[value="Embedded"]' ).prop( "selected", true );	
			//f1.find('a > span').text('Embedded');
			
		}
		
		if(sendFileType.val()=='Manual')
		{
			$(".fileUploadContainer").addClass('show').removeClass('hide');
			$('#filetype').addClass('show').removeClass('hide');
			this.addHideClass(form,'#Docusign_editView_fieldName_tkssales_dropDown',false);
			this.addHideClass(form,'[name="tkssales"]',true);
			this.removeHideClass(form,'[name="filename"]');
			this.removeHideClass(form,'[name="filelocationtype"]');								
		}
		else 
		if(sendFileType.val()=='Embedded'){		
			
			$(".fileUploadContainer").addClass('hide').removeClass('show');
			$('#filetype').addClass('hide').removeClass('show');
			this.removeHideClass(form,'#Docusign_editView_fieldName_tkssales_dropDown');
			this.removeHideClass(form,'[name="tkssales"]');
			this.addHideClass(form,'[name="filename"]',true);
			this.addHideClass(form,'[name="filelocationtype"]',false);
			this.hideLbl(form);
		}


		if($value == 'tksload'){
			$(".fileUploadContainer").append('<div name = "msg" class = "uploadFileSizeLimit redColor">Please Use the below supported file formats :"pdf", "xls", "xlsx", "wp", "txt", "rtf", "bmp", "htm", "html", "gif", "png", "jpg", "jpeg"</div>');
		}
	},
	
	registerReferenceSelectionEvent : function(container) {
		var thisInstance = this;
		jQuery('input[name="tkslinkto"]', container).on(Vtiger_Edit_Js.referenceSelectionEvent, function(e, data1){
			var contanier	=	 thisInstance.getForm().find('[name="tkslinkto"]').closest('td');
			var dropDownContainer	 = contanier.prev('td');
			var dropDown = dropDownContainer.find('.referenceModulesList');
			var module_name = dropDown.find('option:selected').text();
			var id= thisInstance.getForm().find('[id="tkslinkto"]').val()
			
			var aDeferred = jQuery.Deferred();
			
			var url = "module=Docusign&action=GetAutoFills&record="+id;
			
			AppConnector.request(url).then(		
				function(data){
					var data=data['result']['data'];
					//thisInstance.copyemail(data['email'], container);
					//thisInstance.copyemail(data['email2'], container);
					thisInstance.getForm().find('[name="tksemail1"]').val(data['email2']); 
					thisInstance.getForm().find('[name="tksemail"]').val(data['email']); 
					<!--TECHNOKRFTS STARTS-->
					thisInstance.getForm().find('[name="tkssignature"]').val(data['name']); 
					
				},
				function(error){
					aDeferred.reject();
			})
			return aDeferred.promise();
		});
	},
	
	
	/**
	 * Function to fill fields detail autofill details
	 * @params :  id - related to record id
	 */
	getAutoTemplates : function(module) {
		var thisInstance = this;
		var container = this.getForm();
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'message' : app.vtranslate('LBL_FETCH_INFORMATION'),
			'blockInfo' : {
				'enabled' : true
			}
		});

		var params = {};
		params['module'] = app.getModuleName();
		params['parent'] = module;
		params['action'] = 'GetAutoTemplates';
		//params['record'] = id;


		AppConnector.request(params).then(
			function(data) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				var params = {};
				
				if(data['result']['success']) {
					var ModuleFieldsElement =jQuery('[name="tks_pdf_template"]');
           			ModuleFieldsElement.empty();
					
					    var targetPickList = jQuery('[name="tks_pdf_template"]');
							targetPickList.html('');
							//console.log(currentElement);
							jQuery("#tks_pdf_template").html('');
							jQuery('#tks_pdf_template').append($("<option ></option>").attr("value",'').text(''));
							
							
							/*for(var i = 0; i < data['result']['data'].length; i++)
							{
								jQuery('#tks_pdf_template').append($("<option></option>")
									.attr("value",data['result']['data'][i]['templateid']).text(data['result']['data'][i]['filename']));
									
							}*/
							
							if( data['result']['data'].length > 0)
							{
							 	jQuery.each(data['result']['data'], function (i, fields) {
										var optgroup = jQuery('<optgroup/>');
										optgroup.attr('label',i);
										jQuery.each(fields, function (key, field) {
											optgroup.append(jQuery('<option>', { 
												value: key,
												text : app.vtranslate(field) 
												
											}));
										});
										 ModuleFieldsElement.append(optgroup);
										 ModuleFieldsElement.select2("destroy");
										 ModuleFieldsElement.select2();
										// container.find('select[name="tks_pdf_template"]').find( 'option[value="' +key+ '"]' ).prop( "selected", true );	
               					 });   
								// jQuery('#tks_pdf_template').val(key);
							}
							var listOfAvailableOptions = targetPickList.data('availableOptions');
							//alert(listOfAvailableOptions);
							if(typeof listOfAvailableOptions == "undefined"){
								listOfAvailableOptions  = jQuery('option',targetPickList);
						
								targetPickList.data('availableoptions', listOfAvailableOptions);
							
							}
														
							var targetOptions = new jQuery();
							var optionSelector = [];
							optionSelector.push('');
							var targetPickListMap =data['result']['data'];
							for(var i=0; i<targetPickListMap.length; i++){
								optionSelector.push(targetPickListMap[i]['templateid']);
							}
							
							
							var targetPickListSelectedValue = '';
							var targetPickListSelectedValue = targetOptions.filter('[selected]').val();
							targetPickList.html(listOfAvailableOptions).val(targetPickListSelectedValue).trigger("liszt:updated");
							
					
				} else {
					params['text'] = app.vtranslate('JS_SOMETHING_WENT_WRONG');
					params['type'] = 'error';
				}
				//Settings_Vtiger_Index_Js.showMessage(params);
			//	location.reload();
			},
			function(error) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
			}
		);
	},
	
	registerEmailClearEvent : function(container) {
		
		var thisInstance = this;
		var form = this.getForm();
		var container = this.getForm();
		var thisInstance = this;
		
		container.on('change', 'select[name="tkslinkto"],input[name="tkslinkto"]', function(e){
		//jQuery('select[id="Docusign_editView_fieldName_tkslinkto_dropDown"]', this.getForm()).on('change', function(e){	
			form.find('[name="tksemail"]').val('');
			form.find('[name="tksemail1"]').val('');
			form.find('[name="tkssignature"]').val('');
			
		});
		
		container.on('change', 'select[name="tkssales"],input[name="tkssales"]', function(e){																								
			form.find('[name="tksemail"]').val('');
			form.find('[name="tksemail1"]').val('');
			form.find('[name="tkslinkto_display"]').val('');
			form.find('[name="tkslinkto"]').val('');
			form.find('[name="tkssignature"]').val('');
			thisInstance.getAutoTemplates(document.getElementById("Docusign_editView_fieldName_tkssales_dropDown").value);
		});
		
		jQuery('#Docusign_editView_fieldName_tkssales_clear').click(function(e) {
			form.find('[name="tksemail"]').val('');
			form.find('[name="tksemail1"]').val('');
			form.find('[name="tkslinkto_display"]').val('');
			form.find('[name="tkslinkto"]').val('');
			form.find('[name="tkssignature"]').val('');
		});

		jQuery('#Docusign_editView_fieldName_tkslinkto_clear').click(function(e) {
			form.find('[name="tksemail"]').val('');
			form.find('[name="tksemail1"]').val('');
			form.find('[name="tkssignature"]').val('');
			<!--TECHNOKRFTS ENDS-->
		});
	},
	
	/**
	 * Function to register event for ckeditor for description field
	 */
	registerEventForCkEditor : function(container){
		var form = this.getForm();
        if(typeof container != 'undefined'){
            form = container;
        }
		var noteContentElement = form.find('[name="notecontent"]');
		if(noteContentElement.length > 0){
			noteContentElement.removeAttr('data-validation-engine').addClass('ckEditorSource');
			var ckEditorInstance = new Vtiger_CkEditor_Js();
			ckEditorInstance.loadCkEditor(noteContentElement);
		}
	},
	
	/**
	 * Function override Vtiger_Edit_Js function :- setReferenceFieldValue
	 * @params :  container - jQuery object
	 *			  params - paramters
	 */
	setReferenceFieldValue : function(container, params) {
		this._super(container, params);
		var thisInstance = this;
		
		if(container.find('.autoComplete').attr('name') == 'tkssales_display' )
		{
			//alert('sdfdfsdf');
			//thisInstance.getAutoTemplates(params.id);
			var message = app.vtranslate('LBL_CONFIRM_FILL_DETAILS');
			app.helper.showConfirmationBox({'message' : message}).then(
				function(e) {
					thisInstance.getAutoFillDetails(params.id);
				},
				function(error, err){
				}
			);
		}
		
		var currInvField = container.find('.autoComplete').attr('name');
		
	},
	
	registerAutoCopyEvent : function() {
		var tkssalesid = this.getForm().find('[id="tkssales"]').val();
		var tkslinktoid = this.getForm().find('[id="tkslinkto"]').val();
		var record = this.getForm().find('[name="record"]').val();
		
		var duplicate = jQuery('#duplicate').val();
		
		if(tkssalesid != '' && record == '' && duplicate == 'false')
		{	 
			this.getAutoFillDetails(tkssalesid);	
		}
		if(tkslinktoid != '' && record == '' && duplicate == 'false')
		{	 
			this.getAutoFillDetails(tkslinktoid);	
		}
	},
	
	/**
	 * Function to fill fields detail autofill details
	 * @params :  id - related to record id
	 */
	getAutoFillDetails : function(id) {
		var thisInstance = this;
		var progressIndicatorElement = jQuery.progressIndicator({
			'position' : 'html',
			'message' : app.vtranslate('LBL_FETCH_INFORMATION'),
			'blockInfo' : {
				'enabled' : true
			}
		});

		var params = {};
		params['module'] = app.getModuleName();
		params['parent'] = app.getParentModuleName();
		params['action'] = 'GetAutoFills';
		params['record'] = id;

		AppConnector.request(params).then(
			function(data) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				var params = {};
				if(data['result']['success']) {
					
					var contanier = thisInstance.getForm().find('[name="linkto"]').closest('td');

					var dropDownContainer = contanier.prev('td');
					var dropDown = dropDownContainer.find('.referenceModulesList');
					var selectedValue = dropDown.find('option:selected').text();
					data=data['result']['data'];
					
						if(selectedValue != data['module'])
						{
							var container = thisInstance.getForm();
							var modulename = data['module'];
							container.find('#Docusign_editView_fieldName_tkslinkto_dropDown').val(modulename);
							//jQuery('input[name="tkssales"]',container).val('');	
							var closesttd	=	container.find('#Docusign_editView_fieldName_tkslinkto_dropDown').parents('td');					
							var selectContents = closesttd.find('.select2-chosen');
							selectContents.html(app.vtranslate(modulename));
							container.find('#Docusign_editView_fieldName_tkslinkto_dropDown').find( 'option[value="' +app.vtranslate(modulename)+ '"]' ).prop( "selected", true );	
							contanier.find('[name="tkslinkto_display"]').val(data['name']);
							contanier.find('[name="tkslinkto"]').val(data['id']);
							jQuery('input[name="tkslinkto"]', container).val(data['id']);
							jQuery('input[name="tkslinkto_display"]', container).val(data['name']);
							jQuery('input[name="tkssignature"]', container).val(data['name']);
							
						}
						//thisInstance.setReferenceFieldValue(contanier,data,true);
						
					thisInstance.getForm().find('[name="tksemail"]').val(data['email']); 
					thisInstance.getForm().find('[name="tksemail1"]').val(data['email2']);
					
					
					params['message'] = app.vtranslate('JS_RECORDS_INFORMATION_AUTOFILLED');
					//params['type'] = 'success';
					app.helper.showSuccessNotification(params);

				} else {
					params['message'] = app.vtranslate('JS_SOMETHING_WENT_WRONG');
					//params['type'] = 'error';
					app.helper.showErrorNotification(params);
				}
				//Vtiger_Helper_Js.showMessage(params);
				//app.helper.showErrorNotification(params);
				
			},
			function(error) {
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
			}
		);
	},
	
	
	/*
    Function: getUrlParameters
    Description: Get the value of URL parameters either from 
                 current URL or static URL
    Author: Tirumal
    URL: www.code-tricks.com
   */
	
	getUrlParameters: function(parameter, staticURL, decode){
   
   		var currLocation = (staticURL.length)? staticURL : window.location.search,
        parArr = currLocation.split("?")[1].split("&"),
        returnBool = true;
   
  	 	for(var i = 0; i < parArr.length; i++){
        parr = parArr[i].split("=");
        if(parr[0] == parameter){
            return (decode) ? decodeURIComponent(parr[1]) : parr[1];
            returnBool = true;
        }else{
            returnBool = false;            
        }
   	}
   
   if(!returnBool) return false;  
},

			   
		registerEvents : function(container) {
		this._super();
		this.registerFileLocationTypeChangeEvent();
		this.registerFileChangeEvent();
		this.registerEventForCkEditor();
		this.registerEventForSendFileType(container);
		this.onready_default('tksload');
		this.registerReferenceSelectionEvent(container);
		this.registerEmailClearEvent(container);
		this.registerAutoCopyEvent();
		
		
		/*	TECHNOKRFTS START*/
		var url = document.URL;
		var record = this.getUrlParameters("record", url, true);
		if(record =='')
		{
				
			var salemodule = jQuery('#Docusign_editView_fieldName_tkssales_dropDown').val();
			this.getAutoTemplates(salemodule);
		}
	
		/*	TECHNOKRFTS END*/
	}
});