/*
 *
 *
 */
jQuery.Class('ReadOnlyFields_Js', {
}, {

  registerEvents: function(e) {

    // when initial loaded
    this.setReadOnly();
    this.setRelatedSummaryTabReadOnly();

    // when navigate from one to another relatedTab
    this.relatedTabClick();
    this.postOverlayLoad();
    this.postOverlayEdit();
    this.postSummaryWidgetLoad();
  },

  postSummaryWidgetLoad : function() {

    var thisInstance = this;

    app.event.on('post.summarywidget.load',function(event) {

      thisInstance.setRelatedSummaryTabReadOnly();
    });
  },

  postOverlayEdit : function() {

    var thisInstance = this;

    app.event.on('post.overLayEditView.loaded',function(event) {

      thisInstance.setReadOnly();
    });
  },

  postOverlayLoad : function() {

    var thisInstance = this;

    app.event.on('post.overlay.load',function(event) {

      thisInstance.setReadOnly();
    });
  },

  relatedTabClick : function() {

    var thisInstance = this;

    app.event.on("post.relatedListLoad.click",function(event) {

      thisInstance.setReadOnly();
    });
  },

  setRelatedSummaryTabReadOnly : function() {

    // test for existance
    if (typeof uimeta == "undefined") return;

    var fieldInfo = uimeta.field.get('vwfsystem');

    if (fieldInfo != undefined) {
      var target = jQuery("label[title='" + fieldInfo.label + "']");
      var container = target.closest('td').next().find('.row');
      container.find('.action').remove();
      container.css('background-color', '#dedede');
      container.css('border-style', 'solid')
      container.css('border-width', '3px');
      container.css('border-color', 'white');
    }

    if (fieldInfo != undefined) {

      var fieldInfo = uimeta.field.get('vwfrequest');
      var target = jQuery("label[title='" + fieldInfo.label + "']");
      var container = target.closest('td').next().find('.row');
      container.find('.action').remove();
      container.css('background-color', '#dedede');
      container.css('border-style', 'solid')
      container.css('border-width', '3px');
      container.css('border-color', 'white');
    }
  },

  setReadOnly : function() {

    var container = jQuery('#EditView');
    container.find('[name="vwfrequest"]').parent('td').css('pointer-events', 'none');
    container.find('[name="vwfrequest"]').css('background-color', '#dedede');

    container.find('[name="vwfsystem"]').parent('td').css('pointer-events', 'none');
    container.find('[name="vwfsystem"]').css('background-color', '#dedede');

    jQuery('#VebWebforms_detailView_fieldValue_vwfrequest a').remove();
    jQuery('#VebWebforms_detailView_fieldValue_vwfrequest').css('background-color', '#dedede');
    jQuery('#VebWebforms_detailView_fieldValue_vwfrequest').css('border-style', 'solid')
    jQuery('#VebWebforms_detailView_fieldValue_vwfrequest').css('border-width', '3px');
    jQuery('#VebWebforms_detailView_fieldValue_vwfrequest').css('border-color', 'white');

    jQuery('#VebWebforms_detailView_fieldValue_vwfsystem a').remove();
    jQuery('#VebWebforms_detailView_fieldValue_vwfsystem').css('background-color', '#dedede');
    jQuery('#VebWebforms_detailView_fieldValue_vwfsystem').css('border-style', 'solid')
    jQuery('#VebWebforms_detailView_fieldValue_vwfsystem').css('border-width', '3px');
    jQuery('#VebWebforms_detailView_fieldValue_vwfsystem').css('border-color', 'white');
  }
});

jQuery(document).ready(function () {

  var instance = new ReadOnlyFields_Js;
  instance.registerEvents();
});
