/**
 * VGS Summary Widgets Module
 *
 *
 * @package        VGSSummaryWidgets Module
 * @author         www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

jQuery.Class("VGSWidgetsSetting_Js", {}, {
    loadWidgetListForModule: function () {
        var thisInstance = this;
        jQuery('#module1').on('change', function (e) {
            var selectedModule = jQuery(this).val();
            if(selectedModule == '--' || selectedModule == ''){
                return false;
            }
            
            var params = {
                'module': 'VGSSummaryWidgets',
                'view': 'VGSWidgetList',
                'selected_module': selectedModule,
            }
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    
                    jQuery('#module-widgets').html(res);
                    jQuery("#leftColumn,#rightColumn").sortable({
                        connectWith: ".sortableColumn",
                        stop: function( event, ui ) {
                            thisInstance.updateWidgetsSideAndOrder();
                        }
                      });
                }else{
                    app.helper.showAlertNotification({
                        'message' : app.vtranslate('Error Loading Module Custom Widgets')
                    });
                }
            });

        });
    },
    updateWidgetsSideAndOrder: function(){
        var arr = {'leftwidgets':[],'rightwidgets':[]};
        var leftElements = jQuery('#leftColumn').children();
        leftElements.each(function(index){
            arr['leftwidgets'][index+1] = this.id;
        });
        var rightElements = jQuery('#rightColumn').children();
        rightElements.each(function(index){
            arr['rightwidgets'][index+1] = this.id;
        });
        if(arr['leftwidgets'].length || arr['rightwidgets'].length){
            var params = {
                'module': 'VGSSummaryWidgets',
                'action': 'WidgetActions',
                'mode': 'updateWidgetsSideAndOrder',
                'array': arr
            };
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    app.helper.showSuccessNotification({
                        'message' : app.vtranslate('Widgets Position Updated')
                    });
                    jQuery('#module1').trigger('change');
                }else{
                    app.helper.showAlertNotification({
                        'message' : app.vtranslate('Error Updating Widgets')
                    });
                }
            });
        }
    },
    loadAddWidget: function(){
        var thisInstance = this;
        jQuery(document).on('click','#vgs-add-widget,.edit-widget', function (e) {

            var params = {
                'module': 'VGSSummaryWidgets',
                'view': 'VGSWidgetsModal',
                'selected_module': jQuery('#module1').val(),
                
            }

            if(jQuery(this).hasClass('edit-widget')){
                params.widget_id = jQuery(this).data('widget_id');
            }
            
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    app.helper.showModal(res, {
                        'cb' : function(modalContainer) {
                            thisInstance.registerEditModalEvents(modalContainer);
                        }
                    });
                }
            });
        });
    },
    deleteWidget: function(){
        thisInstance = this;
        jQuery(document).on('click', '.delete-widget', function (e) {

            var params = {
                'module': 'VGSSummaryWidgets',
                'action': 'WidgetActions',
                'mode': 'deleteWidget',
                'selected_module': jQuery('#module1').val(),
                'widget_id': jQuery(this).data('widget_id'),
            }
            var widgetDiv = jQuery(this).parent('.widget');
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    app.helper.showSuccessNotification({
                        'message' : app.vtranslate('Widget Succesfully Deleted')
                    });
                    jQuery('#module1').trigger('change');
                }else{
                    app.helper.showAlertNotification({
                        'message' : app.vtranslate('Error Deleting Widget')
                    });
                }
            });
        });
    },
    registerEvents: function () {
        this.loadWidgetListForModule();
        this.loadAddWidget();
        this.deleteWidget();
    },
    enableSelect2: function(modalContainer){
        app.showSelect2ElementView(modalContainer.find('select'));
    },
    loadModulesColumns:function(modalContainer){
        thisInstance = this;
        modalContainer.find('#related_module').on('change', function (e) {
            var params = {
                'module': 'VGSSummaryWidgets',
                'action': 'WidgetActions',
                'mode': 'loadModulesColumns',
                'for_module': modalContainer.find('#related_module').val(),
            }
            
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                if(!e && res) {
                    modalContainer.find('#columns').html(res.columns);
                    modalContainer.find('#picklistfields').html(res.picklists);                    
                    app.showSelect2ElementView(modalContainer.find('#columns'));
                    app.showSelect2ElementView(modalContainer.find('#picklistfields'));
                    app.helper.hideProgress();
                    
                }else{
                    app.helper.hideProgress();
                    app.helper.showErrorNotification({
                        'message' : app.vtranslate('Error Loading Related Module Information')
                    });
                }
            });
        });
    },
    saveWidget: function(modalContainer) {
        thisInstance = this;
        modalContainer.find('#addWidgetModal').on('submit', function(e) {
            e.preventDefault();
            var formData = jQuery(this).serializeFormData();
            app.helper.showProgress();
            app.request.post({'data':formData}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e) {
                    app.helper.hideModal();
                    app.helper.showSuccessNotification({
                        'message' : app.vtranslate('Widget Succesfully Added')
                    });
                    jQuery('#module1').trigger('change');
                } else {
                    app.helper.hideModal();
                    app.helper.showAlertNotification({
                        'message' : app.vtranslate('Error Saving Widget Entry')
                    });
                }
            });
        });    
    },
    registerEditModalEvents: function(modalContainer){
        this.enableSelect2(modalContainer);
        this.loadModulesColumns(modalContainer);
        this.saveWidget(modalContainer);

    }

});

jQuery(document).ready(function () {
    var instance = new VGSWidgetsSetting_Js();
    instance.registerEvents();
    var instanceIndexSettings = new Settings_Vtiger_Index_Js();
	instanceIndexSettings.registerEvents();
});
