/**
 * VGS Summary Widgets Module
 *
 *
 * @package        VGSSummaryWidgets Module
 * @author         VGS Global - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

jQuery.Class("VGSSummaryWidgets_Js", {
    mandatoryFieldsCache: [],
}, {

    loadSummaryWidgets: function(){
            vgsWidgetsInstance = this;
            var params = {
                'module': 'VGSSummaryWidgets',
                'view': 'loadWidgets',
                'selected_module':  app.getModuleName(),
                'record': app.getRecordId()
            }
            
            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    if(res.leftwidgets != undefined){
                        jQuery.each( res.leftwidgets, function( index, value ){
                            jQuery('.left-block').append(value);
                        });
                    }
                    
                    if(res.rightwidgets != undefined){
                        
                        jQuery.each( res.rightwidgets, function( index, value ){
                            jQuery('.middle-block').append(value);
                        });

                    }
                    vgsWidgetsInstance.refreshWidgetContents();
                    jQuery('.summaryWidgetContainer').find('.filterby').select2();
                    
                }else{
                    
                }
            });
        
    },
    refreshWidgetContents: function(){
        jQuery(document).on('change', '.filterby', function(){
            var widget_id = jQuery(this).data('widgetid');
            var params = {
                'module': 'VGSSummaryWidgets',
                'view': 'reloadWidgets',
                'widget_id':  jQuery(this).data('widgetid'),
                'filter_field':  jQuery(this).data('fieldname'),
                'filter_value':  jQuery(this).val(),
                'widget_id':  jQuery(this).data('widgetid'),
                'record': app.getRecordId()
            }

            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    jQuery('*[data-widgetcontainer="' + widget_id + '"]').html(res).find('.select2').select2();
                }else{
                    //@TODO Show error
                }
            });

        });
    },
    reloadWidget: function(summaryWidgetContainer){
            var aDeferred = jQuery.Deferred();
            var widget_id = summaryWidgetContainer.data('widgetcontainer');
            var params = {
                'module': 'VGSSummaryWidgets',
                'view': 'reloadWidgets',
                'widget_id':  widget_id,
                'filter_field':  summaryWidgetContainer.find('[data-widgetid="'+widget_id+'"]').data('fieldname'),
                'filter_value':  summaryWidgetContainer.find('[data-widgetid="'+widget_id+'"]').val(),
                'record': app.getRecordId()
            }

            app.helper.showProgress();
            app.request.get({data: params}).then(function(e,res) {
                app.helper.hideProgress();
                if(!e && res) {
                    jQuery('*[data-widgetcontainer="' + widget_id + '"]').html(res).find('.select2').select2();
                    aDeferred.resolve(params);
                }else{
                    //@TODO Show error
                }
            });
        
        return aDeferred.promise();

    }
    
});

jQuery(document).ready(function () {
    var instance = new VGSSummaryWidgets_Js();
    if (app.getViewName() === 'Detail' && jQuery('.summaryView').length) {
        instance.loadSummaryWidgets();
    }

    app.event.on('post.relatedListLoad.click',function(){
        if (app.getViewName() === 'Detail' && jQuery('.summaryView').length) {
            instance.loadSummaryWidgets();
        }
    });
    
});

jQuery('.detailViewContainer').on('click','[name="addButtonVGS"]',function(e){
    var instance = Vtiger_Detail_Js.getInstance();
        var recordId = jQuery('#recordId').val();
        var parentModule = app.getModuleName();
        var summaryWidgetContainer = jQuery(e.currentTarget).closest('.summaryWidgetContainer');
        var fieldName = summaryWidgetContainer.find('[name="relatedFieldName"]').val();
        var referenceModuleName = summaryWidgetContainer.find('[name="relatedModule"]').val();
        var quickCreateNode = jQuery('#quickCreateModules').find('[data-name="'+ referenceModuleName +'"]');

        var customParams = {};
        customParams[fieldName] = recordId;

        app.event.one('post.QuickCreateForm.show',function(event,data){
            var index,queryParam,queryParamComponents;

            jQuery('<input type="hidden" name="sourceModule" value="'+parentModule+'" />').appendTo(data);
            jQuery('<input type="hidden" name="sourceRecord" value="'+recordId+'" />').appendTo(data);
            jQuery('<input type="hidden" name="relationOperation" value="true" />').appendTo(data);

            if(typeof fieldName != "undefined"){
                var field = data.find('[name="'+fieldName+'"]');
                //If their is no element with the relatedField name,we are adding hidden element with
                //name as relatedField name,for saving of record with relation to parent record
                if(field.length == 0){
                    jQuery('<input type="hidden" name="'+fieldName+'" value="'+recordId+'" />').appendTo(data);
                }
            }
            if(typeof callback !== 'undefined') {
                callback();
            }
        });

        if(quickCreateNode.length <= 0) {
            window.location.href = jQuery(e.currentTarget).data('url')+'&sourceModule='+parentModule+'&sourceRecord='+recordId+'&relationOperation=true&'+fieldName+'='+recordId;
            return;
        }

        var preQuickCreateSave = function(data){
            var detailInstance = Vtiger_Detail_Js.getInstance();
            detailInstance.addElementsToQuickCreateForCreatingRelation(data,parentModule,recordId);
            jQuery('<input type="hidden" name="'+fieldName+'" value="'+recordId+'" >').appendTo(data);
        };
        var callbackFunction = function() {
            var classInstance = new VGSSummaryWidgets_Js();
            classInstance.reloadWidget(summaryWidgetContainer)
        };
        var QuickCreateParams = {};
        QuickCreateParams['callbackPostShown'] = preQuickCreateSave;
        QuickCreateParams['callbackFunction'] = callbackFunction;
        QuickCreateParams['data'] = customParams;
        QuickCreateParams['noCache'] = false;

        quickCreateNode.trigger('click', QuickCreateParams);
});
