function split(val) {
  return val.split(/,\s*/);
}

function extractLast(term) {
  return split(term).pop();
}


jQuery.Class("VGSEventInvites", {}, {
  loadInitialEmails: function (e) {
    $.ajax({
      type: "POST", cache: false, async: false, dataType: 'json', data: { module: "VGSEventsInvites", action: "LoadEmails" },
      url: "index.php", success: function (datos, texto, jqXHR) {
        availableTags = datos.result.emails;
        if (jQuery('[name="events_timezone"]').select2('val') == '') {
          jQuery('[name="events_timezone"]').select2('val', datos.result.timezone)
        } else {
          jQuery('[name="events_timezone"]').select2('val', jQuery('[name="events_timezone"]').select2('val'));
        }
      }
    });
  },
  registerAutocomplete: function () {
    $("[name='eventsinvites']")
      .on("keydown", function (event) {
        if (event.keyCode === $.ui.keyCode.TAB &&
          $(this).autocomplete("instance").menu.active) {
          event.preventDefault();
        }
      })
      .autocomplete({
        minLength: 3,//ESTE VALOR SETEA LONGITUD MINIMA PARA QUE SE MUESTRE EL AUTOCOMPLETAR
        source: function (request, response) {
          // delegate back to autocomplete, but extract the last term
          response($.ui.autocomplete.filter(
            availableTags, extractLast(request.term)));
        },
        focus: function () {
          // prevent value inserted on focus
          return false;
        },
        select: function (event, ui) {
          var terms = split(this.value);
          // remove the current input
          terms.pop();
          // add the selected item
          terms.push(ui.item.value);
          // add placeholder to get the comma-and-space at the end
          terms.push("");
          this.value = terms.join(", ");
          return false;
        }
      });
  },
  registerEvents: function () {
    var e = this;
    e.loadInitialEmails();
    e.registerAutocomplete();
  }
});



jQuery(document).ready(function () {

  if (_META.module == 'Calendar') {
    var e = new VGSEventInvites;
    e.registerEvents();
  }

  if (_META.module == 'Relations') return;

  app.event.on('post.QuickCreateForm.show', function (form) {
    var e = new VGSEventInvites;
    e.registerEvents();
  });
});
