jQuery.Class("VGSCommentsMentions_Js", {}, {
    ready: function() {
        var thisInstance = this;
        var params = {
            module: 'VGSCommentsMentions',
            action: 'Ajax',
            mode: 'loadUserNames'
        };
        AppConnector.request(params).then(
                function (data) {
                    if (data.success) {
                        availableTags = data.result;
                        thisInstance.registerEvent(availableTags);
                    }
                },
                function (error, err) {
                    console.log('error' + err);
                }
        );
    },
    registerEvent: function(availableTags){
        $( "[name='commentcontent']" )
      .on( "keydown", function( event ) {
        if ( event.keyCode === $.ui.keyCode.TAB &&
            $( this ).autocomplete( "instance" ).menu.active) {
          event.preventDefault();
        }
      })
      .autocomplete({
        minLength: 1,//ESTE VALOR SETEA LONGITUD MINIMA PARA QUE SE MUESTRE EL AUTOCOMPLETAR
        source: function( request, response ) {
          // delegate back to autocomplete, but extract the last term
          response( $.ui.autocomplete.filter(
            availableTags, extractLast( request.term ) ) );
        },
        focus: function() {
          // prevent value inserted on focus
          return false;
        },
        select: function( event, ui ) {
          var terms = this.value.split(" ");
          // remove the current input
          terms.pop();
          // add the selected item
          terms.push( ui.item.value );
          // add placeholder to get the comma-and-space at the end
          terms.push( "" );
          this.value = terms.join( " " );
          return false;
        }
      });
    },
    isReady:function(){
        var thisInstance = this;
        setTimeout(function () {
            if($( "[name='commentcontent']" ).length){
                thisInstance.ready();
            }else{
                thisInstance.isReady();
            }
        }, 100);
    }
});

jQuery(document).ready(function() {
    var instance = new VGSCommentsMentions_Js;
    app.event.on('post.summarywidget.load', function () {
        instance.isReady();
    });
  //added t41619
    app.event.on('post.relatedListLoad.click', function () {
        instance.isReady();
    });
  //
});
function split( val ) {
  return val.split( /\s*@\s*/ );
}

function extractLast( term ) {
  return split( term ).pop();
}