/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger.Class("Settings_VebSettings_Js",{},{
    
    init : function() {
       // this.addComponents();
    },
   
    addComponents : function (){
        // this.addModuleSpecificComponent('Index',app.module(), app.getParentModuleName());
    },

    /*
     * function to Save the Details
     */
    saveVebSettingsDetails : function(form) {

        var thisInstance = this;
        var aDeferred = jQuery.Deferred();
        var data = form.serializeFormData();
        var params = {
              'module' : app.getModuleName(),
              'parent' : app.getParentModuleName(),
              'action': 'SaveAjax'
            };

       jQuery.extend(params, data);

       app.request.post({'data' : params}).then(

         function(err, data) {

           app.helper.showProgress();

           if (err === null){

             var VebSettingsDetailUrl = form.data('detailUrl');
             thisInstance.loadContents(VebSettingsDetailUrl).then(
               function(data) {
                 jQuery('.settingsPageDiv').html(data);
                 thisInstance.registerDetailViewEvents();
                 app.helper.hideProgress();
               }
             );
             aDeferred.resolve(data);
           }
           else {

             app.helper.hideProgress();
             jQuery('.errorMessage', form).removeClass('hide');
             aDeferred.reject();
           }
         }
       );
       return aDeferred.promise();
    },
    
    loadContents : function(url) {

      var aDeferred = jQuery.Deferred();
      app.request.pjax({"url" : url}).then(
        function(err, data){
          if(err === null){
            jQuery('.settingsPageDiv ').html(data);
            aDeferred.resolve(data);
          }
        },
        function(error, err){
          aDeferred.reject();
        }
      );
      return aDeferred.promise();
    },
    
    /*
     * function to register the events in editView
     */
    registerEditViewEvents : function(e) {

      var thisInstance = this;
      var form = jQuery('#VebSettingsForm');
      var resetButton = jQuery('.resetButton', form);
      var cancelLink = jQuery('.cancelLink', form);
        
      //register validation engine
      var params = {
        submitHandler : function(form) {
          app.helper.showProgress();
          var form = jQuery(form);
          thisInstance.saveVebSettingsDetails(form);
        }
      };

      if (form.length) {

        form.vtValidate(params);
        form.on('submit', function(e) {

          e.preventDefault();
          return false;
        });
      };
        
      //register click event for cancelLink
      cancelLink.click(function(e) {

        var VebSettingsDetailUrl = form.data('detailUrl');
        thisInstance.loadContents(VebSettingsDetailUrl).then(
          function(data) {
            jQuery('.editViewPageDiv').html(data);
            //after loading contents, register the events
            thisInstance.registerDetailViewEvents();
          }
        );
      });
    },
    
    /*
     * function to register the events in IndexView
     */
    registerIndexViewEvents : function() {

      var thisInstance = this;
      //Detail view container
      var container = jQuery('#VebSettingsIndex');
      var selectBox = jQuery('#supportedModules', container);

      selectBox.change(function(e) {

        app.helper.showProgress();

        var url = selectBox.data('url');
        var id = jQuery('#supportedModules').val();
        url = url + '&id=' + id;
        thisInstance.loadContents(url).then(

          function(data) {

            jQuery('.settingsPageDiv ').html(data);
            app.helper.hideProgress();

            //after load the contents register the edit view events
            thisInstance.registerEditViewEvents();
           }
        );
      });
    },

    /*
     * function to register the events in DetailView
     */
    registerDetailViewEvents : function() {

      var thisInstance = this;

      //Detail view container
      var container = jQuery('#VebSettingsDetails');
      var editButton = jQuery('.editButton', container);

      //register click event for edit button
      editButton.click(function(e) {

        app.helper.showProgress();

        var url = editButton.data('url');
        var id = jQuery('#supportedModules').val();
        url = url + '&id=' + id;
        thisInstance.loadContents(url).then(

          function(data) {

            jQuery('.settingsPageDiv ').html(data);
            app.helper.hideProgress();

            //after load the contents register the edit view events
            thisInstance.registerEditViewEvents();
          }
        );
      });
    },
    
    registerEvents: function() {

      var thisInstance = this;

      // the index view events
      thisInstance.registerIndexViewEvents();

      // the edit view events
      thisInstance.registerEditViewEvents();

      // the default view events
      thisInstance.registerDetailViewEvents();
    },


    triggerEvent: jQuery('.click').on("click", function() {

      var container = jQuery('form#VebSettingsForm');
      var obj = jQuery(this);

      var element = obj.closest('tr').attr('id');

      var actOnValue = container.find('tr#' + element).data('acton');
      var reference = container.find('tr#' + element).data('dependent');
      var action = container.find('tr#' + element).data('event');

      var selectedOptionValue = obj.find(":selected").val();
      if (selectedOptionValue == undefined) selectedOptionValue = container.find('tr#' + element).data('value');

if (reference == 'company_signature') {
  console.log('reference:' + reference);
  console.log('action:' + action);
  console.log('acton:' + actOnValue);
  console.log('selected:' + selectedOptionValue);
  console.log(container);
}
      if (action == 'show') {

        if (actOnValue == selectedOptionValue) {
console.log('show');
          jQuery(container).find('tr#' + reference).removeClass('hide');
        }
        else {
console.log('hide');
          jQuery(container).find('tr#' + reference).addClass('hide');
        }
      }
    }
  )
});

Settings_VebSettings_Js("Settings_VebSettings_Index_Js",{},{});
Settings_VebSettings_Js("Settings_VebSettings_Edit_Js",{},{});
Settings_VebSettings_Js("Settings_VebSettings_Detail_Js",{},{});

jQuery('form#VebSettingsForm').ready(function() {

  jQuery('.click').each(function(i, obj) {
console.log('ja'); 
      // simulate click event on pageload
      obj.click();
  });
});

jQuery(document).ready(function () {
  jQuery('.click').each(function(i, obj) {
console.log(1); 
      // simulate click event on pageload
      obj.click();
  });
});
