{*+**********************************************************************************
* The contents of this file are subject to the vtiger CRM Public License Version 1.1
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
************************************************************************************}
{* modules/Settings/Vtiger/views/VebSettingsEdit.php *}

{strip}
  <script type="text/javascript" src="layouts/v7/lib/jquery/select2/select2.min.js"></script>
  {assign var="MODULE_TRANSLATION" value="Settings:{$RECORD_MODEL->get('module')}"}
  <div class="editViewPageDiv editViewContainer" id="EditViewVebSettings" style="padding-top:0px;">
    <div class="col-lg-12 col-md-12 col-sm-12">
       <h3 style="margin-top: 0px;">{vtranslate($RECORD_MODEL->get('module'), $MODULE_TRANSLATION)}</h3>
      </div>
      {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
      <form id="VebSettingsForm" data-detail-url="{$RECORD_MODEL->getDetailViewUrl()}" method="POST">
        <input type="hidden" name="id" value="{$RECORD_MODEL->get('id')}"/>
        <input type="hidden" name="settingsfor" value="{$RECORD_MODEL->get('module')}"/>
        <div class="blockData">
          <div class="block">
            <div>
              <h4>{vtranslate($RECORD_MODEL->get('description'), $MODULE_TRANSLATION)}</h4>
            </div>
            <hr>
            <table class="table editview-table no-border">
              <tbody>
               {assign var=MODULE_DATA value=$MODULE_MODEL->get('data')}
               {foreach from=$MODULE_DATA item=DATA}
<jho jho="{$DATA.hidden}" />
                 <tr id="{$DATA.field}"
                     {if $DATA.hidden} class="hide"{/if}
                     {if $DATA.acton} data-acton="{$DATA.acton}"{/if}
                     {if $DATA.action} data-event="{$DATA.action}"{/if}
                     {if $DATA.dependent} data-dependent="{$DATA.dependent}"{/if}>
                  <td class="{$WIDTHTYPE} fieldLabel">
                   <div class="row from-group">
                    <div class="col-sm-6 col-xs-6">
                     <div class="row">
                      <div class="col-lg-6 col-md-6 col-sm-12">
                        {if $DATA.type == 'separator'}<span style="font-weight: bold">{/if}
                        {vtranslate($DATA.label, $MODULE_TRANSLATION)}
                        {if $DATA.required == 'true'}&nbsp;<span class="redColor">*</span>{/if}
                        {if $DATA.type == 'separator'}</span>{/if}
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-12 fieldValue">
                        {if $DATA.type == 'picklist'}
                           <select name="{$DATA.field}" style="min-width: 250px"
                                   class="click select2 inputElement col-md-12 col-lg-12"
                                   data-rule-required="{$DATA.required}">
                             <option value="">{vtranslate($DATA.placeholder, $DATA.module)}</option>
                             {foreach from=$DATA.data item=VALUE}
                               <option value="{$VALUE.id}"
                                 {if $VALUE.id eq $DATA.value} selected="selected"{/if}>
                                 {vtranslate($VALUE.name, $DATA.module)}
                               </option>
                             {/foreach}
                           </select>
                        {elseif $DATA.type == 'multiselect'}
                           <select multiple id="Leads_Edit_fieldName_{$DATA.field}"
                                   class="select2-container select2-container-multi select2 click"
                                   name="{$DATA.field}[]"
                                   data-fieldtype="multipicklist"
                                   style="min-width:250px;height:30px;"
                                   data-rule-required="{$DATA.required}">
                             {foreach item=VALUE key=PICKLIST_NAME from=$DATA.data}
                               {assign var="OPTION" value="{$VALUE.id}${$VALUE.name}"}
                               <option value="{$OPTION}"
                                       {if in_array($OPTION, $DATA.value)} selected{/if}>
                                 {vtranslate($VALUE.name, $DATA.module)}
                               </option>
                             {/foreach}
                           </select>
                        {elseif $DATA.type == 'text'}
                          <input type="text"
                                 class="click inputElement"
                                 name="{$DATA.field}"
                                 data-rule-required="{$DATA.required}"
                                 data-placeholder="{$DATA.placeholder}"
                                 value="{$DATA.value}"
                          />
                        {elseif $DATA.type == 'textarea'}
                          <textarea class="click commentContainer commentsRelatedContainer" style="width:100%"
                                    name="{$DATA.field}"
                                    rows="10"
                                    data-rule-required="{$DATA.required}"
                                    data-placeholder="{$DATA.placeholder}">
                            {$DATA.value}
                          </textarea>
                        {elseif $DATA.type == 'numeric'}
                          <input type="text"
                                 class="click inputElement"
                                 name="{$DATA.field}"
                                 data-rule-wholenumber="true"
                                 data-rule-positive="true"
                                 data-rule-required="{$DATA.required}"
                                 data-placeholder="{$DATA.placeholder}"
                                 value="{$DATA.value}"
                          />
                        {elseif $DATA.type == 'checkbox'}
                          <input type="checkbox"
                                 class="click inputElement"
                                 name="{$DATA.field}"
                                 value="1"
                                 {if $DATA.value == 1} checked {/if}
                                 data-rule-required="{$DATA.required}"
                           />
                        {elseif $DATA.type == 'separator'}
                           {if $DATA.text != ''}
                              {vtranslate($DATA.text, $DATA.module)}
                           {/if}
                        {/if}
                      </div>
                     </div>
                    </div>
                   </td>
                 </tr>
               {/foreach}
              </tbody>
            </table>
          </div>
          <br>
          <div class='modal-overlay-footer clearfix'>
            <div class="row clearfix">
              <div class='textAlignCenter col-lg-12 col-md-12 col-sm-12 '>
                <button type='submit' class='btn btn-success saveButton' >{vtranslate('LBL_SAVE', $MODULE)}</button>&nbsp;&nbsp;
                <a class='cancelLink'
                   data-dismiss="modal"
                   href="javascript:history.back(2);location.reload()"
                   type="reset">{vtranslate('LBL_CANCEL', $MODULE)}</a>
              </div>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
{/strip}
