{*+**********************************************************************************
* The contents of this file are subject to the vtiger CRM Public License Version 1.1
* ("License"); You may not use this file except in compliance with the License
* The Original Code is: vtiger CRM Open Source
* The Initial Developer of the Original Code is vtiger.
* Portions created by vtiger are Copyright (C) vtiger.
* All Rights Reserved.
************************************************************************************}
{* modules/Settings/VebSettings/views/Detail.php *}

{strip}
  {assign var="MODULE_TRANSLATION" value="Settings:{$RECORD_MODEL->get('module')}"}
  <div class="detailViewPageDiv detailViewContainer" id="EditViewVebSettings" style="padding-top:0px;">
    <div class="col-sm-12 col-xs-12">
      <h3 style="margin-top: 0px;">{vtranslate($RECORD_MODEL->get('module'), $MODULE_TRANSLATION)}</h3>
      <span class="col-sm-12">
        <span class="pull-right">
          <button class="btn btn-default " type="button" onclick='window.location.href = "{$RECORD_MODEL->getEditViewUrl()}"'>{vtranslate('LBL_EDIT', $QUALIFIED_MODULE)}</button>
        </span>
      </span>
    </div>
    {assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
    <form id="VebSettingsForm" onSubmit="return false">
      <div class="blockData">
        <div class="block">
          <div>
            <h4>{vtranslate($RECORD_MODEL->get('description'), $MODULE_TRANSLATION)}</h4>
          </div>
          <hr />
          <table class="table viewview-table no-border">
            <tbody>
            {assign var=MODULE_DATA value="{$MODULE_MODEL->get('data')}"}
            {foreach from="{$MODULE_DATA}" item=DATA}
              <tr class="{if "{$DATA.hidden}"}hide{/if}{if $DATA.type != 'separator'} click{/if}"
                  {if $DATA.type != 'separator'}
                     id="{$DATA.field}"
                     {if $DATA.acton} data-acton="{$DATA.acton}"{/if}
                     {if $DATA.action} data-event="{$DATA.action}"{/if}
                     {if $DATA.dependent} data-dependent="{$DATA.dependent}"{/if}
                  {/if}
                  data-value="{Vtiger_Util_Helper::toSafeHTML($DATA.value)}">
                <td class="{$WIDTHTYPE} fieldLabel">
                  <div class="row from-group">
                    <div class="col-sm-6 col-xs-6">
                      <div class="row">
                        <div class="col-lg-6 col-md-6 col-sm-12" title="{$DATA.field}">
                          {if $DATA.type == 'separator'}<span style="font-weight: bold">{/if}
                          {vtranslate($DATA.label, $MODULE_TRANSLATION)}
                          {if $DATA.type == 'separator'}</span>{/if}
                        </div>
                        <div class="col-lg-6 col-md-6 col-sm-12">
                          {if $DATA.type == 'picklist'}
                            {foreach from=$DATA.data item=VALUE}
                              {if $VALUE.id eq $DATA.value} {vtranslate($VALUE.name, $DATA.module)}{/if}
                            {/foreach}
                          {elseif $DATA.type == 'multiselect'}
                            {assign 'array' []}
                            {foreach from=$DATA.value key=idx item=value}
                              {assign var="split" value="$"|explode:$value}
                              {$array.$idx = $split[1]}
                            {/foreach}
                            {'<br /> '|implode:$array}
                          {elseif $DATA.type == 'text'}
                            {$DATA.value}
                          {elseif $DATA.type == 'textarea'}
                            {*Vtiger_Util_Helper::toSafeHTML($DATA.value)|nl2br*}
                            {$DATA.value|nl2br}
                          {elseif $DATA.type == 'numeric'}
                            {$DATA.value}
                          {elseif $DATA.type == 'checkbox'}
                            {if $DATA.value == 1}
                              {vtranslate('LBL_YES')}
                            {else}
                              {vtranslate('LBL_NO', $QUALIFIED_MODULE)}
                            {/if}
                          {elseif $DATA.type == 'separator'}
                            {if $DATA.text != ''}
                              {vtranslate($DATA.text, $DATA.module)}
                            {/if}
                          {/if}
                        </div>
                      </div>
                    </div>
                  </td>
                </tr>
              {/foreach}
            </tbody>
          </table>
        </div>
      </form>
    </div>
  </div>
{/strip}
