/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger.Class("Settings_VebMapping_Js",{
	
	/**
	 * Function to register event to edit destination mapping
	 */
	triggerEdit : function(editUrl){
		app.helper.showProgress();

		app.request.post({'url' : editUrl}).then(
			function(err, data) {
				app.helper.hideProgress();
				if(err === null) {
					var detailContentsHolder = jQuery('.settingsPageDiv div');
					detailContentsHolder.html(data);
					var srcMappingInstance = new Settings_VebMapping_Js();
					srcMappingInstance.registerEventsForEditView();
				}
		});
	},
	
	/**
	 * Function to register event for delete destination mapping
	 */
	triggerDelete : function(event, url){
		var element = jQuery(event.currentTarget);
		var mappingContainer = element.closest('.listViewEntries');
		var mappingId = mappingContainer.data('cfmid');
		var deleteUrl = url + '&mappingid='+mappingId;
		app.helper.showProgress();
		
		app.request.post({'url' : deleteUrl}).then(
			function(err, data) {
				app.helper.hideProgress();
				if(err === null){
					mappingContainer.remove();
					app.helper.showSuccessNotification({'message' : data});
				}else {
					app.helper.showErrorNotification({'message' : err.message});
				}
			});
	}
},{
	/**
	 * Function to register events for edit view of source mapping
	 */
	registerEventsForEditView : function(){
		var form = jQuery('#srcMapping');
		var select2Elements = form.find('.select2');
		vtUtils.showSelect2ElementView(select2Elements);
		this.registerEventForAddingNewMapping();
		this.registerOnChangeEventForSourceModule();
		this.registerEventToDeleteMapping();
		this.registerEventForFormSubmit();
		this.registerOnChangeEventOfTargetModule();
		jQuery('select.dstFields.select2').trigger('change',false);
	},
	
	/**
	 * Function to register event for adding new convert to source mapping
	 */
	registerEventForAddingNewMapping : function(){
		jQuery('.editFieldMappingEditPageDiv').on('click', '#addMapping', function(e){
			var convertMappingTable = jQuery('#convertModuleMapping');
			var lastSequenceNumber = convertMappingTable.find('tr:not(.newMapping):last').attr('sequence-number');
			if (lastSequenceNumber == undefined) lastSequenceNumber = 0;
			var newSequenceNumber = parseInt(lastSequenceNumber)+1;
			var newMapping = jQuery('.newMapping').clone(true,true);
			newMapping.attr('sequence-number',newSequenceNumber);
			newMapping.find('select.srcFields.newSelect').attr("name",'mapping['+newSequenceNumber+'][src]');
			newMapping.find('select.dstFields.newSelect').attr("name",'mapping['+newSequenceNumber+'][dst]');
			newMapping.removeClass('hide newMapping');
			newMapping.appendTo(convertMappingTable);
			newMapping.find('.newSelect').removeClass('newSelect').addClass('select2');
			var select2Elements = newMapping.find('.select2');
			vtUtils.showSelect2ElementView(select2Elements);
			jQuery('select.dstFields.select2',newMapping).trigger('change',false);
		})
	},
	
	/**
	 * Function to register on change event for select2 element
	 */
	registerOnChangeEventForSourceModule : function(){
		var form = jQuery('#srcMapping');
		form.on('change','.srcFields',function(e){
			var element = jQuery(e.currentTarget);
			var container = jQuery(element.closest('tr'));
			var selectedValue = element.val();
			var selectedOption = element.find('option[value="'+selectedValue+'"]');
			var selectedDataType = selectedOption.data('type');
			var dstFieldsSelectElement = container.find('select.dstFields.select2');
			
			var dstFieldsBasedOnType = form.find('.newMapping').find('.dstFields').children().filter('[data-type="'+selectedDataType+'"]').clone(true,true);
			selectedDataType = app.vtranslate("JS_"+selectedDataType);
			container.find('.selectedFieldDataType').html(selectedDataType);
			
			var noneValue = app.vtranslate('JS_NONE');
			dstFieldsSelectElement.html(dstFieldsBasedOnType);
			
			if(selectedDataType != "None"){
				dstFieldsSelectElement.prepend('<option data-type="'+noneValue+'" label="'+noneValue+'" value="0" selected>'+noneValue+'</option>');
			}
			
			dstFieldsSelectElement.trigger("liszt:updated").trigger('change',false);
		})
	},

	/**
	 * Function to register event to delete mapping
	 */
	registerEventToDeleteMapping : function(){
		var form = jQuery('#srcMapping');
		form.on('click','.deleteMapping',function(e){
			var element = jQuery(e.currentTarget);
			var mappingContainer = element.closest('tr');
			var mappingContainerSequenceNumber = mappingContainer.attr('sequence-number');
			var deletableName = 'mapping['+mappingContainerSequenceNumber+'][deletable]';
			mappingContainer.prepend('<input type="hidden" name="'+deletableName+'" />')
			mappingContainer.data('deletable',true).hide('slow');
			app.helper.showSuccessNotification({'message' : app.vtranslate('JS_MAPPING_DELETED_SUCCESSFULLY')});
		})
	},
	
	/**
	 * Function to handle edit view convert source form submit
	 */
	registerEventForFormSubmit : function() {
		jQuery('#srcMapping').on('submit',function(e){
			e.preventDefault();
			var mappingDetails = jQuery(this).serializeFormData();
                        var mappedTo = jQuery('#mappingSrcModule').val();
                        var mappedFrom = jQuery('#mappingDstModule').val();
			var params = { 
				'module' : app.getModuleName(),
				'parent' : app.getParentModuleName(),
				'action' : 'Save',
				'mapping' : mappingDetails,
				'mapsrc' : mappedTo,
				'mapdst' : mappedFrom
			};

			app.helper.showProgress();

			app.request.post({'data' : params}).then(
				function(err, data) {
					app.helper.hideProgress();
					if(err === null){
						var detailViewParams = {
							'module' : app.getModuleName(),
							'parent' : app.getParentModuleName(),
							'view' : mappedTo + mappedFrom
						};
						app.helper.showProgress();
						
						app.request.post({'data' : detailViewParams}).then(function(err, data){
							app.helper.hideProgress();
							
							if(err === null) {
								var detailContentsHolder = jQuery('.settingsPageDiv div');
								detailContentsHolder.html(data);
							}
						});
					}
				});
			});
	},
	
	/**
	 * Function to register on chnage event of target module
	 */
	registerOnChangeEventOfTargetModule : function(){
		var form = jQuery('#srcMapping');
		form.on('change','select.dstFields.select2',function(e,executeChange){
			if(typeof executeChange == "undefined"){
				executeChange = true;
			}
			var selectElement = jQuery(e.currentTarget);
			var selectedValue = selectElement.children().filter('option:selected').text();
			var selectedOptionId = selectElement.children().filter('option:selected').val();
			var mappingContainer = selectElement.closest('tr');
			
			var duplicateOption = false;
			var existingIdElement;
			if(selectedOptionId == "0"){
				selectedOptionId = "false";
			}
			
			if((!executeChange) || (selectedOptionId == "false")){
				selectElement.attr('selectedId',selectedOptionId);
				return;
			}
			
			//check for source module field
			var sourceModuleSelect = mappingContainer.find('select.srcFields.select2');
			var sourceModuleSelectedField = sourceModuleSelect.val();
			var sourceModuleSelectedFieldLabel = sourceModuleSelect.find('option[value="'+sourceModuleSelectedField+'"]').text();
			if(sourceModuleSelectedField == "0"){
				duplicateOption = true;
				var errorParams = {
					message: app.vtranslate('JS_CANT_MAP')+" "+ selectedValue+" "+ app.vtranslate('JS_WITH')+" "+ sourceModuleSelectedFieldLabel,
				}
				app.helper.showErrorNotification(errorParams);
			}
			
			var restrictedFieldsList = JSON.parse(jQuery('#restrictedFieldsList').val());
			if(jQuery.inArray(selectedOptionId, restrictedFieldsList) != -1) {
				duplicateOption = true;
			} else {
				if(selectElement.hasClass('dstFields')){
					existingIdElement = jQuery('select.dstFields.select2');
                    jQuery.each(existingIdElement, function( key, element ) {
                        var element = jQuery(element);
                        var selectedValue = element.val();
						
                        // if Mapping is deleted, we just hiding the row, still element exists
                        // should not consider the deleted mapping for duplicate check
                        var elementRow = existingIdElement.closest('tr:visible');
						
                        if(selectedValue == selectedOptionId && existingIdElement.length > 0 && elementRow.length > 0 && element.attr('name') != selectElement.attr('name')) {
                            duplicateOption = true;
                        }
                    });
				}
			}
			
			if(duplicateOption){
				var selectedFieldId = selectElement.attr('selectedid');
				var previousSelectedValue;
				if(selectedFieldId == "false"){
					previousSelectedValue = selectElement.find('option[label="None"]').text();
					selectElement.attr('selectedId',"false");
				} else if(selectedFieldId != "false"){
					previousSelectedValue = selectElement.find('option[value="'+selectedFieldId+'"]').text();
					selectElement.attr('selectedId',selectedFieldId);
				}
				var params = {
						'id' : previousSelectedValue,
						'text' : previousSelectedValue
					}
				var warningMessage = selectedValue+" "+app.vtranslate('JS_IS_ALREADY_BEEN_MAPPED');
				var notificationParams = {
					message: warningMessage,
				};
				app.helper.showAlertNotification(notificationParams);
				selectElement.select2("data",params);
			} else if(duplicateOption == false){
				selectElement.attr('selectedId',selectedOptionId);
			}
		})
	}
});
