/**
 * AdditionalMapping
 *
 * @package        Inventory
 * @author         Vicus eBusiness Solutions
 * @license        Commercial
 * @copyright      2020 Vicus - www.vicus.nl
 * @version        Release: 1.0
 */
jQuery.Class("ConvertAdditionalFields_Js", {

    init : function() {

      this.getAdditionalFields();
    },

    getModuleName : function() {

        return app.getModuleName();
    },

    getAdditionalFields : function() {

        params = app.convertUrlToDataParams(jQuery(location).attr('href'));

        var process = false;

        if (params.hasOwnProperty('salesorder_id')) process = true;

        if (params.hasOwnProperty('purchaseorder_id')) process = true;

        if (params.hasOwnProperty('quote_id')) process = true;

        if (params.hasOwnProperty('invoice_id')) process = true;

        if (process === false) return;

        moduleName = this.getModuleName();

        params = {
            'destinationModule' : moduleName,
            'module' : 'Settings:VebMapping',
            'parameters' : params,
            'action' : 'ConvertAdditionalFieldsAjax',
            'mode' : 'getAdditionalFields'
        };

        // AppConnector.request(params).then(
        app.request.post({'data' : params}).then(

            function (err, data) {

              /*
               *  0: {name: "cf_1070", type: "string", value: "teksts inhoud", display: null}
               *  1: {name: "cf_1078", type: "currency", value: "10.00000000", display: null}
               *  2: {name: "cf_1080", type: "date", value: "2020-11-03", display: null}
               *  3: {name: "cf_1086", type: "picklist", value: "1", display: null}
               *  4: {name: "cf_1076", type: "percent", value: "10.00", display: null}
               *  5: {name: "cf_1092", type: "textArea", value: "tekstgebied inhoud", display: null}
               *  6: {name: "cf_1090", type: "checkBox", value: "1", display: null}
               *  7: {name: "cf_1072", type: "double", value: "0.10", display: null}
               *  8: {name: "cf_1074", type: "integer", value: "10", display: null}
               *  9: {name: "cf_1082", type: "email", value: "jho@email.com", display: null}
               * 10: {name: "cf_1084", type: "phone", value: "0334611196", display: null}
               * 11: {name: "cf_1088", type: "url", value: "www.vicus.nl", display: null}
               * 12: {name: "cf_1094", type: "multiSelectCombo", value: "1 |##| 2 |##| 3 |##| 4", display: null}
               * 13: {name: "cf_1096", type: "skype", value: "skype adres", display: null}
               * 14: {name: "cf_1098", type: "time", value: "02:30:00", display: null}
               */
              if (err === null) {

                // for(i=0; i<data.result.length; i++) {
                for(i=0; i<data.length; i++) {
 
                    // values = data.result[i];
                    values = data[i];

                    if (values.type == 'picklist') {

                      jQuery('select[name="' + values.name + '"]').val(values.value);
                      jQuery('select[name="' + values.name + '"]').change();

                    }
                    else if (values.type == 'multiSelectCombo') {

                      optionValues = values.value.split(' |##| ');

                      jQuery('select[name="' + values.name + '[]"] > option').each(function() {

                        if (jQuery.inArray(this.value, optionValues) !== -1)

                           jQuery($(this).prop('selected', 'selected'));
                      });

                      jQuery('select[name="' + values.name + '[]"]').change();
                    }
                    else if (values.type == 'textArea') {

                      jQuery('textarea[name="' + values.name + '"]').val(values.value);
                    }
                    else if (values.type == 'checkBox') {

                      jQuery('input[name="' + values.name + '"]').val(values.value);

                      if (values.value == 1) jQuery('input[name="' + values.name + '"].inputElement').click();
                    }
                    else if (values.type == 'reference') {

                      jQuery('input[name="' + values.name + '"]').val(values.value);
                      jQuery('input[name="' + values.name + '_display"]').val(values.display);
                    }
                    else {

                      jQuery('input[name="' + values.name + '"]').val(values.value);
                      jQuery('input[name="' + values.name + '_display"]').val(values.value);
                    }
                  }; 
                }
        });
    }
},{});
