{*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ********************************************************************************/
 *}
{strip}
  {assign var="SRC_MODULENAME" value="{$SRC_MODULE_MODEL->getName()}"}
  {assign var="DST_MODULENAME" value="{$DST_MODULE_MODEL->getName()}"}

  <div class="editFieldMappingEditPageDiv">
    <div class="col-sm-12 col-xs-12">
      <div class="editViewContainer ">
        <form id="srcMapping" method="POST">
          <div class="editViewBody ">
            <div class="editViewContents table-container" >
              <input type="hidden" id="restrictedFieldsList" value={ZEND_JSON::encode($RESTRICTED_FIELD_IDS_LIST)} />
              <input type="hidden" id="mappingSrcModule" value="{$SRC_MODULENAME}" />
              <input type="hidden" id="mappingDstModule" value="{$DST_MODULENAME}" />
              <table class="table listview-table-norecords" width="100%" id="convertModuleMapping">
                <tbody>
                  <tr>
                    <th width="7%"></th>
                    <th width="15%">{vtranslate('LBL_FIELD_LABEL', $QUALIFIED_MODULE)}</th>
                    <th width="15%">{vtranslate('LBL_FIELD_TYPE', $QUALIFIED_MODULE)}</th>
                    <th colspan="3" width="70%">{vtranslate('LBL_MAPPING_WITH_OTHER_MODULE', $QUALIFIED_MODULE)}</th>
                  </tr>
                  <tr>
                    <th width="5%">{vtranslate('LBL_ACTIONS', $QUALIFIED_MODULE)}</th>
                    <th width="5%">{vtranslate($SRC_MODULENAME, $SRC_MODULENAME)}</th>
                    <th width="5%">{vtranslate('Type', $QUALIFIED_MODULE)}</th>
                    <th width="5%">{vtranslate($DST_MODULENAME, $DST_MODULENAME)}</th>
                  </tr>
                  {foreach key=MAPPING_ID item=MAPPING_ARRAY from=$MODULE_MODEL->getMapping($SRC_MODULENAME, $DST_MODULENAME) name="mappingLoop"}
                    <tr class="listViewEntries" sequence-number="{$smarty.foreach.mappingLoop.iteration}">
                      <td width="7%">
                      {if $MAPPING_ARRAY['editable'] eq 1}
                        {foreach item=LINK_MODEL from=$MODULE_MODEL->getMappingLinks()}
                          <div class="table-actions">
                            <span class="actionImages">
                              <i title="{vtranslate($LINK_MODEL->getLabel(), $QUALIFIED_MODULE)}" class="fa fa-trash deleteMapping"></i>
                            </span>
                          </div>
                        {/foreach}
                      {/if}
                      </td>
                      <td width="10%">
                        <input type="hidden" name="mapping[{$smarty.foreach.mappingLoop.iteration}][mappingid]" value="{$MAPPING_ID}"/>
                        <select class="srcFields select2 col-sm-12" name="mapping[{$smarty.foreach.mappingLoop.iteration}][src]" {if $MAPPING_ARRAY['editable'] eq 0} disabled {/if}>
                        {foreach key=FIELD_TYPE item=FIELDS_INFO from=$SRC_MODULE_MODEL->getFields()}
                          {foreach key=FIELD_ID item=FIELD_OBJECT from=$FIELDS_INFO}
                            <option data-type="{$FIELD_TYPE}" {if $FIELD_ID eq $MAPPING_ARRAY['srcModule']['id']} selected {/if} label="{vtranslate($FIELD_OBJECT->get('label'), $SRC_MODULENAME)}" value="{$FIELD_ID}">
                              {vtranslate($FIELD_OBJECT->get('label'), $SRC_MODULENAME)}
                            </option>
                          {/foreach}
                        {/foreach}
                        </select>
                      </td>
                      <td width="10%" class="selectedFieldDataType">{vtranslate($MAPPING_ARRAY['srcModule']['fieldDataType'], $QUALIFIED_MODULE)}</td>
                      <td width="10%">
                        <select class="dstFields select2 col-sm-12" name="mapping[{$smarty.foreach.mappingLoop.iteration}][dst]" {if $MAPPING_ARRAY['editable'] eq 0} disabled {/if}>
                          <option data-type="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}" value="0" label="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}">{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}</option>
                          {foreach key=FIELD_TYPE item=FIELDS_INFO from=$DST_MODULE_MODEL->getFields()}
                            {foreach key=FIELD_ID item=FIELD_OBJECT from=$FIELDS_INFO}
                              {if $MAPPING_ARRAY['srcModule']['fieldDataType'] eq $FIELD_TYPE}
                                  <option data-type="{$FIELD_TYPE}" {if $FIELD_ID eq $MAPPING_ARRAY['dstModule']['id']} selected {/if} label="{vtranslate($FIELD_OBJECT->get('label'), $DST_MODULENAME)}" value="{$FIELD_ID}">
                                    {vtranslate($FIELD_OBJECT->get('label'), $DST_MODULENAME)}
                                  </option>
                              {/if}
                            {/foreach}
                          {/foreach}
                        </select>
                      </td>
                    </tr>
                  {/foreach}
                  <tr class="hide newMapping listViewEntries">
                    <td width="5%">
                      {foreach item=LINK_MODEL from=$MODULE_MODEL->getMappingLinks()}
                        <div class="table-actions">
                          <span class="actionImages">
                            <i title="{vtranslate($LINK_MODEL->getLabel(), $QUALIFIED_MODULE)}" class="fa fa-trash deleteMapping"></i>
                          </span>
                        </div>
                      {/foreach}
                    </td>
                    <td width="10%">
                      <select class="srcFields newSelect col-sm-12">
                        <option data-type="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}" value="0" label="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}">{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}</option>
                        {foreach key=FIELD_TYPE item=FIELDS_INFO from=$SRC_MODULE_MODEL->getFields()}
                          {foreach key=FIELD_ID item=FIELD_OBJECT from=$FIELDS_INFO}
                            <option data-type="{$FIELD_TYPE}" label="{vtranslate($FIELD_OBJECT->get('label'), $SRC_MODULENAME)}" value="{$FIELD_ID}">
                              {vtranslate($FIELD_OBJECT->get('label'), $SRC_MODULENAME)}
                            </option>
                          {/foreach}
                        {/foreach}
                      </select>
                    </td>
                    <td width="10%" class="selectedFieldDataType"></td>
                    <td width="10%">
                      <select class="dstFields newSelect col-sm-12">
                        <option data-type="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}" label="{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}" value="0">{vtranslate('LBL_NONE', $QUALIFIED_MODULE)}</option>
                        {foreach key=FIELD_TYPE item=FIELDS_INFO from=$DST_MODULE_MODEL->getFields()}
                          {foreach key=FIELD_ID item=FIELD_OBJECT from=$FIELDS_INFO}
                            <option data-type="{$FIELD_TYPE}" label="{vtranslate($FIELD_OBJECT->get('label'), $DST_MODULENAME)}" value="{$FIELD_ID}">
                              {vtranslate($FIELD_OBJECT->get('label'), $DST_MODULENAME)}
                            </option>
                          {/foreach}
                        {/foreach}
                      </select>
                    </td>
                  </tr>
                </tbody>
              </table>
              <div class="row">
                <span class="col-sm-4">
                  <button id="addMapping" class="btn addButton module-buttons" type="button" style="margin-left: 10px;">
                    <i class="fa fa-plus"></i>&nbsp;&nbsp;{vtranslate('LBL_ADD_MAPPING', $QUALIFIED_MODULE)}
                  </button>
                </span>
              </div>
            </div>
            <div class='modal-overlay-footer clearfix'>
              <div class="row clearfix">
                <div class='textAlignCenter col-lg-12 col-md-12 col-sm-12 '>
                  <button type='submit' class='btn btn-success saveButton' >{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</button>&nbsp;&nbsp;
                  <a class="cancelLink" type="reset" href="">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
                </div>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
{/strip}
