{*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ********************************************************************************/
-->*}

{strip}
  {assign var="SRC_MODULENAME" value="{$SRC_MODULE->getName()}"}
  {assign var="DST_MODULENAME" value="{$DST_MODULE->getName()}"}

    <div class="fieldMappingListPageDiv">
        <div class="col-sm-12 col-xs-12">
            <div class="row settingsHeader">
                <span class="col-sm-12">
                    <span class="pull-right">
                      <button type="button" class="btn btn-default" onclick="javascript:Settings_VebMapping_Js.triggerEdit('index.php?parent=Settings&module=VebMapping&view=MappingEdit&src={$SRC_MODULENAME}&dst={$DST_MODULENAME}')">{vtranslate('Edit', $QUALIFIED_MODULE)}</button>
                    </span>
                </span>
            </div>
            <div class="contents table-container" id="detailView">
                <table id="listview-table" class="table listview-table-mapping">
                    <thead>
                        <tr>
                            <th width="5%"></th>
                            <th width="15%">{vtranslate('LBL_FIELD_LABEL', $QUALIFIED_MODULE)}</th>
                            <th width="15%">{vtranslate('LBL_FIELD_TYPE', $QUALIFIED_MODULE)}</th>
                            <th colspan="3" width="65%">{vtranslate('LBL_MAPPING_WITH_OTHER_MODULE', $QUALIFIED_MODULE)}</th>
                        </tr>
                        <tr>
                            <th width="5%">{vtranslate('LBL_ACTIONS', $QUALIFIED_MODULE)}</th>
                            <th width="5%">{vtranslate($SRC_MODULENAME, $SRC_MODULENAME)}</th>
                            <th width="5%">{vtranslate('Type', $QUALIFIED_MODULE)}</th>
                            <th width="5%">{vtranslate($DST_MODULENAME, $DST_MODULENAME)}</th>
                        </tr>
                    </thead>
                    <tbody>
                      {foreach item=SEQUENCE from=$DISPLAY_SEQUENCE}
                        {if $SEQUENCE eq 0}
                          <tr>
                            <th colspan="4">
                              <span></span>
                            </th>
                          </tr>
                          <tr>
                            <td colspan="4">
                              <span><b>{vtranslate('LBL_PREDEFINED_MAPPING', $QUALIFIED_MODULE)}</b></span>
                            </td>
                          </tr>
                        {/if}
                        {foreach key=MAPPING_ID item=MAPPING from=$MODULE_MODEL->getMapping($SRC_MODULENAME, $DST_MODULENAME, $SEQUENCE)}
                            <tr class="listViewEntries" data-cfmid="{$MAPPING_ID}">
                                <td width="5%">
                                    {if $MAPPING['editable'] eq 1}
                                        {foreach item=LINK_MODEL from=$MODULE_MODEL->getMappingLinks()}
                                            <div class="table-actions">
                                                <span>
                                                    <a onclick={$LINK_MODEL->getUrl()}><i title="{vtranslate($LINK_MODEL->getLabel(), $QUALIFIED_MODULE)}" class="fa fa-trash alignMiddle"></i></a>
                                                </span>
                                            </div>
                                        {/foreach}
                                    {/if}
                                </td>
                                <td width="10%">{vtranslate($MAPPING['srcModule']['label'], $SRC_MODULENAME)}</td>
                                <td width="10%">{vtranslate($MAPPING['srcModule']['fieldDataType'], $QUALIFIED_MODULE)}</td>
                                <td width="10%">{vtranslate($MAPPING['dstModule']['label'], $DST_MODULENAME)}</td>
                            </tr>
                        {/foreach}
                      {/foreach}
                    </tbody>
                </table>
            </div>
            <div id="scroller_wrapper" class="bottom-fixed-scroll">
                <div id="scroller" class="scroller-div"></div>
            </div>
	</div>
    </div>
{/strip}
