/***********************************************************************************************
** The contents of this file are subject to the Vtiger Docusign License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
*************************************************************************************************/

Vtiger_Edit_Js("Settings_VebCompanyData_VebCompanyData_Js",{},
{
	registerEventSave: function(){
		
		 var aDeferred = jQuery.Deferred();
		 var thisInstance = this;
		 var form = jQuery('#vebcompanydatasettings');
		 var savebtn = jQuery('[name="saveConfig"]', form);

		savebtn.unbind('click').click(function(e) {
			var flag = thisInstance.validate();
			//var flag = true;
			if(flag == true){

				
				var username 			=	jQuery('[name="username"]').val();
				var password            =	jQuery('[name="password"]').val();
				var dataprovide			=	jQuery('[name="dataprovide"]').val();
				var update_frequency	=	jQuery('[name="update_frequency"]').val();
				
				var params = {
				'module'            : app.getModuleName(),
				'parent'            : app.getParentModuleName(),
				'action'            : 'SaveConfig',
				'mode'              : 'add',
				'username'          : username,
				'password'          : password,
				'dataprovide'     	: dataprovide,   
				'update_frequency'  : update_frequency,
				
				}
				var saveMessage = app.vtranslate('Please wait!');
				var progressIndicatorElement = jQuery.progressIndicator({
					'message' : saveMessage,
					'position' : 'html',
					'blockInfo' : {
					'enabled' : true
					}
				});
				AppConnector.request(params).then(
					function(data) {
						var response = data['result'];
						progressIndicatorElement.progressIndicator({
							'mode' : 'hide'
						})
						 if(response['message'] != ''){

							app.helper.showSuccessNotification({'message':app.vtranslate('LBL_SAVE_SUCCESSFULLY')});
						    window.location="index.php?module=VebCompanyData&parent=Settings&view=Show&block=13&fieldid=42";
						}
					   
						else{
							app.helper.showErrorNotification({'message':app.vtranslate('LBL_FAIL')});
						  
						}

					  	aDeferred.resolve();

					},
					function(error,err){
						aDeferred.reject();
					}
				);
			}
		})
		return aDeferred.promise();
	},
	
	 validate : function(container) {
	 	
		 	var thisInstance	= this;
			var username 		= jQuery('[name="username"]').val();
			var password 		= jQuery('[name="password"]').val();
			
			if(username == ''){
				app.helper.showErrorNotification({'message':app.vtranslate('LBL_ADD_USERNAME')});
				return false;
			}
			else
			if( password == '' ){
				app.helper.showErrorNotification({'message':app.vtranslate('LBL_ADD_PASSWORD')});
				return false;
			}
			else
			{
				return true;
			}
	},
		registerEnableValues : function() {
		var thisInstance = this;
		var form = jQuery('#checklistQuestionForm');
			jQuery('input[type="radio"]').on('click change', function(e) {
			
			if(jQuery("input[name='response_type']:checked").val() == 'Picklist')
			{
				document.getElementById("picklist_values").disabled = false;
			}	
			else
			{
				document.getElementById("picklist_values").disabled = true;
			} 
		})
	},


    registerEvents : function(container) {
		var thisInstance = this;
		this._super();
		thisInstance.registerEventSave();
		
}
})
jQuery(document).ready(function() {
	var instance = new Settings_VebCompanyData_VebCompanyData_Js();
	instance.registerEvents();
	
})