/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

/** @var Settings_ITS4YouQuickSearch_Index_Js */
Vtiger_List_Js('Settings_ITS4YouQuickSearch_Index_Js', {}, {
    changeModuleFields: function () {
        $('.quick-search-module-fields').on('change', function (element) {
            let target = $(element.currentTarget),
                targetValue = target.val(),
                row = target.closest('tr'),
                statusElement = row.find('[name="moduleStatus"]'),
                status = !targetValue ? 'off' : statusElement.val(),
                data = {
                    'columns': targetValue,
                    'tabid': row.data('tabid'),
                },
                params = {
                    module: app.getModuleName(),
                    parent: app.getParentModuleName(),
                    action: 'SaveAjax',
                    mode: 'saveSearchingFields',
                    params: data,
                    status: status,
                };

            if('off' === status) {
                statusElement.attr('value', 'off');
                statusElement.bootstrapSwitch('state', false, true);
            }

            params.dataType = 'json';

            app.helper.showProgress();
            app.request.post({data: params}).then(function (error, data) {
                app.helper.hideProgress();
                app.helper.showSuccessNotification({message: data.message});
            });
        });
    },
    changeModuleStatus: function () {
        $("input[name='moduleStatus']").on('switchChange.bootstrapSwitch', function (event) {
            let target = $(event.currentTarget),
                selectedFields = $(event.currentTarget).closest('tr').find('.module-fields-column').find('select.quick-search-module-fields').val();

            if (selectedFields !== null && selectedFields.length > 0) {
                let status = 0;

                if ('on' === target.val()) {
                    status = 1;
                    target.attr('value', 'off');
                    $(target).bootstrapSwitch('state', false, true);
                } else {
                    target.attr('value', 'on');
                    $(target).bootstrapSwitch('state', true, true);
                }

                let params = {
                    module: app.getModuleName(),
                    parent: app.getParentModuleName(),
                    action: 'SaveAjax',
                    mode: 'processModuleStatus',
                    value: status,
                    tabid: target.closest('tr').data('tabid')
                };

                app.helper.showProgress();
                app.request.post({data: params}).then(function (error, data) {
                    app.helper.hideProgress();

                    if (!error) {
                        app.helper.showSuccessNotification({message: app.vtranslate('JS_QUICK_SEARCH_SETTINGS_SAVED_SUCCESSFULLY')});
                    } else {
                        app.helper.showErrorNotification({message: app.vtranslate('JS_QUICK_SEARCH_SETTINGS_NOT_SAVED')});
                    }
                });
            } else {
                $(target).bootstrapSwitch('state', false, true);
                app.helper.showErrorNotification({message: app.vtranslate('JS_NO_FIELDS_SELECTED')});
            }
        });
    },
    registerEvents: function () {
        this.changeModuleFields();
        this.changeModuleStatus();
        this.registerBootstrapSwitch();
    },
    registerBootstrapSwitch: function () {
        $("input[name='moduleStatus']").bootstrapSwitch();
    }
});
