{*<!--
/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/
-->*}
{strip}
    <div class="container-fluid">
        <div class="row">
            <div class="listViewContentDiv col-lg-12 col-sm-12 col-md-12">
                <div class="col-xs-8">
                    <h4>{vtranslate($MODULE, $QUALIFIED_MODULE)}</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div id="table-content" class="table-container" style="overflow: auto;">
                    <table id="listview-table" class="table listview-table">
                        <thead>
                        <tr>
                            <th><strong>{vtranslate('Module',$QUALIFIED_MODULE)}</strong></th>
                            <th><strong>{vtranslate('SearchFields',$QUALIFIED_MODULE)}</strong></th>
                            <th colspan="2"><strong>{vtranslate('LBL_ACTIVATE',$QUALIFIED_MODULE)}</strong></th>
                        </tr>
                        </thead>
                        <tbody class="overflow-y">
                        {foreach from=$SUPPORTED_MODULES item=INTEGRATION_MODEL key=INTEGRATION_MODULE}
                            {assign var=MODULE_FIELDS value=$INTEGRATION_MODEL->getFields()}
                            <tr data-tabid="{$INTEGRATION_MODEL->getModuleId()}">
                                <td style="width:150px;">
                                    {vtranslate($INTEGRATION_MODULE,$INTEGRATION_MODULE)}
                                </td>
                                <td class="module-fields-column">
                                    <div class="form-group">
                                        <div class="controls col-lg-10 col-md-10">
                                            <select class="select2 form-control quick-search-module-fields" multiple name="searchcolumn">
                                                {foreach from=$MODULE_FIELDS item=MODULE_FIELD}
                                                    <option value="{$MODULE_FIELD->get('name')}"
                                                            {if $INTEGRATION_MODEL->isActiveField($MODULE_FIELD->get('name'))}selected{/if}>
                                                        {vtranslate($MODULE_FIELD->get('label'), $INTEGRATION_MODULE)}
                                                    </option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                </td>
                                <td style="width:100px;">
                                    <div>
                                        <input style="opacity: 0;" {if $INTEGRATION_MODEL->isActive()} checked value="on" {else} value="off" {/if}
                                               data-on-color="success" data-id="" type="checkbox" name="moduleStatus">
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <br>
{/strip}