{*+*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ***********************************************************************************}
{strip}
	<div class="editViewPageDiv " id="editViewContent">
		<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 ">
			<div class="contents">
				<form id="CoreEditorForm" class="form-horizontal" data-detail-url="{$MODULE_MODEL->getDetailViewUrl()}" method="POST">
					{assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
					<div>
						<h4>{vtranslate('LBL GEOTOOLS CORE EDITOR', $QUALIFIED_MODULE)}</h4>
					</div>
					<hr>
					<br>
					<div class="detailViewInfo">
    	                {foreach from=$MODULE_MODEL->getFields() item=FIELD_TYPE key=FIELD}
                            <div class="row form-group">
                                <div class="col-lg-4 col-md-4 col-sm-4 fieldLabel">
                                    <label>{vtranslate($FIELD,$QUALIFIED_MODULE)}</label>
                                </div>
						        <div class="{$WIDTHTYPE} col-lg-4 input-group">
							        {if $FIELD_TYPE == 'picklist'}
							            {if $FIELD == 'defaultcentre'}
							                {assign var=PICKLISTVALUES value=$DEFAULTCENTRE}
							            {else}
							                {assign var=PICKLISTVALUES value=$MODULE_MODEL->getPicklistValues($FIELD)}
							            {/if}
            							<select class="select2-container inputElement select2 col-lg-11" name="{$FIELD}">
                                            {foreach key=optionName item=optionLabel from=$PICKLISTVALUES}
                                                <option value="{$optionName}" {if $optionName == {$MODULE_MODEL->get($FIELD)}} selected {/if}>
                                                    {vtranslate($optionLabel, $QUALIFIED_MODULE)}
                                                </option>
                                            {/foreach}
								        </select>
								    {else if $FIELD_TYPE == 'text'}
    								    <div class="input-group inputElement">
                                            {*validation has been removed*}
                                            <input class="inputElement" type="text" name="{$FIELD}" value="{$MODULE_MODEL->get($FIELD)}" />
                                        </div>
                                        {if $FIELD == 'companyloc'}
                                            <button class="btn btn-success saveButton" type="button" id="geocodeCompany" 
                                                title="{vtranslate('LBL GEOTOOLS GEOCODE COMPANY ADDRESS', $QUALIFIED_MODULE)}">
                                                <strong>{vtranslate('LBL GEOTOOLS GEOCODE COMPANY ADDRESS', $QUALIFIED_MODULE)}</strong>
                                             </button>
                                        {/if}
                                    {else if $FIELD_TYPE == 'icons'}
    								    <div class="input-group inputElement {$FIELD}">
                                            {foreach key=ID item=PATH from=$MODULE_MODEL->getIconMarkers()}
                                                <input type="radio" name="{$FIELD}" data-rule-required="true" value="{$PATH}" {if $PATH == {$MODULE_MODEL->get($FIELD)}} checked="checked"{/if} />
                                                <span class="icon"><img src="{$PATH}" /></span>
                                            {/foreach}
                                        </div>
							        {/if}
						        </div>
						    </div>
        				{/foreach}
	    		    </div>
	    		    <div class='modal-overlay-footer clearfix'>
						<div class="row clearfix">
							<div class='textAlignCenter col-lg-12 col-md-12 col-sm-12'>
								<button type='submit' class='btn btn-success saveButton'>{vtranslate('LBL_SAVE', $QUALIFIED_MODULE)}</button>&nbsp;&nbsp;
								<a class='cancelLink' type="reset">{vtranslate('LBL_CANCEL', $QUALIFIED_MODULE)}</a>
							</div>
						</div>
					</div>
                </form>
            </div>
        </div>
    </div>
{/strip}
