/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

Vtiger.Class("Settings_EmailCampaigns_Js",{},{
	
    init : function() {
       this.addComponents();
    },
   
    addComponents : function (){
        this.addModuleSpecificComponent('Index',app.module(), app.getParentModuleName());
    },

	/*
	 * function to Save the Configuration Editor content
	 */
	 
	saveConfigEditor : function(form) {
		var thisInstance = this;
		var aDeferred = jQuery.Deferred();
		var data = form.serializeFormData();
		
		var updatedFields = {};
		jQuery.each(data, function(key, value) {
			updatedFields[key] = value;
		})
		var params = {
			'module' : app.getModuleName(),
			'parent' : app.getParentModuleName(),
			'action' : 'EmailCampaignDetailSaveAjax',
			'updatedFields' : JSON.stringify(updatedFields)
			};
           
		app.request.post({'data' : params}).then(
			function(err, data) {
                app.helper.showProgress();
				if(err === null){
                    var EmailCmpaignsDetailUrl = form.data('detailUrl');
                    thisInstance.loadContents(EmailCmpaignsDetailUrl).then(
						function(data) {
						jQuery('.settingsPageDiv').html(data);
						thisInstance.registerDetailViewEvents();
                            app.helper.hideProgress();
						}
					);
				aDeferred.resolve(data);
                }else {
					app.helper.hideProgress();
					jQuery('.errorMessage', form).html(err.message);
					jQuery('.errorMessage', form).removeClass('hide');
                    aDeferred.reject();
				}
			}
		);
        return aDeferred.promise();
	},

	registerDeactivateLicense : function(){
		$('#deactivate_license_btn').on('click',function(){
			var deactivateActionUrl = 'module='+app.getModuleName()+'&action=LicenseRemove';
			var message = app.vtranslate('JS_DEACTIVATE_QUESTION');
            app.helper.showConfirmationBox({'message': message}).then(function(data) {

            var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                        'enabled' : true
                }
            });
 			
                AppConnector.request(deactivateActionUrl).then(
                function(data) {

                    if (data.result) {
                        var params = {
                        title: app.vtranslate('JS_DEACTIVATION_CONFIRMED'),
                        type: 'info'
                        };
                    } else {
                        var params = {
                        title : app.vtranslate('JS_DEACTIVATION_ERROR'),
                        type: 'error'
                        };
                    }
                    
                    window.location.reload();
                    Vtiger_Helper_Js.showMessage(params);
					progressIndicatorElement.progressIndicator({'mode':'hide'});
					return;
                });
            });
		});
	},
	/*
	 * Function to load the contents from the url through pjax
	 */
	 
	loadContents : function(url) {
		var aDeferred = jQuery.Deferred();
		app.request.pjax({"url" : url}).then(
			function(err, data){
                if(err === null){
				jQuery('.settingsPageDiv ').html(data);
				aDeferred.resolve(data);
            }
			},
			function(error, err){
				aDeferred.reject();
			}
		);
		return aDeferred.promise();
	},
	
	/*
	 * function to register the events in editView
	 */
	registerEditViewEvents : function(e) {
		var thisInstance = this;
		var form = jQuery('#updatedetails');
		//var resetButton = jQuery('.resetButton', form);
		var cancelLink = jQuery('.cancelLink', form);
		
		//register validation engine
		var params = {
            submitHandler : function(form) {
                  app.helper.showProgress();
                var form = jQuery(form);
				thisInstance.saveConfigEditor(form);
            }
		};
        if(form.is('form')) form.vtValidate(params);
		 form.on('submit', function(e){
            e.preventDefault();
            return false;
        });
		//register click event for cancelLink
		cancelLink.click(function(e) {
			var EmailCampaignsDetailUrl = form.data('detailUrl');
			thisInstance.loadContents(EmailCampaignsDetailUrl).then(
				function(data) {
                     jQuery('.editViewPageDiv').html(data);
					//after loading contents, register the events
					thisInstance.registerDetailViewEvents();
				}
			);
		});		
	},	
		
	/*
	 * function to register the events in DetailView
	 */
	registerDetailViewEvents : function() {
		var thisInstance = this;
		//Detail view container
		var container = jQuery('#DetailEmailCampaignsSetting');
		var editButton = jQuery('.editButton', container);
		//register click event for edit button
		editButton.click(function(e) {
			app.helper.showProgress();

			var url = editButton.data('url');
			thisInstance.loadContents(url).then(
				function(data) {
                    jQuery('.settingsPageDiv ').html(data);
                    app.helper.hideProgress();
					//after load the contents register the edit view events
					thisInstance.registerEditViewEvents();                   
				}
			);
		});
		thisInstance.registerDeactivateLicense();
	},
	
	registerEvents: function() {
		var thisInstance = this;
		thisInstance.registerEditViewEvents();
		thisInstance.registerDetailViewEvents();
	}

});


jQuery(document).ready(function(){
	var settingModuleManagerInstance = new Settings_EmailCampaigns_Js();
	settingModuleManagerInstance.registerEvents();
	jQuery('.UpdateCheckModule').on('click', function(e) {
        var module = jQuery(e.currentTarget).data('module');
        jQuery.post('index.php', { 'module':module, 'parent':'Settings', 'view':'Upgrade', 'step' : 1}, function(response) {
            app.helper.showModal(response, { cb: function (data) {
                jQuery('.StartUpdate').on('click', function() {
                    jQuery('#RUNNING_UPDATE').show();

                    jQuery.post('index.php', { 'module':module, 'parent':'Settings', 'view':'Upgrade', 'step' : 3}, function(response) {
                        window.location.reload();
                    });
                });
            } });
        });
    });

	if(app.view()=='Edit') return;
    // Check enable
    var sPageURL = window.location.search.substring(1);
    var targetModule = '';
    var targetView = '';
    var targetRecord = '';
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == 'module') {
            targetModule = sParameterName[1];
        }
        else if (sParameterName[0] == 'view') {
            targetView = sParameterName[1];
        }
        else if (sParameterName[0] == 'record') {
            targetRecord = sParameterName[1];
        }
    }
    if (targetModule == 'EmailCampaigns' && targetView == 'EmailCampaignDetails') {
        var buttonContainer = jQuery('tr#smtpsettings');
        var outGoingServerBtn = jQuery('<button type="button" class="btn btn-default btnOutgoingServer">Outgoing Server</button>');
        buttonContainer.find('td:last>span').after(outGoingServerBtn);

        var instance = new MultiSender();
        instance.registerEvents();
    }

})





Vtiger.Class("MultiSender",{
    instance:false,
    getInstance: function(){
        if(MultiSender.instance == false){
            var instance = new MultiSender();
            MultiSender.instance = instance;
            return instance;
        }
        return MultiSender.instance;
    },
},{
    registerEventForOutgoingButton: function () {
        var thisInstance=this;
        jQuery('.btnOutgoingServer').unbind();
        jQuery('.btnOutgoingServer').on('click', function (e) {
            var currentInstance = window.app.controller();
            var url ='index.php?module=EmailCampaigns&view=MassActionAjax&mode=showListview';
            thisInstance.showListView(url);
        });
    },

    registerEventForEditButtons: function() {
        var thisInstance=this;
        jQuery('body').delegate('.edit_info','click',function(){
            var url_ = jQuery(this).data('url');
            $('button.close').trigger('click');
            var func= function(){ var url = url_;
                app.helper.hideModal();$('#overlayPageContent').remove();
                app.helper.showProgress();
                var params = app.convertUrlToDataParams(url);
                app.request.post({data:params}).then(
                    function (err,data) {
                        if(err == null) {
                            app.helper.hideProgress();
                            app.helper.showModal(data);
                            var form = jQuery('#outgoingMassEditContainer');
                            form.on("click","button[name='saveButton']",function(e){
                                e.preventDefault();
                                thisInstance.saveOutgoingServer(form);
                            });
                        }
                    }
                    );}; setTimeout(func, 2000);

            })
    },
    //#478958 End

    registerEventForDeleteRecord: function(){
        var thisInstance=this;
        jQuery('body').on('click','.delete_server',function(){
            var message = app.vtranslate('LBL_DELETE_CONFIRMATION');
            var url = jQuery(this).data('url');
            var userid = jQuery(this).data('userid');
            app.helper.showConfirmationBox({'message' : message}).then(
                function(){
                    thisInstance.deleteServer(url,userid);
                }
                );
        })
    },

    showListView: function (url) {
        var thisInstance = this;
        app.helper.hideModal();
        app.helper.showProgress();
        popupShown = true;
        app.request.post({'url':url}).then(function(err,resp) {
            app.helper.hideProgress();
            if(err === null) {
                app.helper.showModal(resp, {'cb' : function(modal) {
                    popupShown = false;
                }});

                thisInstance.loadListUserServer();
            }
        });
    },

    deleteServer: function (url,userid) {
        var thisInstance = this;
        app.helper.showProgress();
        app.request.post({'url':url}).then(
            function(err,data){
                if(err === null) {
                    app.helper.hideProgress();
                    var new_url = 'index.php?module=EmailCampaigns&view=MassActionAjax&mode=showListview';
                    thisInstance.showListView(new_url);
                }
            }
            );
    },

    saveOutgoingServer : function(form) {
        var thisInstance = this;
        app.helper.showProgress();
        var data = form.serializeFormData();
        data['module'] = 'EmailCampaigns';
        data['action'] = 'SaveAjax';
        data['mode'] = 'savesmtp';
        app.request.post({'data':data}).then(
            function(err,data){
                if(err === null) {
                    app.helper.hideProgress();
                    app.helper.hideModal();
                    app.helper.showSuccessNotification({'message':app.vtranslate('Outgoing Server Saved')});
                }else{
                    app.helper.hideProgress();
                    app.helper.showErrorNotification({'message':err.message});
                }
            },
            function(error) {
                app.helper.hideProgress();
                //TODO : Handle error
            }
            );
    },
    loadListUserServer: function () {
        var thisInstance = this;
        var blocks = jQuery('.blocksSortable');
        blocks.sortable({
            'revert': true,
            'connectWith': ".blocksSortable",
            'tolerance': 'pointer',
            'cursor': 'move',
            'placeholder': "state-highlight",
            'stop': function (event, ui) {
                thisInstance.updateSequence();
            }
        });
    },
    updateSequence: function () {
        var thisInstance = this;
        var params = {};
        $(".blockSortable").each(function (index) {
            //alert(index);
            params[$(this).data('id')] = {'index': index, 'column': $(this).closest('.blocksSortable').data('column')};
        });
        thisInstance.registerSaveEvent('updateSequence', {'data': params});
    },
    registerSaveEvent: function (mode, data) {
        var resp = '';
        var params = {};
        params.data = {
            module: 'EmailCampaigns',
            view: 'MassActionAjax',
            mode: mode,
            params: data
        };
        
        params.async = true;
        
        params.dataType = 'json';
        app.request.post(params).then(
            function (err,data) {
                if(data) {
                    app.helper.showSuccessNotification({'message':data['message']});
                }
            }
            );
    },

    registerEvents: function(){
        this.registerEventForOutgoingButton();
        this.registerEventForEditButtons();
        this.registerEventForDeleteRecord();
    }
});