/***********************************************************************************************
** The contents of this file are subject to the Vtiger Docusign License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
*************************************************************************************************/

Vtiger_Edit_Js("Settings_Docusign_DocusignSetting_Js",{},
{
	registerEventSave: function(){
		 var aDeferred = jQuery.Deferred();
		 var thisInstance = this;
		 var form = this.getForm();
		 var savebtn = jQuery('[name="tks_savesetting"]', form);

		savebtn.unbind('click').click(function(e) {
			var flag = thisInstance.validate();
			
			if(flag == true){
				

				var email 				= jQuery('[name="tks_dev_email"]').val();
				var password            = jQuery('[name="tks_password"]').val();
				var docusignid      	= jQuery('[name="docusignid"]').val();
				var selectpdf           = jQuery('[name="selectpdf"]',form).is(':checked');
                var selectsandbox 		= jQuery('[name="selectsandbox"]',form).is(':checked');
				var integrator_key 		= jQuery('[name="tks_integrator_key"]').val();

				if(selectpdf == true)
					selectpdf = 1;
				else
					selectpdf = 0;

                                if(selectsandbox == true)
					selectsandbox = 1;
				else
					selectsandbox = 0;

				var params = {
				'module'            : app.getModuleName(),
				'parent'            : app.getParentModuleName(),
				'action'            : 'SaveDocuSign',
				'mode'              : 'tks_mode',
				'email'             : email,
				'password'          : password,
				'docusignid'        : docusignid,
				'selectpdf'         : selectpdf,
                'selectsandbox'     : selectsandbox,
				'integrator_key'    : integrator_key,
				}
				var saveMessage = app.vtranslate('Authenticating details!');
				var progressIndicatorElement = jQuery.progressIndicator({
					'message' : saveMessage,
					'position' : 'html',
					'blockInfo' : {
					'enabled' : true
					}
				});
				AppConnector.request(params).then(
					function(data) {
						//console.log(data);
						//alert(data['result']['data']);
						var response = data['result'];
						progressIndicatorElement.progressIndicator({
							'mode' : 'hide'
						})
						 if(response['data'] == 'PDF Maker Not Install'){

							//Vtiger_Helper_Js.showPnotify(app.vtranslate("LBL_PDFMaker_ERR"));
							app.helper.showErrorNotification({message :app.vtranslate('LBL_PDFMaker_ERR')});
							
							document.getElementById("selectpdf").checked = false;

						}

					    else if(response['data'] == 'FAIL'){
							//Vtiger_Helper_Js.showPnotify(app.vtranslate('LBL_AUTH_FAIL'));
							app.helper.showErrorNotification({message :app.vtranslate('LBL_AUTH_FAIL')});
						}
						else{
							var params = {
								text: app.vtranslate('LBL_DOCUSIGN_SAVE')
							};
						   Settings_Vtiger_Index_Js.showMessage(params);
						   window.location="index.php?module=Docusign&view=List";
						}

					  	aDeferred.resolve();

					},
					function(error,err){
						aDeferred.reject();
					}
				);
			}
		})
		return aDeferred.promise();
	},

	emailtest : function (email){
  		var re=new RegExp(/^[a-zA-Z0-9]+([!"#$%&'()*+,./:;<=>?@\^_`{|}~-]?[a-zA-Z0-9])*@[a-zA-Z0-9]+([\_\-\.]?[a-zA-Z0-9]+)*\.([\-\_]?[a-zA-Z0-9])+(\.?[a-zA-Z0-9]+)?$/);
		 if (!re.test(email))
	 	 {
			return false;
	 	 }
		 return true;
	},

	 validate : function(container) {
		 	var thisInstance = this;
			var email 		= jQuery('[name="tks_dev_email"]').val();
			var password 	= jQuery('[name="tks_password"]').val();
			var integrator_key 	= jQuery('[name="tks_integrator_key"]').val();
			
			var emailflag   = thisInstance.emailtest(email);
			if(email == ''){
				
				app.helper.showErrorNotification({message :app.vtranslate('LBL_EMAIL_VALIDATION1')});
				
				//Vtiger_Helper_Js.showPnotify(app.vtranslate('LBL_EMAIL_VALIDATION1'));
				return false;
			}
			else
			if( email != '' && emailflag == false ){
				
				app.helper.showErrorNotification({message :app.vtranslate('LBL_EMAIL_VALIDATION2')});
				//Vtiger_Helper_Js.showPnotify(app.vtranslate('LBL_EMAIL_VALIDATION2'));
				return false;
			}
			else
			if(password == ''){
				
				app.helper.showErrorNotification({message :app.vtranslate('LBL_PWD_VALIDATION')});
				//Vtiger_Helper_Js.showPnotify(app.vtranslate('LBL_PWD_VALIDATION'));
				return false;
			}
			else
			if(integrator_key == ''){
				
				app.helper.showErrorNotification({message :app.vtranslate('LBL_KEY_VALIDATION')});
				//Vtiger_Helper_Js.showPnotify(app.vtranslate('LBL_KEY_VALIDATION'));
				return false;
			}
			else
			{
				return true;
			}
	},

    registerEvents : function(container) {
		var thisInstance = this;
		this._super();
		this.registerEventSave();
	}
});
