/*+***********************************************************************************************************************************
 * The contents of this file are subject to the YetiForce Public License Version 1.1 (the "License"); you may not use this file except
 * in compliance with the License.
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.
 * See the License for the specific language governing rights and limitations under the License.
 * The Original Code is YetiForce.
 * The Initial Developer of the Original Code is YetiForce. Portions created by YetiForce are Copyright (C) www.yetiforce.com. 
 * All Rights Reserved.
 *************************************************************************************************************************************/

jQuery.Class("Settings_BruteForce_Js",{
	runAppConnector:function(a){
		AppConnector.request(a).then(
			function(c){
				var b=c.result;
				if(b.success){
					var d={
						text:app.vtranslate(b.message),
						animation:"show",
						type:"info",
					};
					//Vtiger_Helper_Js.showPnotify(d);
					app.helper.showSuccessNotification({'message':app.vtranslate(b.message)});
				}
				else{
					var d={
						text:app.vtranslate(b.message),
						animation:"show",
						type:"error",
					};
					//Vtiger_Helper_Js.showPnotify(d)
					app.helper.showErrorNotification({'message':app.vtranslate(b.message)});
					
				}
			},
			function(c,b){
				var d={
					text:app.vtranslate("Could not finish reaction."),
					animation:"show",
					type:"error",
				};
				//Vtiger_Helper_Js.showPnotify(d)
				app.helper.showErrorNotification({'message':app.vtranslate('Could not finish reaction.')});
			}
		)},

		registerEvents:function(){
			var a=this;
			jQuery("#saveConfig").click(function(){
			var e=jQuery('[name="attempsnumber"]').val();
			var b=jQuery('[name="timelock"]').val();
			var d=$("[name='active']").is(":checked");
			var c=$("[name='selectedUsers']").val();

			validation=a.fieldsValidation(e,b);
				if(false==validation){
					return false;
			}
				if(!e.length&&!b){
					var f={text:app.vtranslate("Complete the fields"),
						animation:"show",
						type:"warning",
					};
					//Vtiger_Helper_Js.showPnotify(f);
					app.helper.showErrorNotification({'message':app.vtranslate('Complete the fields')});
					return false;
				}
				var f={};
					f.data={
						module:"BruteForce",
						action:"SaveConfig",
						parent:app.getParentModuleName(),
						number:e,
						timelock:b,
						active:d,
						selectedUsers:c,
					};
						f.async=false;
						f.dataType="json";
						a.runAppConnector(f);
					return false;
					});
			$("#brutalforce_tab_btn_1").click(function(){$("#brutalforce_tab_btn_2").attr("class","");
			$("#brutalforce_tab_btn_1").attr("class","active");
			$("#brutalforce_tab_2").hide();$("#brutalforce_tab_1").show()});
			$("#brutalforce_tab_btn_2").click(function(){$("#brutalforce_tab_btn_1").attr("class","");
			$("#brutalforce_tab_btn_2").attr("class","active");$("#brutalforce_tab_1").hide();
			$("#brutalforce_tab_2").show()});
			jQuery("#unblock").click(function(){jQuery(this).parents("tr").hide();
			ip=jQuery(this).attr("data-ip");

			var b={};
				b.data={
					module:"BruteForce",
					action:"UnBlock",
					parent:app.getParentModuleName(),
					ip:ip,
				};
					b.async=false;
					b.dataType="json";
					a.runAppConnector(b);
			return false;
				})
		},

		fieldsValidation:function(c,b){
			var a=true;
				if((2>=c||c>=100)||isNaN(c)){
					var d={
						text:app.vtranslate("JS_WRONG_ATTEMPS_NUMBER"),
						animation:"show",
						type:"error"
					};
					//Vtiger_Helper_Js.showPnotify(d);
					app.helper.showErrorNotification({'message':app.vtranslate('JS_WRONG_ATTEMPS_NUMBER')});
						a=false;
				}
				if(isNaN(b)){
					var d={
						text:app.vtranslate("JS_WRONG_TIME_LOCK_FORMAT"),
						animation:"show",
						type:"error"
				};
				//Vtiger_Helper_Js.showPnotify(d);
				app.helper.showErrorNotification({'message':app.vtranslate('JS_WRONG_TIME_LOCK_FORMAT')});
					a=false;
				}
				return a;
		}
	});
		jQuery(document).ready(function(){
			var a=new Settings_BruteForce_Js();
			a.registerEvents();
});
