/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

/** @var ITS4YouQuickSearch_SearchList_Js */
Vtiger.Class('ITS4YouQuickSearch_SearchList_Js', {
    initializeListInstances: function (container) {
        container.find('.listViewPageDiv').each(function (index, domEle) {
            let container = jQuery(domEle);
            let moduleListInstance = new ITS4YouQuickSearch_ModuleList_Js();
            moduleListInstance.setModuleName(container.find('[name="search_module"]').val()).setListViewContainer(container);
            moduleListInstance.registerEvents();
        });
    }
}, {});

/** @var ITS4YouQuickSearch_ModuleList_Js */
Vtiger_List_Js('ITS4YouQuickSearch_ModuleList_Js', {}, {
    searchModule: false,
    getSearchValue: function () {
        return jQuery('#its4you-keyword-input').val();
    },
    getDefaultParams: function () {
        let container = this.getListViewContainer(),
            defaultParams = {
                module: 'ITS4YouQuickSearch',
                selectedModule: $('#current_search_module').val(),
                view: 'BasicAjax',
                mode: 'showSearchResultsWithLimit',
                value: this.getSearchValue(),
                recordsCount: container.find('[name="recordsCount"]').val()
            };

        defaultParams.parent = '';
        return defaultParams;
    },
    registerPageNavigationEvents: function () {
        const self = this,
            container = this.getListViewContainer();

        container.on('click', '.nextPageButton', function (e) {
            const pageNumber = container.find('[name="pageNumber"]').val(),
                params = {
                    page: parseInt(parseFloat(pageNumber)) + 1
                },
                searchingModuleName = jQuery(e.currentTarget).siblings('.searching_module_name').val();

            self.loadListViewRecords(params, searchingModuleName);
        });

        container.on('click', '.previousPageButton', function (e) {
            const pageNumber = container.find('[name="pageNumber"]').val(),
                previousPageNumber = parseInt(parseFloat(pageNumber)) - 1;

            if (pageNumber > 1) {
                const params = {
                        page: previousPageNumber
                    },
                    searchingModuleName = jQuery(e.currentTarget).siblings('.searching_module_name').val();

                self.loadListViewRecords(params, searchingModuleName);
            }
        });
    },
    loadListViewRecords: function (urlParams, searchingModuleName) {
        const self = this,
            aDeferred = jQuery.Deferred(),
            defParams = self.getDefaultParams();

        if ('undefined' === typeof urlParams) {
            urlParams = {};
        }

        if ('undefined' === typeof urlParams.search_params) {
            urlParams.search_params = JSON.stringify(self.getListSearchParams(false));
        }

        urlParams.current_searching_module = searchingModuleName;
        urlParams = jQuery.extend(defParams, urlParams);

        app.helper.showProgress();
        app.request.post({data: urlParams}).then(function (error, data) {
            app.helper.hideProgress();

            aDeferred.resolve(data);
            self.replaceContent(data, searchingModuleName);
            app.event.trigger('post.listViewFilter.click', jQuery('.searchRow'));
        });

        return aDeferred.promise();
    },
    replaceContent: function (contents, selectedModuleName) {
        const container = jQuery('.listViewPageDiv.' + selectedModuleName);

        container.html(contents);
    },
    registerEvents: function () {
        this.registerEventToShowQuickPreview();
        this.registerPageNavigationEvents();
        this.registerRowClickEvent();
        this.registerListViewSort();
    }
});