/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

/** @var ITS4YouQuickSearch_ITS4YouQuickSearchHeader_Js */
Vtiger_Index_Js('ITS4YouQuickSearch_ITS4YouQuickSearchHeader_Js', {
    instance: false,
    getInstance: function () {
        if (!this.instance) {
            this.instance = new ITS4YouQuickSearch_ITS4YouQuickSearchHeader_Js();
        }

        return this.instance;
    },
}, {
    createSearchField: function () {
        const thisInstance = this,
            params = {
                module: 'ITS4YouQuickSearch',
                view: 'Input'
            };

        app.request.post({data: params}).then(function (error, data) {
            if (!error && !!data) {
                let searchLinkContainer = jQuery('.search-links-container');
                searchLinkContainer.empty();
                searchLinkContainer.html(data);
                vtUtils.showSelect2ElementView(jQuery('#its4you_quick_search_pickListModules'));

                thisInstance.registerSearchEvents();
            }
        });
    },
    registerSearchEvents: function () {
        this.registerSearchAction();
        Vtiger_Index_Js.getInstance().registerAdvanceSeachIntiator();
    },
    registerSearchAction: function () {
        const originalEventCodeParams = {
            module: 'ITS4YouQuickSearch',
            view: 'BasicAjax',
            mode: 'showQuickSearchResult'
        };

        jQuery('#its4you-keyword-input').off('keypress').on('keypress', function (event) {
            if (event.originalEvent) {
                if (event.which === 13) {
                    let currentTarget = jQuery(this),
                        selectedModule = jQuery('#its4you_quick_search_pickListModules').val();

                    originalEventCodeParams.value = currentTarget.val();

                    if ('default' === selectedModule) {
                        selectedModule = 'ITS4YouQuickSearch';
                    }

                    originalEventCodeParams.selectedModule = selectedModule;

                    app.helper.showProgress();
                    app.request.post({data: originalEventCodeParams}).then(function (error, data) {
                        app.helper.hideProgress();

                        if (!error && !!data) {
                            app.helper.loadPageOverlay(data).then(function (modal) {
                                modal.find('#its4you-keyword-input').val(jQuery('#its4you-keyword-input').val());
                                ITS4YouQuickSearch_SearchList_Js.initializeListInstances(modal);
                            });
                        }
                    });
                }
            }
        });
    },
    registerEvents: function () {
        this.createSearchField();
    }
});

$(function () {
    ITS4YouQuickSearch_ITS4YouQuickSearchHeader_Js.getInstance().registerEvents();
});