/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/
 
jQuery.Class("GeoTools_OSMmapCode_Js",{

    mapInstance : false,
    
    bounds : false,

    getInstance: function(){
        if(GeoTools_OSMmapCode_Js.mapInstance == false ){
           var instance = new GeoTools_OSMmapCode_Js();
           GeoTools_OSMmapCode_Js.mapInstance = instance;
        }
        return GeoTools_OSMmapCode_Js.mapInstance;
    },

}, {

    showMap : function() {
        var thisInstance = this;
        var mapcenter = $('#geotoolsMapCenter').val();
        var latlng = thisInstance.castLatlng(mapcenter);
        var LLatLng = thisInstance.getLeafletLatLng(mapcenter);
        var mapZoom = parseInt($('#zoom').val());
        var attrib = 'Map Data &copy; <a href="http://openstreetmap.org">OpenStreetMap</a> contributors';
            attrib = attrib + ' | GeoTools by <a href="http://www.libertus.co.uk">Libertus Solutions</a>';
        
        // set up the map
        if(!GeoTools_List_Js.map) {
            GeoTools_List_Js.map = new L.Map('map_canvas', {  
                fullscreenControl: true,
                center : LLatLng,
            });
        }
        // set up the bounding box
        GeoTools_OSMmapCode_Js.bounds = new L.LatLngBounds();
        
        // Reset the key holder
        GeoTools_List_Js.key = {};
        
        // create the tile layer with correct attribution
        var osmUrl='https://{s}.tile.osm.org/{z}/{x}/{y}.png';
        var osm = new L.tileLayer(osmUrl, {
                        attribution: attrib
                    });

        GeoTools_List_Js.map.addLayer(osm);

        thisInstance.clearLocations();
        thisInstance.paintMarkers();
        thisInstance.paintCenter(latlng);

        if(!jQuery.isEmptyObject(GeoTools_List_Js.key)) {
            thisInstance.paintKey();
        } else {
            jQuery('#geotoolskey').remove();
        }
        
        GeoTools_List_Js.map.fitBounds(GeoTools_OSMmapCode_Js.bounds, {
            padding : [10, 10],
            minZoom : mapZoom
        });

    },
    
    castLatlng : function(str) {
        var pos = str.split(",", 2)
        var obj = {lat : parseFloat(pos[0]), lng : parseFloat(pos[1])};
        return obj;
    },
    
    // Generate a Leaflet LatLng Object
    getLeafletLatLng : function(str) {
        var pos = str.split(",", 2)
        return new L.LatLng(parseFloat(pos[0]), parseFloat(pos[1]));
    },

    clearLocations : function () {
        for (var i = 0; i < GeoTools_List_Js.markers.length; i++) {
            GeoTools_List_Js.map.removeLayer(GeoTools_List_Js.markers[i]);
        }
        GeoTools_List_Js.markers.length = 0;
    },
    
    paintCenter : function(pos) {
        var thisInstance = this;
        var centericon = $('#centericon').val();
        if(centericon) {

            var centerMarker = L.marker(pos, {
                icon : thisInstance.createIcon(centericon, '12', '12'),
                draggable : true,
                id : 'center',
            }).addTo(GeoTools_List_Js.map);
            GeoTools_OSMmapCode_Js.bounds.extend(pos);
            GeoTools_List_Js.markers.push(centerMarker);
        }
    },
    
    paintMarkers : function() {
        var thisInstance = this;
        if( $("listViewEntriesTable") ){
            var markerNodes = $(".listViewEntries"); // The <tr>s
            var headers = thisInstance.getColumnHeaders();
            var iconpath = $('#iconpath').val();
            if (markerNodes.length > 0) {
                for (var i = 0; i < markerNodes.length; i++) {
                    var locked = '';
                    var latlng = {
                            lat : parseFloat(markerNodes[i].getAttribute("lat")), 
                            lng : parseFloat(markerNodes[i].getAttribute("lng"))
                    };
                    // If there's no LatLng or iconpath we need to bail out here
                    if(isNaN(latlng['lat']) || isNaN(latlng['lng']) || iconpath == '') {
                        continue;
                    }
                    var tds = markerNodes[i].getElementsByTagName("td");
                
                    var col1value = tds[1].innerHTML;
                    var col2value = tds[2].innerHTML;
                    var col3value = tds[3].innerHTML;
                    var distance = $('td[data-field-name="distance"]', markerNodes[i]).html();
                    var id = parseFloat(markerNodes[i].getAttribute("data-id"));
                    if(markerNodes[i].getAttribute("locked") == '1'){
                        locked = 'checked';
                    }
                    var keyName = markerNodes[i].getAttribute('geopicklist');
                    var hue = false;
                    if(keyName) {
                        var hue = 'hsl('+markerNodes[i].getAttribute('hue')+', 60%, 50%)';
                        GeoTools_List_Js.key[keyName] = hue;
                    }
                    thisInstance.createMarker(id, latlng, col1value, col2value, col3value, distance, iconpath, headers, locked, hue);
                    GeoTools_OSMmapCode_Js.bounds.extend(latlng);
                }
            }
        }
    },
    
    paintKey : function() {
        jQuery('#geotoolskey').remove();
        
        var picklistName = jQuery('#icon_picklist').val();
        var html = '<div id="geotoolskey"><div><span><strong>'+picklistName+' '+app.vtranslate('JS_GEOTOOLS_KEY')+'</strong></span></div>';
        var item = '';
        var i = 0;
        jQuery.each(GeoTools_List_Js.key, function(name,colour) {
            item = item + '<div><div class="keycolour" style="background-color:'+colour+';"></div><span>'+name+'</span></div>';
            i++;
        });
        html = html + item + '</div>';
        jQuery('#geotoolsSearchContainer table').after(html);

    },
    
    createMarker : function(id, latlng, col1value, col2value, col3value, distance, iconpath, headers, locked, hue) {
        var thisInstance = this;
        
        var iconObj = thisInstance.createIcon(iconpath, '10', '34');
        if(hue) {
            var iconObj = thisInstance.createVectorIcon(hue, 20, 34);
        }
        
        var editMarkerMessage = app.vtranslate('JS_GEOTOOLS_EDIT_THIS_MARKERS_LOCATION');
        var saveNewLocation = app.vtranslate('JS_GEOTOOLS_SAVE_THIS_MARKERS_LOCATION');
        var lockedLabel = app.vtranslate('JS_GEOTOOLS_LOCKED');
        var units = $('[name="geotoolsDistanceUnits"]').val();
        var html = '<table><tbody>'+
                   '<tr><td align="right"><b>' + headers[0] + ': </b></td><td align="left"><b>' + col1value + '</b></td></tr>'+
                   '<tr><td align="right"><b>' + headers[1] + ': </b></td><td align="left"><b>' + col2value + '</b></td></tr>'+
                   '<tr><td align="right"><b>' + headers[2] + ': </b></td><td align="left"><b>' + col3value + '</b></td></tr>'+
                   '<tr><td align="right"><b>' + $(headers).last()[0] + ': </b></td><td align="left"><b>' + distance + ' ' + units + '</b></td></tr>'+
                   '<tr><td class="popupButton">'+
                            '<span class="editLocation btn" id="'+id+'">'+editMarkerMessage+'</span>'+
                            '<span class="saveLocation btn" style="display:none" id="'+id+'">'+saveNewLocation+'</span>'+
                   '</td>'+
                   '<td align="right"><span><b>'+lockedLabel+': </b></span><input id="'+id+'" type="checkbox" class="listViewEntriesCheckBox" '+locked+'></td></tr>'+
                   '</tbody></table>';
                   
        // Add onclick events for edting and saving a dragged marker's.
        // editLocation Gets the related marker and makes it draggable
        // Create a "dragend" event handler to update the database, or add an option to save new location?
        // Probably should pass this lot back to our GeoTools_List_Js class.
        var contents = $(html);
        contents.on('click', 'span.editLocation', function(e) {
            var crmid = $(this).attr('id');
            $('span.saveLocation').css('display', 'inline');
            $(this).css('display', 'none');
            jQuery.map(GeoTools_List_Js.markers, function(e, i) {
                if (e.options.id == crmid) {
                    e.dragging.enable();
                }
            });
        });
        
        contents.on('click', 'span.saveLocation', function(e) {
            var crmid = $(this).attr('id');
            var locked = $(this).closest('td').next('td').find('input').prop('checked');
            $('span.editLocation').css('display', 'inline');
            $(this).css('display', 'none');
            jQuery.map(GeoTools_List_Js.markers, function(e, i) {
                if (e.options.id == crmid) {
                    e.dragging.disable();
                    GeoTools_List_Js.saveLocation(crmid, e.getLatLng(), locked);
                }
            });
        });

        var marker = L.marker(latlng, {
                icon : iconObj,
                //icon : vectorIconObj,
                draggable : false,
                id : id
        }).on('click', function() {
            jQuery('.listViewEntries[data-id="'+this['options']['id']+'"]').effect("highlight", {}, 3000);
        });
        
        marker.bindPopup(contents[0], {
            offset: new L.Point(0, 0) 
        }).openPopup();
        marker.addTo(GeoTools_List_Js.map);
        GeoTools_List_Js.markers.push(marker);
    },

    createIcon : function(path, X, Y) {
        // Point to fix marker to the map in pixels - Dependent on size of marker.
        var pinAnchor = new L.Point(X, Y);
        var myIcon = L.icon({
            iconUrl: path,
            iconAnchor: pinAnchor
        });
        return myIcon;
    },
    
// L.marker([48.15491,11.54183], {icon: L.VectorMarkers.icon({icon: 'spinner', prefix: 'fa', markerColor: '#cb4b16', spin: true}) }).addTo(map);
    createVectorIcon : function(colour, X, Y) {
        var vectorIcon = L.VectorMarkers.icon({
            //  icon: 'rocket',
            icon: 'myIcon',
            iconSize : [X, Y],
            markerColor: colour
        });

        return vectorIcon;
    },
    
    addmarkerEvent : function(marker, eventtype) {
        marker.openPopup();
    },
    
    getColumnHeaders : function() {
        var headers = [];
        jQuery("a.listViewHeaderValues").each(function() {
            headers.push(jQuery(this).text()) 
        });
        return headers;
    }

});
