/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit3_Js",{},{

	step3Container : false,
	ckEditorInstance: false,
	attachmentsFileSize : 0,
	documentsFileSize : 0,

	init : function() {
		this.initialize();
	},

	setAttachmentsFileSizeByElement : function(element){
		this.attachmentsFileSize += element.get(0).files[0].size;
	},

	setAttachmentsFileSizeBySize : function(fileSize){
		this.attachmentsFileSize += parseFloat(fileSize);
	},

	getAttachmentsFileSize : function(){
		return this.attachmentsFileSize;
	},
	setDocumentsFileSize : function(documentSize){
		this.documentsFileSize += parseFloat(documentSize);
	},
	getDocumentsFileSize : function(){
		return this.documentsFileSize;
	},

	getTotalAttachmentsSize : function(){
		return parseFloat(this.getAttachmentsFileSize())+parseFloat(this.getDocumentsFileSize());
	},

	getMaxUploadSize : function(){
		return jQuery('#maxUploadSize').val();
	},

	removeAttachmentFileSizeByElement : function(element) {
		this.attachmentsFileSize -= element.get(0).files[0].size;
	},

	removeDocumentsFileSize : function(documentSize){
		this.documentsFileSize -= parseFloat(documentSize);
	},

	removeAttachmentFileSizeBySize : function(fileSize) {
		this.attachmentsFileSize -= parseFloat(fileSize);
	},

	registerEventForRemoveCustomAttachments : function() {
		var thisInstance = this;
		var composeEmailForm = this.getContainer();
		jQuery('[name="removeAttachment"]').on('click',function(e){
			var attachmentsContainer = composeEmailForm.find('[ name="attachments"]');
			var attachmentsInfo = JSON.parse(attachmentsContainer.val());
			var element = jQuery(e.currentTarget);
			var imageContainer = element.closest('div.MultiFile-label');
			var imageContainerData = imageContainer.data();
			var fileType = imageContainerData['fileType'];
			var fileSize = imageContainerData['fileSize'];
			var fileId = imageContainerData['fileId'];
			if(fileType == "document"){
				thisInstance.removeDocumentsFileSize(fileSize);
			} else if(fileType == "file"){
				thisInstance.removeAttachmentFileSizeBySize(fileSize);
			}
			jQuery.each(attachmentsInfo,function(index,attachmentObject){
				if((typeof attachmentObject != "undefined") && (attachmentObject.fileid == fileId)){
					attachmentsInfo.splice(index,1);
				}
			});
			attachmentsContainer.val(JSON.stringify(attachmentsInfo));
			imageContainer.remove();
		});
	},

	getDocumentAttachmentElement : function(selectedFileName,id,selectedFileSize){
		return '<div class="MultiFile-label"><a href="#" class="removeAttachment cursorPointer" data-id='+id+' data-file-size='+selectedFileSize+'>x </a><span>'+selectedFileName+'</span></div>';
	},

	checkIfExisitingAttachment : function(selectedDocumentId){
		var documentExist;
		var documentPresent;
		var mode = jQuery('[name="emailMode"]').val();
		var selectedDocumentIds = jQuery('#documentIds').val();
		var existingAttachment = JSON.parse(jQuery('[name="attachments"]').val());
		if((mode != "") && (existingAttachment != null)){
			jQuery.each(existingAttachment,function(key,value){
				if(value.hasOwnProperty( "docid")){
					if(value['docid'] == selectedDocumentId){
						documentExist = 1;
						return false;
					} 
				}
			})
			if(selectedDocumentIds != ""){
				selectedDocumentIds = JSON.parse(selectedDocumentIds);
			}
			if((documentExist == 1) || (jQuery.inArray(selectedDocumentId,selectedDocumentIds) != '-1')){
				documentPresent = 1;
			} else {
				documentPresent = 0;
			}
		} else if(selectedDocumentIds != ""){
			selectedDocumentIds = JSON.parse(selectedDocumentIds);
			if((jQuery.inArray(selectedDocumentId,selectedDocumentIds) != '-1')){
				documentPresent = 1;
			} else {
				documentPresent = 0;
			}
		}
		if(documentPresent == 1){
			var errorMsg = app.vtranslate("JS_THIS_DOCUMENT_HAS_ALREADY_BEEN_SELECTED");
			app.helper.showErrorNotification({message: errorMsg});
			return true;
		} else {
			return false;
		}
	},

	writeDocumentIds :function(selectedDocumentId){
		var thisInstance = this;
		var newAttachment;
		var selectedDocumentIds = jQuery('#documentIds').val();
		if(selectedDocumentIds != ""){
			selectedDocumentIds = JSON.parse(selectedDocumentIds);
			var existingAttachment = thisInstance.checkIfExisitingAttachment(selectedDocumentId);
			if(!existingAttachment){
				newAttachment = 1;
			} else {
				newAttachment = 0;
			}
		} else {
			var existingAttachment = thisInstance.checkIfExisitingAttachment(selectedDocumentId);
			if(!existingAttachment){
				newAttachment = 1;
				var selectedDocumentIds = new Array();
			}
		}
		if(newAttachment == 1){
			selectedDocumentIds.push(selectedDocumentId);
			jQuery('#documentIds').val(JSON.stringify(selectedDocumentIds));
			return true;
		} else {
			return false;
		}
	},

	/**
	 * Function to calculate upload file size
	 */
	calculateUploadFileSize : function(){
		var thisInstance = this;
		var composeEmailForm = this.getContainer();
		var attachmentsList = composeEmailForm.find('#attachments');
		var attachments = attachmentsList.find('.customAttachment');
		jQuery.each(attachments,function(){
			var element = jQuery(this);
			var fileSize = element.data('fileSize');
			var fileType = element.data('fileType');
			if(fileType == "file"){
				thisInstance.setAttachmentsFileSizeBySize(fileSize);
			} else if(fileType == "document"){
				thisInstance.setDocumentsFileSize(fileSize);
			}
		})
	},

	/**
	 * Function to get the container which holds all the report elements
	 * @return jQuery object
	 */
	getContainer : function() {
		return this.step3Container;
	},

	/**
	 * Function to set the report step3 container
	 * @params : element - which represents the report step3 container
	 * @return : current instance
	 */
	setContainer : function(element) {
		this.step3Container = element;
		return this;
	},

	/**
	 * Function  to intialize the reports step3
	 */
	initialize : function(container) {
		if(typeof container == 'undefined') {
			container = jQuery('#emailcampaigns_step3');
		}

		if(container.is('#emailcampaigns_step3')) {
			this.setContainer(container);
		}else{
			this.setContainer(jQuery('#emailcampaigns_step3'));
		}
	},

    registerEventForCkEditor: function () {
        var form = this.getContainer();
        var noteContentElement = form.find('[name="description"]');
        if (noteContentElement.length > 0) {
            var ckEditorInstance = new Vtiger_CkEditor_Js();
            ckEditorInstance.loadCkEditor(noteContentElement);
        }
        this.registerFillTemplateContentEvent();
    },
    registerFillTemplateContentEvent: function () {
        var container = this.getContainer();
        container.on('change', 'select[name="templateFields"]', function (e) {
            var oEditor = CKEDITOR.instances.EmailCampaigns_editView_fieldName_description;
            var value = jQuery(e.currentTarget).val();
            oEditor.insertHtml(value);
        });
    },
    getckEditorInstance: function () {
        if (this.ckEditorInstance == false) {
            this.ckEditorInstance = new Vtiger_CkEditor_Js();
            var form = this.getContainer();
            var noteContentElement = form.find('[name="description"]');
            this.ckEditorInstance.element = noteContentElement;
        }
        return this.ckEditorInstance;
    },

    registerBrowseCrmEvent : function(){
		var thisInstance = this;
		jQuery('#browseCrm').on('click',function(e){
			var url = jQuery(e.currentTarget).data('url');
			var postParams = app.convertUrlToDataParams("index.php?"+url);

			app.request.post({"data":postParams}).then(function(err,data){
				jQuery('.popupModal').remove();
				var ele = jQuery('<div class="modal popupModal"></div>');
				ele.append(data);
				jQuery('body').append(ele);
				thisInstance.showpopupModal();
				app.event.trigger("post.Popup.Load",{"eventToTrigger":"post.DocumentsList.click"});
			});
		});
	},


	/*
	 * Function to validate special cases in the form
	 * returns result
	 */
	isFormValidate : function(){
		return true;
	},


	submit : function(){
		var aDeferred = jQuery.Deferred();

		var conditions = jQuery("#emailcampaigns_step2 input[name=conditions]").val();
        jQuery("#conditions1").val(conditions);

        var objEditor = CKEDITOR.instances["EmailCampaigns_editView_fieldName_description"];
        var q = objEditor.getData();
        jQuery('[name="description"]').val(q);

		var form = this.getContainer();

		app.helper.showProgress();

		var data = new FormData(form[0]);

		var postParams = {
			data:data,
			// jQuery will set contentType = multipart/form-data based on data we are sending
			contentType:false,
			// we don’t want jQuery trying to transform file data into a huge query string, we want raw data to be sent to server
			processData:false,
			cache: false
		};
		app.request.post(postParams).then(function(err,data){
			if(err==null){
				form.hide();
				var params = {
					module: app.getModuleName(),
					parent: app.getParentModuleName(),
					view: 'Edit',
					mode: 'Step4',
					record: data.id
				}
				app.request.post({data:params}).then(function(error,data) {
					if(error == null) {
						app.helper.hideProgress();
						aDeferred.resolve(data);
					}
				},
				function(error,err){
					aDeferred.reject();
				});
			}
		});

		return aDeferred.promise();
	},

	registerChangeEventForModule: function () {
        var thisInstance = this;
        var container = this.getContainer();
        container.on('change', 'select[name="modulename"]', function (e) {
            thisInstance.loadFields();
        });
    },

    loadFields: function () {
        var moduleName = jQuery('select[name="modulename"]').val();
        var allFields = jQuery('[name="moduleFields"]').data('value');
        var fieldSelectElement = jQuery('select[name="templateFields"]');
        var options = '';
        for (var key in allFields) {
            //IE Browser consider the prototype properties also, it should consider has own properties only.
            if (allFields.hasOwnProperty(key) && key == moduleName) {
                var moduleSpecificFields = allFields[key];
                var len = moduleSpecificFields.length;
                for (var i = 0; i < len; i++) {
                    var fieldName = moduleSpecificFields[i][0].split(':');
                    options += '<option value="' + moduleSpecificFields[i][1] + '"';
                    if (fieldName[0] == moduleName) {
                        options += '>' + fieldName[1] + '</option>';
                    } else {
                        options += '>' + moduleSpecificFields[i][0] + '</option>';
                    }
                }
            }
        }

        if (options == '')
            options = '<option value="">NONE</option>';

        fieldSelectElement.empty().html(options).trigger("liszt:updated");
        return fieldSelectElement;
   },
	/**
	 * Function to register select Email Template click event
	 * @returns {undefined}
	 */
	registerSelectEmailTemplateEvent : function(){

		var thisInstance = this;
		jQuery("#selectEmailTemplate").on("click",function(e){
			var url = "index.php?"+jQuery(e.currentTarget).data('url');
			var postParams = app.convertUrlToDataParams(url);
			app.request.post({data:postParams}).then(function(err,data){
				if(err === null){
					jQuery('.popupModal').remove();
					var ele = jQuery('<div class="modal popupModal"></div>');
					ele.append(data);
					jQuery('body').append(ele);

					thisInstance.showpopupModal();
					app.event.trigger("post.Popup.Load",{"eventToTrigger":"post.EmailTemplateList.click"})
				}
			});
		});
	},

	fileAfterSelectHandler : function(element, value, master_element){
		var thisInstance = this;
		var mode = jQuery('[name="emailMode"]').val();
		var existingAttachment = JSON.parse(jQuery('[name="attachments"]').val());
		element = jQuery(element);
		thisInstance.setAttachmentsFileSizeByElement(element);
		var totalAttachmentsSize = thisInstance.getTotalAttachmentsSize();
		var maxUploadSize = thisInstance.getMaxUploadSize();
		if(totalAttachmentsSize > maxUploadSize){
			app.helper.showAlertBox({message:app.vtranslate('JS_MAX_FILE_UPLOAD_EXCEEDS')});
			this.removeAttachmentFileSizeByElement(jQuery(element));
			master_element.list.find('.MultiFile-label:last').find('.MultiFile-remove').trigger('click');
		}else if((mode != "") && (existingAttachment != "")){
			var pattern = /\\/;
			var fileuploaded = value;
			jQuery.each(existingAttachment,function(key,value){
				if((value['attachment'] == fileuploaded) && !(value.hasOwnProperty( "docid"))){
					var errorMsg = app.vtranslate("JS_THIS_FILE_HAS_ALREADY_BEEN_SELECTED")+fileuploaded;
					app.helper.showAlertBox({message:app.vtranslate(errorMsg)});
					thisInstance.removeAttachmentFileSizeByElement(jQuery(element),value);
					master_element.list.find('.MultiFile-label:last').find('.MultiFile-remove').trigger('click');
					return false;
				}
			})
		}
		return true;
	},

	removeAttachmentFileSizeByElement : function(element) {
		this.attachmentsFileSize -= element.get(0).files[0].size;
	},

	removeDocumentIds : function(removedDocumentId){
		var documentIdsContainer = jQuery('#documentIds');
		var documentIdsArray = JSON.parse(documentIdsContainer.val());
		documentIdsArray.splice( jQuery.inArray('"'+removedDocumentId+'"', documentIdsArray), 1 );
		documentIdsContainer.val(JSON.stringify(documentIdsArray));
	},

	registerRemoveAttachmentEvent : function(){
		var thisInstance = this;
		this.getContainer().on('click','.removeAttachment',function(e){
			var currentTarget = jQuery(e.currentTarget);
			var id = currentTarget.data('id');
			var fileSize = currentTarget.data('fileSize');
			currentTarget.closest('.MultiFile-label').remove();
			thisInstance.removeDocumentsFileSize(fileSize);
			thisInstance.removeDocumentIds(id);
			if (jQuery('#attachments').is(':empty')){
				jQuery('.MultiFile,.MultiFile-applied').removeClass('removeNoFileChosen');
			}
		});
	},
		
	registerMosaicoEmailTemplateEvent : function(){	
		var thisInstance = this;
		jQuery("#selectMosaicoEmailTemplate").on("click",function(e){
			var url = "index.php?"+jQuery(e.currentTarget).data('url');
			var postParams = app.convertUrlToDataParams(url);
			app.request.post({data:postParams}).then(function(err,data){
				if(err === null){
					jQuery('.popupModal').remove();
					var ele = jQuery('<div class="modal popupModal"></div>');
					ele.append(data);
					jQuery('body').append(ele);

					thisInstance.showpopupModal();
					app.event.trigger("post.Popup.Load",{"eventToTrigger":"post.EmailTemplateList.click"})
				}
			});
		});
	},		

	showpopupModal : function(){
		var thisInstance = this;
		vtUtils.applyFieldElementsView(jQuery('.popupModal'));
		jQuery('.popupModal').modal();
		jQuery('.popupModal').on('shown.bs.modal', function() {
			jQuery('.myModal').css('opacity', .5);
			jQuery('.myModal').unbind();
		});
		/*
		jQuery('.popupModal').on('hidden.bs.modal', function() {
			this.remove();
			jQuery('.myModal').css('opacity', 1);
			jQuery('.myModal').removeData("modal").modal(app.helper.defaultModalParams());
			jQuery('.myModal').bind();
		});
		*/
	},


	registerEvents : function(){
		var thisInstance = this;
		var container = this.getContainer();

		vtUtils.applyFieldElementsView(container);

        this.registerSelectEmailTemplateEvent();
        this.registerMosaicoEmailTemplateEvent();
        jQuery("#multiFile").MultiFile({
			list: '#attachments',
			'afterFileSelect' : function(element, value, master_element){
				var masterElement = master_element;
				var newElement = jQuery(masterElement.current);
				newElement.addClass('removeNoFileChosen');
				thisInstance.fileAfterSelectHandler(element, value, master_element);
			},
			'afterFileRemove' : function(element, value, master_element){
				if (jQuery('#attachments').is(':empty')){
					jQuery('.MultiFile,.MultiFile-applied').removeClass('removeNoFileChosen');
				}
				thisInstance.removeAttachmentFileSizeByElement(jQuery(element));
			}
		});

        this.registerRemoveAttachmentEvent();
        this.registerBrowseCrmEvent();
        this.calculateUploadFileSize();
        this.registerEventForCkEditor();
        this.registerChangeEventForModule();
        this.registerEventForRemoveCustomAttachments();
        
		app.event.on("post.EmailTemplateList.click",function(event, data){
				var responseData = JSON.parse(data);
				jQuery('.popupModal').modal('hide');
				for(var id in responseData){
					var data = responseData[id];
					
					if (data.module=="Mosaico") {
						jQuery('#EmailCampaigns_editView_fieldName_subject').val(data.info.subject);
		                var params = {
							module: 'EmailCampaigns',
							view: 'getMosaicoInfo',
							record: id
						};
						$.post('index.php', params, function (response) {
								var ckEditorInstance = thisInstance.getckEditorInstance();
								ckEditorInstance.loadContentsInCkeditor(response);
								var selectedTemplateBody = response;
						});
					} else {
						var ckEditorInstance = thisInstance.getckEditorInstance();
						var data = responseData[id];
						ckEditorInstance.loadContentsInCkeditor(data['info']);
						jQuery('#EmailCampaigns_editView_fieldName_subject').val(data['name']);
						var selectedTemplateBody = responseData[id].info;
					}
				}
			});




			app.event.on("post.DocumentsList.click",function(event, data){
				var responseData = JSON.parse(data);
				jQuery('.popupModal').modal('hide');
				for(var id in responseData){
					selectedDocumentId = id;
					var selectedFileName = responseData[id].info['filename'];
					var selectedFileSize = responseData[id].info['filesize'];
					var response = thisInstance.writeDocumentIds(selectedDocumentId)
					if(response){
						var attachmentElement = thisInstance.getDocumentAttachmentElement(selectedFileName,id,selectedFileSize);
						//TODO handle the validation if the size exceeds 5mb before appending.
						jQuery(attachmentElement).appendTo(jQuery('#attachments'));
						jQuery('.MultiFile-applied,.MultiFile').addClass('removeNoFileChosen');
						thisInstance.setDocumentsFileSize(selectedFileSize);
					}
				}
			});

	}
});


