/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit1_Js",{},{
	
	step1Container : false,
	
	init : function() {
		this.initialize();
	},
	/**
	 * Function to get the container which holds all the reports step1 elements
	 * @return jQuery object
	 */
	getContainer : function() {
		return this.step1Container;
	},

	/**
	 * Function to set the reports step1 container
	 * @params : element - which represents the reports step1 container
	 * @return : current instance
	 */
	setContainer : function(element) {
		this.step1Container = element;
		return this;
	},

	/**
	 * Function  to intialize the emailcampaigns step1
	 */
	initialize : function(container) {
		if(typeof container == 'undefined') {
			container = jQuery('#emailcampaigns_step1');
		}
		if(container.is('#emailcampaigns_step1')) {
			this.setContainer(container);
		}else{
			this.setContainer(jQuery('#emailcampaigns_step1'));
		}
	},
	
	/**
	 * Function to register the TypeAssignment change event
	 */
	 
	registerTypeAssignmentChangeEvent : function(){
		var thisInstance = this;
		
		var container = this.getContainer();
		var type = container.find('[name="typeofassignment"]');
		var assignto = container.find('[name="assignto"]');
		var assignto_section = assignto.closest('.row');
		if(type.val() != 'LBL_ASS_FIX'){
			assignto_section.hide();
		}
		container.find('select[name="typeofassignment"]').on('change',function(e){
			var selectedOption = jQuery(e.currentTarget).val();
			if(selectedOption == 'LBL_ASS_FIX'){
				assignto_section.show();
			} else{
				if(selectedOption == 'LBL_ASS_CAMPAIGN'){
					assignto.val(container.find('[name="assigned_user_id"]').val());
				} else {
					assignto.val("1");
				}
				assignto.trigger("liszt:updated");
				assignto_section.hide();
			}
		});
	},
	
	submit : function(){
		var thisInstance = this;
		var aDeferred = jQuery.Deferred();
		var form = this.getContainer();
		var formData = form.serializeFormData();
		
		var params = {};
		app.helper.showProgress();
		

		app.request.post({data:formData}).then(
			function(err,data) {
				form.hide();
				app.helper.hideProgress();
				aDeferred.resolve(data);
			},
			function(error,err){

			}
			);

		return aDeferred.promise();
	},
	
		
	registerEvents : function(){
		vtUtils.applyFieldElementsView(this.getContainer());
		this.registerTypeAssignmentChangeEvent();
	}
});