 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_FieldSettings_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_FieldSettings.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_FieldSettings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_FieldSettings_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerSelectModuleChange:function() {
        jQuery("#vcard_fields_settings").on("change","#vcard_module", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery(this).val();
            var selectedFields=jQuery("#vcard_fields_settings").find("#vcardselectedFields");
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"VcardFieldsAjax",
                    "vcard_module" : searchModule,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data.result);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });

        jQuery("#asset_fields_settings").on("change","#asset_module", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery(this).val();
            var selectedFields=jQuery("#asset_fields_settings").find("#AssetSelectedFields");
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"AssetFieldsAjax",
                    "asset_module" : searchModule,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data.result);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });

        jQuery("#search_fields_settings").on("change","#search_module", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery(this).val();
            var selectedFields=jQuery("#search_fields_settings").find("#SearchSelectedFields");
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"SearchFieldsAjax",
                    "search_module" : searchModule,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data.result);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });

        jQuery("#signature_fields_settings").on("change","#signature_module", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery(this).val();
            var selectedFields=jQuery("#signature_fields_settings").find("#SignatureSelectedFields");
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"SignatureFieldsAjax",
                    "signature_module" : searchModule,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data.result);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });


        jQuery("#display_fields_settings").on("change","#display_field_module,#userid", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery('#display_field_module').val();
            var selectedFields=jQuery("#display_fields_settings").find("#displaySelectedFields");
            var userid=jQuery('#userid').val();
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"DisplayFieldsAjax",
                    "display_field_module" : searchModule,
                    "userid" : userid,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data.result);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });

        jQuery("#signature_fields_settings").on("change","#moduleFields", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var searchModule=jQuery("#signature_fields_settings").find("#signature_module").val();
            var fields = jQuery("#signature_fields_settings").find("#moduleFields").val();
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"SignatureFieldsAjax",
                    "mode" : "get_doc_type",
                    "signature_module" : searchModule,
                    "fields":fields,
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        $("#doc_type").empty().append(data.result);
                        var selectedFields=jQuery("#signature_fields_settings").find("#SignatureSelectedFields");
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            }
        });

        getListSignature();
        getlistAssetsTracking();
        getlistDisplayFields();
        getlistSearchField();

    },
    
    registerSaveSettings:function() {
        jQuery("#vcard_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery("#vcard_fields_settings").find('#vcard_Settings');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : app.vtranslate("Field Save Successfully"),
                       text: app.vtranslate('Field Save Successfully'),
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                }
            );
        });


        jQuery("#asset_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery("#asset_fields_settings").find('#asset_Settings');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : app.vtranslate("Field Save Successfully"),
                       text: app.vtranslate('Field Save Successfully'),
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                    location.reload();
                }
            );
        });


        jQuery("#search_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery("#search_fields_settings").find('#search_Settings');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : app.vtranslate("Search Field Save Successfully"),
                       text: app.vtranslate('Search Field Save Successfully'),
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                    location.reload();
                }
            );
        });

        jQuery("#barcode_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery("#barcode_fields_settings").find('#barcode_Settings');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : app.vtranslate("Field Save Successfully"),
                       text: app.vtranslate('Field Save Successfully'),
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                }
            );
        });

        jQuery("#display_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery("#display_fields_settings").find('#display_Settings');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : app.vtranslate("Field Save Successfully"),
                       text: app.vtranslate('Field Save Successfully'),
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                }
            );
        });

        jQuery("#signature_fields_settings").on("click",".btnSaveSettings", function(e) {
            var doc_type = jQuery("#signature_fields_settings").find('#doc_type').val();
            if(doc_type == ''){
                var params = {
                    title : app.vtranslate('Please Select Document Type'),
                    text: app.vtranslate('Please Select Document Type'),
                    animation: 'show',
                    type: 'error'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }else{
                var progressIndicatorElement = jQuery.progressIndicator({
                  'position' : 'html',
                  'blockInfo' : {
                   'enabled' : true
                  }
                 });
                form = jQuery("#signature_fields_settings").find('#sign_Settings');
                var saveUrl = form.serializeFormData();
                AppConnector.request(saveUrl).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        var params = {
                           title : app.vtranslate("Field Save Successfully"),
                           text: app.vtranslate('Field Save Successfully'),
                           animation: 'show',
                           type: 'info'
                        };
                        Vtiger_Helper_Js.showPnotify(params);
                        location.reload();
                    }
                );
            }
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSelectModuleChange();
        this.registerSaveSettings(); 
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_FieldSettings_Js();
    instance.registerEvents();

    var searchListInstance = new Vtiger_SearchList_Js();
    var BasicSearchInstance = new Vtiger_BasicSearch_Js();
    BasicSearchInstance.registerEvents();
    var vtigerInstance = new Settings_Vtiger_Index_Js();
    vtigerInstance.registerEvents();

    /*var pageURL = jQuery(location).attr("href");
    var params = {};
    var query = pageURL.split('?');
    var vars = query[1].split('&');
    for (var i = 0; i < vars.length; i++) {
        var pair = vars[i].split('=');
        params[pair[0]] = decodeURIComponent(pair[1]);
    }
    
    mode = params.mode.toLowerCase();
    if(mode != ''){
        var blocks = mode+"_block";
        console.log(blocks);
        jQuery('#'+blocks).focus();
    }*/
    
});

function deleteDisplayField(id) {
    var message = app.vtranslate('Are you sure want to delete this record ?');
    app.helper.showConfirmationBox({'message' : message}).then(function(data) {
        var params = {};
        params['module'] = 'CTMobileSettings';
        params['action'] = 'getListRoute';
        params['mode'] = 'deleteDisplayField';
        params['id'] = id;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        AppConnector.request(params).then(
        function(data) {
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            if(data){
                /*var tabledata = JSON.parse(data.result);
                table.rows().remove();
                table.rows.add(
                   tabledata
                ).draw();*/ 

                getlistDisplayFields();
                
                var params = {
                   title : app.vtranslate("Record deleted successfully"),
                   text: app.vtranslate('Record deleted successfully'),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }
        });
    });
}

function deleteSignature(id) {
    var message = app.vtranslate('Are you sure want to delete this record ?');
    app.helper.showConfirmationBox({'message' : message}).then(function(data) {
        var params = {};
        params['module'] = 'CTMobileSettings';
        params['action'] = 'getListRoute';
        params['mode'] = 'deleteSignature';
        params['id'] = id;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        AppConnector.request(params).then(
        function(data) {
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            if(data){
                /*var tabledata = JSON.parse(data.result);
                table.rows().remove();
                table.rows.add(
                   tabledata
                ).draw();*/ 

                getListSignature();

                var params = {
                   title : app.vtranslate("Record deleted successfully"),
                   text: app.vtranslate('Record deleted successfully'),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }
        });
    });
}


function deleteAssetsTracking(id) {
    var message = app.vtranslate('Are you sure want to delete this record ?');
    app.helper.showConfirmationBox({'message' : message}).then(function(data) {
        var params = {};
        params['module'] = 'CTMobileSettings';
        params['action'] = 'getListRoute';
        params['mode'] = 'deleteAssetsTracking';
        params['id'] = id;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        AppConnector.request(params).then(
        function(data) {
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            if(data){
                /*var tabledata = JSON.parse(data.result);
                table.rows().remove();
                table.rows.add(
                   tabledata
                ).draw();*/ 

                getlistAssetsTracking();

                var params = {
                   title : app.vtranslate("Record deleted successfully"),
                   text: app.vtranslate('Record deleted successfully'),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }
        });
    });
}


function deleteSearchField(id) {
    var message = app.vtranslate('Are you sure want to delete this record ?');
    app.helper.showConfirmationBox({'message' : message}).then(function(data) {
        var params = {};
        params['module'] = 'CTMobileSettings';
        params['action'] = 'getListRoute';
        params['mode'] = 'deleteSearchField';
        params['id'] = id;
        var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
                'enabled' : true
            }
        });
        AppConnector.request(params).then(
        function(data) {
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
            if(data){
                /*var tabledata = JSON.parse(data.result);
                table.rows().remove();
                table.rows.add(
                   tabledata
                ).draw();*/ 

                getlistSearchField();

                var params = {
                   title : app.vtranslate("Record deleted successfully"),
                   text: app.vtranslate('Record deleted successfully'),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            }
        });
    });
}

function getListSignature(){
    var mainmodule = app.getModuleName();
    var parentmodule = app.getParentModuleName();
    var action = 'getListRoute';
    var mode = 'getlistSignature';
    var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode;
    table = jQuery('#example1').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 10,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data": "modulelabel" },
        { "data": "sign_fieldlabel" },
        { "data": "doc_type" },
        { "data": "deleteButton" }
      ]
      });

}

function getlistAssetsTracking(){
    var mainmodule = app.getModuleName();
    var parentmodule = app.getParentModuleName();
    var action = 'getListRoute';
    var mode = 'getlistAssetsTracking';
    var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode;
    table = jQuery('#example2').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 10,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data": "modulelabel" },
        { "data": "fieldlabel" },
        { "data": "deleteButton" }
      ]
      });

}

function getlistDisplayFields(){
    var mainmodule = app.getModuleName();
    var parentmodule = app.getParentModuleName();
    var action = 'getListRoute';
    var mode = 'getlistDisplayFields';
    var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode;
    table = jQuery('#example3').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 10,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data": "modulelabel" },
        { "data": "UserName" },
        { "data": "display_fieldlabel" },
        { "data": "fieldtype" },
        { "data": "deleteButton" }
      ]
      });

}

function getlistSearchField(){
    var mainmodule = app.getModuleName();
    var parentmodule = app.getParentModuleName();
    var action = 'getListRoute';
    var mode = 'getlistSearchField';
    var url = "index.php?module="+mainmodule+"&parent="+parentmodule+"&action="+action+"&mode="+mode;
    table = jQuery('#example4').DataTable({
      'paging'      : true,
      'lengthChange': false,
      'searching'   : false,
      'ordering'    : false,
      'info'        : true,
      'autoWidth'   : false,
      'pageLength' : 10,
      'processing': true,
      'serverSide': true,
      'serverMethod': 'post',
      'destroy': true,
      'ajax': {
          'url':url
      },
      "language": {
          "sProcessing": app.vtranslate('Processing'),
          "sEmptyTable": app.vtranslate('No data available in table'),
          "sInfo": app.vtranslate('Showing')+" _START_ "+app.vtranslate('to')+" _END_ "+app.vtranslate('of')+" _TOTAL_ "+app.vtranslate('entries'),
          "sInfoEmpty": app.vtranslate('Showing')+" 0 "+app.vtranslate('to')+" 0 "+app.vtranslate('of')+" 0 "+app.vtranslate('entries'),
          "oPaginate": {
              "sFirst": app.vtranslate('First'),   
              "sLast": app.vtranslate('Last'),  
              "sNext":   app.vtranslate('Next'), 
              "sPrevious": app.vtranslate('Previous'),
          },
      },
      "columns": [
        { "data": "modulelabel" },
        { "data": "fieldlabel" },
        { "data": "username" },
        { "data": "deleteButton" }
      ]
      });

}

