/* ********************************************************************************
 * The content of this file is subject to the Multiple SMTP ("License");
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is VTExperts.com
 * Portions created by VTExperts.com. are Copyright(C) VTExperts.com.
 * All Rights Reserved.
 * ****************************************************************************** */
 
 Vtiger.Class("MultiSender",{
    instance:false,
    getInstance: function(){
        if(MultiSender.instance == false){
            var instance = new MultiSender();
            MultiSender.instance = instance;
            return instance;
        }
        return MultiSender.instance;
    },
},{
    registerEventForOutgoingButton: function () {
        var thisInstance=this;
        jQuery('.btnOutgoingServer').unbind();
        jQuery('.btnOutgoingServer').on('click', function (e) {
            var currentInstance = window.app.controller();
            var url ='index.php?module=MultiSender&view=MassActionAjax&mode=showMassEditForm&userid=1&id=10';
            thisInstance.showListView(url);
        });
    },

    registerEventForEditButtons: function() {
        var thisInstance=this;
        jQuery('body').delegate('.edit_info','click',function(){
            var url_ = jQuery(this).data('url');
            $('button.close').trigger('click');
            var func= function(){ var url = url_;
                app.helper.hideModal();$('#overlayPageContent').remove();
                app.helper.showProgress();
                var params = app.convertUrlToDataParams(url);
                app.request.post({data:params}).then(
                    function (err,data) {
                        if(err == null) {
                            app.helper.hideProgress();
                            app.helper.showModal(data);
                            var form = jQuery('#outgoingMassEditContainer');
                            form.on("click","button[name='saveButton']",function(e){
                                e.preventDefault();
                                thisInstance.saveOutgoingServer(form);
                            });
                        }
                    }
                    );}; setTimeout(func, 2000);

            })
    },
    //#478958 End

    registerEventForDeleteRecord: function(){
        var thisInstance=this;
        jQuery('body').on('click','.delete_server',function(){
            var message = app.vtranslate('LBL_DELETE_CONFIRMATION');
            var url = jQuery(this).data('url');
            var userid = jQuery(this).data('userid');
            app.helper.showConfirmationBox({'message' : message}).then(
                function(){
                    thisInstance.deleteServer(url,userid);
                }
                );
        })
    },

    showListView: function (url) {
        var thisInstance = this;
        app.helper.hideModal();
        app.helper.showProgress();
        popupShown = true;
        app.request.post({'url':url}).then(function(err,resp) {
            app.helper.hideProgress();
            if(err === null) {
                app.helper.showModal(resp, {'cb' : function(modal) {
                    popupShown = false;
                }});

                thisInstance.loadListUserServer();
            }
        });
    },

    deleteServer: function (url,userid) {
        var thisInstance = this;
        app.helper.showProgress();
        app.request.post({'url':url}).then(
            function(err,data){
                if(err === null) {
                    app.helper.hideProgress();
                    var new_url = 'index.php?module=MultiSender&view=MassActionAjax&mode=showListview&userid='+userid;
                    thisInstance.showListView(new_url);
                }
            }
            );
    },

    saveOutgoingServer : function(form) {
        var thisInstance = this;
        app.helper.showProgress();
        var data = form.serializeFormData();
        data['module'] = 'MultiSender';
        data['action'] = 'SaveAjax';
        app.request.post({'data':data}).then(
            function(err,data){
                if(err === null) {
                    app.helper.hideProgress();
                    app.helper.hideModal();
                    app.helper.showSuccessNotification({'message':app.vtranslate('Outgoing Server Saved')});
                }else{
                    app.helper.hideProgress();
                    app.helper.showErrorNotification({'message':err.message});
                }
            },
            function(error) {
                app.helper.hideProgress();
                //TODO : Handle error
            }
            );
    },
    loadListUserServer: function () {
        var thisInstance = this;
        var blocks = jQuery('.blocksSortable');
        blocks.sortable({
            'revert': true,
            'connectWith': ".blocksSortable",
            'tolerance': 'pointer',
            'cursor': 'move',
            'placeholder': "state-highlight",
            'stop': function (event, ui) {
                thisInstance.updateSequence();
            }
        });
    },
    updateSequence: function () {
        var thisInstance = this;
        var params = {};
        $(".blockSortable").each(function (index) {
            //alert(index);
            params[$(this).data('id')] = {'index': index, 'column': $(this).closest('.blocksSortable').data('column')};
        });
        thisInstance.registerSaveEvent('updateSequence', {'data': params});
    },
    registerSaveEvent: function (mode, data) {
        var resp = '';
        var params = {};
        params.data = {
            module: 'MultiSender',
            view: 'MassActionAjax',
            mode: mode,
            params: data
        };
        
        params.async = true;
        
        params.dataType = 'json';
        app.request.post(params).then(
            function (err,data) {
                if(data) {
                    app.helper.showSuccessNotification({'message':data['message']});
                }
            }
            );
    },

    registerEvents: function(){
        this.registerEventForOutgoingButton();
        this.registerEventForEditButtons();
        this.registerEventForDeleteRecord();
    }
});

jQuery(document).ready(function () {
    /*var instance = new MultiSender();
    instance.registerEvents();*/
    // Does not load on edit view
    if(app.view()=='Edit') return;
    // Check enable
    var sPageURL = window.location.search.substring(1);
    var targetModule = '';
    var targetView = '';
    var targetRecord = '';
    var sURLVariables = sPageURL.split('&');
    for (var i = 0; i < sURLVariables.length; i++) {
        var sParameterName = sURLVariables[i].split('=');
        if (sParameterName[0] == 'module') {
            targetModule = sParameterName[1];
        }
        else if (sParameterName[0] == 'view') {
            targetView = sParameterName[1];
        }
        else if (sParameterName[0] == 'record') {
            targetRecord = sParameterName[1];
        }
    }
    if (targetModule == 'EmailCampaigns' && targetView == 'EmailCampaignDetails') {
        var buttonContainer = jQuery('.detailViewContainer');
        var btnToolBar = buttonContainer.find('.btn-group');
        var outGoingServerBtn = jQuery('<button type="button" class="btn btn-default btnOutgoingServer">Outgoing Server</button>');
        btnToolBar.find('.btn-default:last').before(outGoingServerBtn);

        var instance = new MultiSender();
        instance.registerEvents();
    }
});