/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit4_Js", {}, {

    step4Container: false,

    advanceFilterInstance: false,

    init: function () {
        this.initialize();
    },
    /**
     * Function to get the container which holds all the report step4 elements
     * @return jQuery object
     */
    getContainer: function () {
        return this.step4Container;
    },

    /**
     * Function to set the report step4 container
     * @params : element - which represents the report step4 container
     * @return : current instance
     */
    setContainer: function (element) {
        this.step4Container = element;
        return this;
    },

    /**
     * Function  to intialize the reports step4
     */
    initialize: function (container) {
        if (typeof container == 'undefined') {
            container = jQuery('#emailcampaigns_step4');
        }

        if (container.is('#emailcampaigns_step4')) {
            this.setContainer(container);
        } else {
            this.setContainer(jQuery('#emailcampaigns_step4'));
        }
    },

    registerSubmitEvent: function () {
        var thisInstance = this;
        var form = this.getContainer();
        form.submit(function (e) {
            //thisInstance.calculateValues();
        });
    },

    registerTestEmailButton: function () {
        var thisInstance = this;
        jQuery('.TestEmail').on('click', function (e) {
            var aDeferred = jQuery.Deferred();
            var recordId = jQuery('.recordval').val();
            var params = {
                'module': app.getModuleName(),
                'view': 'Edit',
                'mode': 'sendTestEmail',
                'record': recordId
            }

            AppConnector.request(params).then(
                    function (data) {
                        app.showModalWindow(data, function (data) {
                            //app.registerEventForTimeFields();
                            jQuery('.inviatest').on('click', function (e) {




                                var emailfield = jQuery('#txtemail').val();
                                var tfld = emailfield.replace(/^\s+/, '').replace(/\s+$/, '');
                                var emailFilter = /^[^@]+@[^@.]+\.[^@]*\w\w$/;
                                var illegalChars = /[\(\)\<\>\,\;\:\\\"\[\]]/;


                                if (emailfield == '' || !emailFilter.test(tfld) || emailfield.match(illegalChars)) {
                                    var g = {
                                        title: app.vtranslate("Warning"),
                                        type: "error",
                                        text: app.vtranslate("JS_EMAIL_ERROR")
                                    };
                                    Vtiger_Helper_Js.showPnotify(g);
                                    return false;
                                }

                                var recordId = jQuery('.recordval').val();
                                var params = {
                                    'module': app.getModuleName(),
                                    'action': "SaveAjax",
                                    'mode': 'sendetest',
                                    'testemail': emailfield,
                                    'record': recordId
                                }


                                var progressIndicatorElement = jQuery.progressIndicator({
                                    'position': 'html',
                                    'blockInfo': {
                                        'enabled': true
                                    }
                                });

                                AppConnector.request(params).then(
                                        function (data) {
                                            progressIndicatorElement.progressIndicator({
                                                'mode': 'hide'
                                            })
                                            app.hideModalWindow();
                                            if (data.result.message == "SEND_FAIL") {
                                                var msg_params = {
                                                    title: data.result.text,
                                                    type: "error"
                                                };
                                            } else {
                                                var msg_params = {
                                                    title: app.vtranslate("LBL_TEST_EMAIL"),
                                                    type: "info"
                                                };
                                            }

                                            Vtiger_Helper_Js.showPnotify(msg_params);
                                            return;
                                        }
                                );

                            })

                        });


                    }
            );

        })
    },

    registerScheduleLaterButton: function () {
        jQuery('.ScheduleLater').on('click', function (e) {
            var aDeferred = jQuery.Deferred();
            var recordId = jQuery('.recordval').val();
            var params = {
                'module': app.getModuleName(),
                'view': "Edit",
                'mode': 'schedulelater',
                'record': recordId
            }

            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });

            AppConnector.request(params).then(function (data) {
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                });
                app.showModalWindow(data, function (data) {
                    $('.timepicker').timepicker();
                    vtUtils.registerEventForTimeFields(jQuery('input#time'));
                    jQuery('.save').on('click', function (e) {
                        e.preventDefault();
                        var startdate = jQuery('#startdate').val();
                        var time = jQuery('#time').val();

                        if (startdate == '' || time == '') {
                            var g = {
                                title: app.vtranslate("Warning"),
                                type: "error",
                                text: app.vtranslate("JS_CAMPAIGN_NAME_ALREADY_EXISTS.CHOOSE_A_DIFFERENT_NAME")
                            };
                            Vtiger_Helper_Js.showPnotify(g);
                            return false;
                        }
                        var status = false;
                        if(jQuery('input[name="status"]').prop('checked') == true){
                            status = true;
                        }
                        var recordId = jQuery('.recordval').val();
                        var params = {
                            'module': app.getModuleName(),
                            'action': "SaveAjax",
                            'mode': 'schedulelatersave',
                            'startdate': startdate,
                            'time': time,
                            'record': recordId,
                            'status': status,
                            'notify_to': jQuery('select[name="notify_to"]').val(),
                            'other_notify': jQuery('input[name="other_notify"]').val()
                        };
                        var progressIndicatorElement = jQuery.progressIndicator({
                            'position': 'html',
                            'blockInfo': {
                                'enabled': true
                            }
                        });
                        $.post('index.php',params, function(response){
                            window.location = "index.php?module=EmailCampaigns&view=Detail&record=" + recordId;
                            progressIndicatorElement.progressIndicator({
                                'mode': 'hide'
                            });
                        });
                    });
                });
            });
        });
    },

    registerSendNowButton: function () {
        var thisInstance = this;
        jQuery('.SendNow').on('click', function (e) {
            var aDeferred = jQuery.Deferred();
            var recordId = jQuery('.recordval').val();
            var params = {
                'module': app.getModuleName(),
                'action': "SaveAjax",
                'mode': 'sendenow',
                'record': recordId

            }
            app.helper.showProgress();

            app.request.post({data: params}).then(function (err, data) {
                if (err === null) {
                    app.helper.showModal(data.cronInfoHtml);
                    app.helper.hideProgress();
                }
            });
        });
    },
    registerCronInfoOkButton: function () {
        jQuery(document).on('click', '.cronInfoOk', function (e) {
            app.helper.showProgress();
            app.helper.hideModal();
            window.location = jQuery(document).find('.croninfo_callbackurl').val();
        });
    },
    registerRefreshTotalStep4Click: function () {
        $(document).on('click', '.refreshTotalStep4', function (e) {
            e.preventDefault();
            var record = $('#emailcampaigns_step4').find('input[name="record"]').val();
            var params = {
                record: record,
                view: 'BasicAjax',
                mode: 'refreshTotalStep4',
                module: 'EmailCampaigns'
            };

            jQuery(".totalcount").html('<i class="fa fa-spinner fa-pulse"></i>');
            app.request.post({"data": params}).then(
                    function (err, data) {
                        if (err == null) {
                            var e = data.count;
                            jQuery(".totalcount").html(data.count);
                        } else {
                            jQuery(".totalcount").html("0");
                        }
                    });
        });
    },

    registerEvents: function () {
        var container = this.getContainer();
        this.registerSendNowButton();
        this.registerTestEmailButton();
        this.registerScheduleLaterButton();
        this.registerRefreshTotalStep4Click();
        this.registerCronInfoOkButton();
    }
});




